#pragma once

#include <d3dx9.h>
#include "stddef.h"

class Camera
{
public:

	// stores the camera positions and movement info
	CPoint OldMousePoint;	
	float XAngle;
	float ZAngle;	
	float ZoomIn; // temp variable
	float TotalZoom;
	long PanY;
	long PanX;
	D3DXVECTOR3 Eye;
	D3DXVECTOR3 At;
	D3DXVECTOR3 Orientation;
	D3DXMATRIX matProj,matView; // global reference storage

	// 2 functions that move the camera
	void AdjustCameraPosition(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius);
	void AdjustCameraPosition();	

	// selects the view type, everything but perspective gets a different rendering matrix
	enum ViewType1 {Right,Left,Front,Top, Back, Perspective} m_ViewType;
	char m_ViewTypeText[CHARSIZE];

	
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);

	void ToggleViewType(char nChar);


	Camera(void);
	~Camera(void);
	
public:
	void ResetView(void);
};
