#include "stdafx.h"
#include "S3DWindow.h"
#include "childview.h"
#include "fishmanager.h"

// this is automatically generated with the class properties
BEGIN_MESSAGE_MAP(S3DWindow, CWnd)
	//{{AFX_MSG_MAP(CMainFrame)
		ON_WM_MOUSEMOVE()
		ON_WM_SIZE()
		ON_WM_CHAR()
		ON_WM_LBUTTONDOWN()
		ON_WM_LBUTTONUP()
		//}}AFX_MSG_MAP
		ON_WM_TIMER()
END_MESSAGE_MAP()


S3DWindow::S3DWindow(void)
{
	m_pD3D = NULL;
	m_pd3dDevice = NULL;
	m_pFont = NULL;
	m_InFocusBorderColor = 0xffe4e400;
	m_bEnableView = false;

	m_FontWidth = 20;

	m_FishTexture = NULL;
	



	
}

S3DWindow::~S3DWindow(void)
{
	if (m_pFont != NULL)
		m_pFont->Release();
	if (m_FishTexture != NULL)
		m_FishTexture->Release();
}


void S3DWindow::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{		
	if (tolower(nChar) == 's')
	{
		if (m_RunSimulation)
			m_RunSimulation = false;
		else
			m_RunSimulation = true;
	}

	CWnd ::OnChar(nChar, nRepCnt, nFlags);
}


// this function inits the directx window
void S3DWindow::Init(CWnd *Parent, CRect WindowRect)
{

	// make the render window the size of the initial window
	CRect ClientRect;
	Parent->GetClientRect(&ClientRect);
	m_WindowRect = WindowRect;
	m_WindowRect.right-=4;
	m_WindowRect.bottom-=4;
	WindowRect = m_WindowRect;


	m_pParent = Parent;
	    // Set the window's initial style
    DWORD m_dwWindowStyle = WS_VISIBLE | WS_CHILD ;

	char windowname[100]; 

    strcpy_s(windowname,AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS,::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL));

    // Create the render window 
    CreateEx(WS_EX_TOPMOST,windowname,"RenderWindow",m_dwWindowStyle,m_WindowRect,Parent,NULL,NULL);

	// Create the D3D object.
    if( NULL == ( m_pD3D = Direct3DCreate9( D3D_SDK_VERSION ) ) )
	{
		AfxMessageBox("Warning can't create direct3d Device in interface");
        return;
	}

    // Get the current desktop display mode, so we can set up a back
    // buffer of the same format
    D3DDISPLAYMODE d3ddm;
    if( FAILED( m_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm ) ) )
        return;

    // Set up the structure used to create the D3DDevice
    D3DPRESENT_PARAMETERS d3dpp;
    ZeroMemory( &d3dpp, sizeof(d3dpp) );
    d3dpp.Windowed = TRUE;
    d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
	d3dpp.MultiSampleType  = D3DMULTISAMPLE_NONE;
    d3dpp.BackBufferFormat = D3DFMT_A8R8G8B8;//d3ddm.Format;
	d3dpp.hDeviceWindow    = this->m_hWnd;
	d3dpp.BackBufferWidth = m_WindowRect.Width();
	d3dpp.BackBufferHeight = m_WindowRect.Height();
	d3dpp.BackBufferCount  = 1;
	d3dpp.EnableAutoDepthStencil = true;
    d3dpp.AutoDepthStencilFormat = D3DFMT_D24S8;
    d3dpp.Flags            = D3DPRESENTFLAG_LOCKABLE_BACKBUFFER;
 
    // Create the D3DDevice
    if( FAILED( m_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, Parent->m_hWnd,
                                      D3DCREATE_HARDWARE_VERTEXPROCESSING,
                                      &d3dpp, &m_pd3dDevice ) ) )
    {
		AfxMessageBox("Warning can't create direct3d rendering Device in interface");
        return;
    }

	HRESULT blah = D3DXCreateTextureFromFileEx( m_pd3dDevice, FISHTEXTURE , 
	D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_R5G6B5, 
	D3DPOOL_DEFAULT , D3DX_FILTER_POINT , 
	D3DX_FILTER_LINEAR , 0, NULL, NULL, &m_FishTexture);



	D3DXCreateFont( m_pd3dDevice, m_FontWidth, 0, FW_BOLD, 1, FALSE, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, ""/*TEXT("Arial")*/, &m_pFont );
	
	ResetBorder(m_InFocusBorderColor);	

	CRect tRect;
	GetClientRect(tRect);

	m_bEnableView = true;

	SetTimer(0,MILLESECONDSPERTICK,0);

	m_RunSimulation = true;


}


// misc rendering effects window
 void S3DWindow::RenderWindowEffects()
{
   // draw the window border  		
    m_pd3dDevice->SetFVF(TRANSLITVERTEXTYPE);
    m_pd3dDevice->DrawPrimitiveUP(D3DPT_TRIANGLELIST,8,m_InFocusVB,sizeof(TRANSLITVERTEX)); 

	// same as in the fishes though 5 bigger on each dimension to account for fish size
	D3DXVECTOR3 c_MaxBounds = MAXWORLDBOUND;
	D3DXVECTOR3 c_MinBounds = MINWORLDBOUND;

	// increase the rendering due to the fish size
	c_MaxBounds.x += FISHRENDERSIZE;
	c_MaxBounds.y += FISHRENDERSIZE;
	c_MaxBounds.z += FISHRENDERSIZE;
	c_MinBounds.x -= FISHRENDERSIZE;
	c_MinBounds.y -= FISHRENDERSIZE;
	c_MinBounds.z -= FISHRENDERSIZE;

	// draw the outside border 
	LINEVERTEX Border[5];
	DWORD BorderColor = 0xff000000;
	int vertexcount = 0;

	LINEVERTEX *ptr = Border;	

	DirectXFormLineSquare(ptr,vertexcount,D3DXVECTOR3(c_MaxBounds.x,c_MaxBounds.y,c_MaxBounds.z),
										D3DXVECTOR3(c_MaxBounds.x,c_MinBounds.y,c_MaxBounds.z),
										D3DXVECTOR3(c_MinBounds.x,c_MinBounds.y,c_MaxBounds.z),
										D3DXVECTOR3(c_MinBounds.x,c_MaxBounds.y,c_MaxBounds.z),
										BorderColor);

	m_pd3dDevice->SetFVF(LINEVERTEX_TYPE);
    m_pd3dDevice->DrawPrimitiveUP(D3DPT_LINESTRIP,4,Border,sizeof(LINEVERTEX)); 

	ptr = Border;

	DirectXFormLineSquare(ptr,vertexcount,D3DXVECTOR3(c_MaxBounds.x,c_MaxBounds.y,c_MinBounds.z),
										D3DXVECTOR3(c_MaxBounds.x,c_MinBounds.y,c_MinBounds.z),
										D3DXVECTOR3(c_MinBounds.x,c_MinBounds.y,c_MinBounds.z),
										D3DXVECTOR3(c_MinBounds.x,c_MaxBounds.y,c_MinBounds.z),
										BorderColor);

	m_pd3dDevice->SetFVF(LINEVERTEX_TYPE);
    m_pd3dDevice->DrawPrimitiveUP(D3DPT_LINESTRIP,4,Border,sizeof(LINEVERTEX)); 

	ptr = Border;


	DirectXFormLineSquare(ptr,vertexcount,D3DXVECTOR3(c_MaxBounds.x,c_MaxBounds.y,c_MinBounds.z),
										D3DXVECTOR3(c_MaxBounds.x,c_MinBounds.y,c_MinBounds.z),
										D3DXVECTOR3(c_MaxBounds.x,c_MinBounds.y,c_MaxBounds.z),
										D3DXVECTOR3(c_MaxBounds.x,c_MaxBounds.y,c_MaxBounds.z),
										BorderColor);

	m_pd3dDevice->SetFVF(LINEVERTEX_TYPE);
    m_pd3dDevice->DrawPrimitiveUP(D3DPT_LINESTRIP,4,Border,sizeof(LINEVERTEX));

	ptr = Border;

	DirectXFormLineSquare(ptr,vertexcount,D3DXVECTOR3(c_MinBounds.x,c_MaxBounds.y,c_MinBounds.z),
										D3DXVECTOR3(c_MinBounds.x,c_MinBounds.y,c_MinBounds.z),
										D3DXVECTOR3(c_MinBounds.x,c_MinBounds.y,c_MaxBounds.z),
										D3DXVECTOR3(c_MinBounds.x,c_MaxBounds.y,c_MaxBounds.z),
										BorderColor);

	m_pd3dDevice->SetFVF(LINEVERTEX_TYPE);
    m_pd3dDevice->DrawPrimitiveUP(D3DPT_LINESTRIP,4,Border,sizeof(LINEVERTEX)); 

	RECT rct;
	rct.left=10;
	rct.right=200;
	rct.top=10;
	rct.bottom=rct.top+20;
	m_pFont->DrawText(NULL, "Press 's' to start and stop", -1, &rct, DT_LEFT|DT_NOCLIP, 0xff000000 );

	rct.top=30;
	rct.bottom=rct.top+20;
	m_pFont->DrawText(NULL, "Hold down 'ctrl' - left mouse to rotate", -1, &rct, DT_LEFT|DT_NOCLIP, 0xff000000 );

	rct.top=45;
	rct.bottom=rct.top+20;
	m_pFont->DrawText(NULL, "Hold down 'ctrl' - middle mouse to zoom", -1, &rct, DT_LEFT|DT_NOCLIP, 0xff000000 );

	rct.top=60;
	rct.bottom=rct.top+20;
	m_pFont->DrawText(NULL, "Hold down 'ctrl' - right mouse to pan", -1, &rct, DT_LEFT|DT_NOCLIP, 0xff000000 );







}

//////////////////////////////////////////////////////////////////////
// DirectXFormSquare(TLNVERTEXSTRUCT *&pVertex, int &VertexCount, Point3 v1, Point3 v2, Point3 v3, Point3 v4)
//
// Helper function forms a square out of 4 vertices
// Render the box using direct x
//
//
// by convention for texturing (x,y) = (u,v)
// v1 is top left (0,0)
// v2 is top right (1,0)
// v3 is bottom right (1,1)
// v4 is bottom left (0,1)
//////////////////////////////////////////////////////////////////////
void S3DWindow::DirectXFormLineSquare(LINEVERTEX *&pVertex, int &VertexCount, D3DXVECTOR3 v1, D3DXVECTOR3 v2, D3DXVECTOR3 v3, D3DXVECTOR3 v4, DWORD Color)
{
	// render the box here as 
	pVertex[0].x = (float)v1.x;
	pVertex[0].y = (float)v1.y;
	pVertex[0].z = (float)v1.z;
	pVertex[0].color = Color;

	pVertex[1].x = (float)v2.x;
	pVertex[1].y = (float)v2.y;
	pVertex[1].z = (float)v2.z;	
	pVertex[1].color = Color;

	pVertex[2].x = (float)v3.x;
	pVertex[2].y = (float)v3.y;
	pVertex[2].z = (float)v3.z;	
	pVertex[2].color = Color;

	pVertex[3].x = (float)v4.x;
	pVertex[3].y = (float)v4.y;
	pVertex[3].z = (float)v4.z;	
	pVertex[3].color = Color;

	pVertex[4].x = (float)v1.x;
	pVertex[4].y = (float)v1.y;
	pVertex[4].z = (float)v1.z;
	pVertex[4].color = Color;

	VertexCount += 4;
	pVertex+=5;
	

}


// call this function to render
void S3DWindow::Render()
{
	
	m_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(75,137,252), 1.0f, 0 );

    // Begin the scene
    if (SUCCEEDED(m_pd3dDevice->BeginScene())) {

		D3DXMATRIX matWorld,matWorld1;
		D3DXMatrixIdentity( &matWorld);

		m_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );

		// change the camera based on user input		
		m_Camera.AdjustCameraPosition();

		D3DXVECTOR3 RobotPosition;
		
		
		D3DXMatrixLookAtLH( &m_Camera.matView, 
							&m_Camera.Eye,	// Current camera position
                   			&m_Camera.At ,	// Look at position
							&m_Camera.Orientation) ;// Orientation 
	

	
		m_pd3dDevice->SetTransform( D3DTS_VIEW, &m_Camera.matView );


		// get aspect ratio
		CRect ClientRect;
		GetClientRect(&ClientRect);
		float Aspect = (float)ClientRect.Width()/(float)ClientRect.Height();
	
		D3DXMatrixPerspectiveFovLH( &m_Camera.matProj, D3DX_PI/4, Aspect, 0.2f, 1000.0f );		
		m_pd3dDevice->SetTransform( D3DTS_PROJECTION, &m_Camera.matProj );
		

	   //	m_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);	// Wireframe for dubugging
		m_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);

		// Turn off culling, so we see the front and back of the triangle
		m_pd3dDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
		//	m_pd3dDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_CCW );

	   // Turn off D3D lighting, since we are providing our own vertex colors
	   m_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
	   // m_pd3dDevice->SetRenderState( D3DRS_SPECULARENABLE, FALSE);

	   m_pd3dDevice->SetRenderState( D3DRS_DITHERENABLE,   TRUE );
	   //m_pd3dDevice->SetRenderState( D3DRS_SPECULARENABLE, TRUE );
	   m_pd3dDevice->SetRenderState( D3DRS_SHADEMODE  , D3DSHADE_GOURAUD );

	   m_pd3dDevice->SetRenderState(D3DRS_ZENABLE  , D3DZB_USEW );
	   m_pd3dDevice->SetRenderState(D3DRS_ZENABLE  ,  D3DZB_TRUE  );
	   // m_pd3dDevice->SetRenderState(D3DRS_ZENABLE  ,  D3DZB_FALSE  );
	
	 
		RenderWindowEffects();

		m_pd3dDevice->SetTexture(0,m_FishTexture);

		TheFishManager.RenderFishes(m_pd3dDevice);
	
		m_pd3dDevice->SetTexture(0,NULL);	// No Texture

	

		m_pd3dDevice->EndScene();

			// Present the backbuffer contents to the display
			
	

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

		
	}

}

void S3DWindow::OnMouseMove(UINT nFlags, CPoint Point)
{
	
	m_Camera.OnMouseMove(nFlags,Point);
		
	
//	g_pInterface->RenderViews();
//	Render();
}

// when the window has been resized
void S3DWindow::OnSize(UINT nType, int cx, int cy) 
{

	CWnd::OnSize(nType, cx, cy);

}

//==========================================================
// DiResetBorder(DWORD color)
//
// reset the billboarded border of the window
//==========================================================
void S3DWindow::ResetBorder(DWORD color)
{
	TRANSLITVERTEX* pVertices1 = m_InFocusVB;	

	int borderWidth = 3;
	CRect rect,clientRect;

	GetClientRect(&clientRect);

	clientRect.bottom -=0;
	clientRect.right -=0;

	// top bar
	rect.top = clientRect.top;
	rect.bottom = clientRect.top+borderWidth;
	rect.left = clientRect.left;
	rect.right = clientRect.right;

	DirectXFormRect(pVertices1,rect,color);

	// bottom bar
	rect.top = clientRect.bottom-borderWidth;
	rect.bottom = clientRect.bottom;
	rect.left = clientRect.left;
	rect.right = clientRect.right;

	DirectXFormRect(pVertices1,rect,color);

	// left bar
	rect.top = clientRect.top + borderWidth;
	rect.bottom = clientRect.bottom-borderWidth;
	rect.left = clientRect.left;
	rect.right = clientRect.left + borderWidth;

	DirectXFormRect(pVertices1,rect,color);

	// right bar
	rect.top = clientRect.top + borderWidth;
	rect.bottom = clientRect.bottom-borderWidth;
	rect.left = clientRect.right -borderWidth;
	rect.right = clientRect.right;

	DirectXFormRect(pVertices1,rect,color);

}

//==========================================================
// DirectXFormRect(TRANSLITVERTEX *&pVertex, CRect rect)
//
// Forms a billboarded square.
//==========================================================
void S3DWindow::DirectXFormRect(TRANSLITVERTEX *&pVertex, CRect rect, DWORD color)
{
	pVertex->x = (float)rect.left;
	pVertex->y = (float)rect.top;
	pVertex->z = 0.9f;
	pVertex->rhw = 1.0f;
	pVertex->Diffuse = color;
	pVertex++;

	pVertex->x = (float)rect.right;
	pVertex->y = (float)rect.top;
	pVertex->z = 0.9f;
	pVertex->rhw = 1.0f;
	pVertex->Diffuse = color;
	pVertex++;

	pVertex->x = (float)rect.right;
	pVertex->y = (float)rect.bottom;
	pVertex->z = 0.9f;
	pVertex->rhw = 1.0f;
	pVertex->Diffuse = color;
	pVertex++;

	pVertex->x = (float)rect.right;
	pVertex->y = (float)rect.bottom;
	pVertex->z = 0.9f;
	pVertex->rhw = 1.0f;
	pVertex->Diffuse = color;
	pVertex++;

	pVertex->x = (float)rect.left;
	pVertex->y = (float)rect.bottom;
	pVertex->z = 0.9f;
	pVertex->rhw = 1.0f;
	pVertex->Diffuse = color;
	pVertex++;

	pVertex->x = (float)rect.left;
	pVertex->y = (float)rect.top;
	pVertex->z = 0.9f;
	pVertex->rhw = 1.0f;
	pVertex->Diffuse = color;
	pVertex++;
}


void S3DWindow::OnLButtonDown(UINT nFlags, CPoint point)
{
	//theInterface.GetFocus(ViewWindowIndex);
	m_Camera.OldMousePoint = point;


CWnd::OnLButtonDown(nFlags,point);

}

void S3DWindow::OnLButtonUp(UINT nFlags, CPoint point)
{
//	if (m_EnableAxisMove)
	//	m_AxisMove.OnLButtonUp(nFlags,point);

	CWnd::OnLButtonUp(nFlags,point);
}


void S3DWindow::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default

	if (m_RunSimulation)
		TheFishManager.MoveFishes();
	Render();

	CWnd::OnTimer(nIDEvent);
}
