// UAxisDisplay.cpp: implementation of the UAxisDisplay class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "UAxisDisplay.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

UAxisDisplay::UAxisDisplay()
{
	m_pFont = NULL;

	m_XAxisColor = 0xffff0000;
	m_YAxisColor = 0xff00ff00;
	m_ZAxisColor = 0xff0000ff;

	m_CenterPoint.x = 50;
	m_CenterPoint.y = 300;
	m_AxisLength = 30.0f;

}

UAxisDisplay::~UAxisDisplay()
{
}

//===================================================================
// SetTransformationMatrix(D3DXMATRIX matrixView)
//
// This function sets the transformation matrix of the camera and calculates the
// 2d points for the axis
//
//===================================================================
void UAxisDisplay::SetTransformationMatrix(D3DXMATRIX matrixView)
{
	D3DXVECTOR3 tempo1;
	CPoint offsetPoint;

	// rotate by 180 which is how much the matrix if off by
	D3DXMATRIX rot;
	D3DXMatrixRotationY(&rot,3.14f);
	matrixView = matrixView*rot;
	m_TMMatrix = matrixView; // copy it over just for the heck of it
	// first calculate the offset point that we will use to center the axis
	// on the screen
	tempo1.x = 0;
	tempo1.y = 0;
	tempo1.z = 0;
	D3DXVECTOR4 out;
	D3DXVec3Transform(&out,&tempo1,&matrixView);
	offsetPoint.x = (long)out.x;
	offsetPoint.y = (long)out.y;
	offsetPoint = m_CenterPoint - offsetPoint;

	// k now find the xaxis end point
	tempo1.x = m_AxisLength;
	tempo1.y = 0;
	tempo1.z = 0;
	D3DXVec3Transform(&out,&tempo1,&matrixView);
	m_XAxisEnd.x = (long)out.x + offsetPoint.x;
	m_XAxisEnd.y = (long)out.y + offsetPoint.y;

	// k now find the yaxis end point
	tempo1.x = 0;
	tempo1.y = -m_AxisLength;
	tempo1.z = 0;
	D3DXVec3Transform(&out,&tempo1,&matrixView);
	m_YAxisEnd.x = (long)out.x + offsetPoint.x;
	m_YAxisEnd.y = (long)out.y + offsetPoint.y;

	// k now find the zaxis end point
	tempo1.x = 0;
	tempo1.y = 0;
	tempo1.z = m_AxisLength;
	D3DXVec3Transform(&out,&tempo1,&matrixView);
	m_ZAxisEnd.x = (long)out.x + offsetPoint.x;
	m_ZAxisEnd.y = (long)out.y + offsetPoint.y;


	TRANSLITVERTEX* pVertices = m_LineVB;

	TRANSLITVERTEX CenterPoint;
	

	// the center point
	pVertices->x = (float)m_CenterPoint.x;
	pVertices->y = (float)m_CenterPoint.y;
	pVertices->z = 0.9f;
	pVertices->rhw = 1.0f;
	pVertices->Diffuse = m_XAxisColor;	
	CenterPoint = *pVertices;
	pVertices++;

	// the x axis point
	pVertices->x = (float)m_XAxisEnd.x;
	pVertices->y = (float)m_XAxisEnd.y;
	pVertices->z = 0.9f;
	pVertices->rhw = 1.0f;
	pVertices->Diffuse = m_XAxisColor;
	pVertices++;

	*pVertices = CenterPoint;
	pVertices->Diffuse = m_YAxisColor;
	pVertices++;

	// the y axis point
	pVertices->x = (float)m_YAxisEnd.x;
	pVertices->y = (float)m_YAxisEnd.y;
	pVertices->z = 0.9f;
	pVertices->rhw = 1.0f;
	pVertices->Diffuse = m_YAxisColor;
	pVertices++;

	*pVertices = CenterPoint;
	pVertices->Diffuse = m_ZAxisColor;
	pVertices++;

	// the z axis point
	pVertices->x = (float)m_ZAxisEnd.x;
	pVertices->y = (float)m_ZAxisEnd.y;
	pVertices->z = 0.9f;
	pVertices->rhw = 1.0f;
	pVertices->Diffuse = m_ZAxisColor;
	pVertices++;

	//tempo = temp1*tempo;
}

//===================================================================
// Render()
//
// This function renders the axis on the screen
//
//
//===================================================================
void UAxisDisplay::Render()
{
	m_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
	m_pd3dDevice->SetTexture(0,NULL);
	m_pd3dDevice->SetFVF(TRANSLITVERTEXTYPE);
	m_pd3dDevice->DrawPrimitiveUP(D3DPT_LINELIST,3,m_LineVB,sizeof(TRANSLITVERTEX)); 
	
	float YOffset = -20.0f;
	RECT rct;
	rct.left=m_XAxisEnd.x;
	rct.right=rct.left+20;
	rct.top=m_XAxisEnd.y+ YOffset;
	rct.bottom=rct.top+20;
	m_pFont->DrawText(NULL, "x", -1, &rct, DT_LEFT|DT_NOCLIP, m_XAxisColor );

	rct.left=m_YAxisEnd.x;
	rct.right=rct.left+20;
	rct.top=m_YAxisEnd.y+ YOffset;
	rct.bottom=rct.top+20;
	m_pFont->DrawText(NULL, "y", -1, &rct, DT_LEFT|DT_NOCLIP, m_YAxisColor );

	rct.left=m_ZAxisEnd.x;
	rct.right=rct.left+20;
	rct.top=m_ZAxisEnd.y+ YOffset;
	rct.bottom=rct.top+20;
	m_pFont->DrawText(NULL, "z", -1, &rct, DT_LEFT|DT_NOCLIP, m_ZAxisColor );

}

//===================================================================
// init(LPDIRECT3DDEVICE8 g_pd3dDevice)
//
// inits the class
//
//
//===================================================================
void UAxisDisplay::init(LPDIRECT3DDEVICE pd3dDevice,  CPoint CenterPoint, int AxisSize)
{

	m_pd3dDevice = pd3dDevice;
	m_CenterPoint = CenterPoint;
	m_AxisLength = AxisSize;	

	D3DXCreateFont( m_pd3dDevice, 12, 0, FW_BOLD, 1, FALSE, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, ""/*TEXT("Arial")*/, &m_pFont );

}
