// UAxisDisplay.h: interface for the UAxisDisplay class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UAXISDISPLAY_H__6517CC1D_8C73_4C78_868E_89A6A7AB9CEA__INCLUDED_)
#define AFX_UAXISDISPLAY_H__6517CC1D_8C73_4C78_868E_89A6A7AB9CEA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


// This class displays the axis on the screen close to what 3ds max does
#include <d3dx9.h>
#include "D3dx9core.h"
#include "stddef.h"

class UAxisDisplay
{
public:

	// size of the axis (2d)
	float m_AxisLength;

	// this must be called before anything else is called
	void init(LPDIRECT3DDEVICE pd3dDevice, CPoint CenterPoint, int AxisSize);

	// call to render
	void Render();
	// this must be called before render so it can reset its orientation
	void SetTransformationMatrix(D3DXMATRIX matrixView);

	
	CPoint m_CenterPoint; // the center point of the 2d display location
	CPoint m_XAxisEnd,m_YAxisEnd,m_ZAxisEnd;
	DWORD m_XAxisColor,m_YAxisColor,m_ZAxisColor;

	D3DXMATRIX m_TMMatrix; // the transformation matrix   

	TRANSLITVERTEX m_LineVB[6];

	UAxisDisplay();
	virtual ~UAxisDisplay();

	LPDIRECT3DDEVICE       m_pd3dDevice; // the rendering device

	LPD3DXFONT  m_pFont;   // font used for drawing text


};

#endif // !defined(AFX_UAXISDISPLAY_H__6517CC1D_8C73_4C78_868E_89A6A7AB9CEA__INCLUDED_)
