#ifndef STDDEF_H
#define STDDEF_H

#include "math.h"

////////////////////////////////////////////////////////////
// constant stuff to alter this program
#define MAXFISHMOVEMENTSPEED D3DXVECTOR3(1,.05f,1) // this is the max fish speed per tick
#define MAXFISHMOVEMENTTIME 30*5 // this is the max time which the fish will change direction

// size of the world
#define MAXWORLDBOUND D3DXVECTOR3(100,50,100)
#define MINWORLDBOUND D3DXVECTOR3(-100,0,-100)

#define FISHRENDERSIZE 5
#define NUMBEROFFISH 100
#define FISHTEXTURE "Fish.bmp"
#define MILLESECONDSPERTICK 30 // to increase the simulations per second reduce this number

#define CHARSIZE 255

#define ABS(x) if (x < 0) x = -x;

// redefined so when switching versions of directx this is the onlything that needs to be changed
#define LPDIRECT3D LPDIRECT3D9
#define LPDIRECT3DDEVICE LPDIRECT3DDEVICE9
#define LPDIRECT3DVERTEXBUFFER LPDIRECT3DVERTEXBUFFER9
#define LPDIRECT3DSWAPCHAIN LPDIRECT3DSWAPCHAIN9
#define LPDIRECT3DSURFACE LPDIRECT3DSURFACE9
#define LPDIRECT3DTEXTURE LPDIRECT3DTEXTURE9
#define D3DVIEWPORT D3DVIEWPORT9
#define LPDIRECT3DINDEXBUFFER LPDIRECT3DINDEXBUFFER9

#define LUTSIZE 10
const DWORD ColorLut[] = {RGB(179,231,69),
						RGB(71,228,205),
						RGB(221,86,79),
						RGB(70,162,68),
						RGB(158,95,186),
						RGB(225,55,106),
						RGB(158,48,233),
						RGB(231,247,34),
						RGB(131,165,116),
						RGB(207,143,73)};



#define PI 3.1415
#define SMALLE 0.0001f // small error e.g round off error


#define TRANSLITVERTEXTYPE  (D3DFVF_XYZRHW | D3DFVF_DIFFUSE)

struct TRANSLITVERTEX {
    float x, y;      // screen position    
    float z;         // Z-buffer depth    
    float rhw;       // reciprocal homogeneous W    
    DWORD Diffuse;   // diffuse color  
}; 

// A structure for our custom vertex type
struct TEXTUREDVERTEXSTRUCT
{
    FLOAT x, y, z;      // The untransformed, 3D position for the vertex
    DWORD color;        // The vertex color
	FLOAT tu,tv;
};

// Our custom FVF, which describes our custom vertex structure
#define TEXTUREDVERTEX (D3DFVF_XYZ|D3DFVF_DIFFUSE |D3DFVF_TEX1 )


// for line vertices
#define LINEVERTEX_TYPE  (D3DFVF_XYZ|D3DFVF_DIFFUSE)

struct LINEVERTEX
{
	float x,y,z; // Object space position for the vertex.
	DWORD color;
};

// Our custom FVF, which describes our custom vertex structure
#define TLNVERTEX (D3DFVF_XYZ| D3DFVF_NORMAL |D3DFVF_TEX2|D3DFVF_DIFFUSE |D3DFVF_SPECULAR ) //|D3DFVF_TEX0)

// Our custom FVF, which describes our custom vertex structure
#define D3DFVF_CUSTOMVERTEX (D3DFVF_XYZ|D3DFVF_DIFFUSE)


// A structure for our custom vertex type
struct CUSTOMVERTEX
{
    FLOAT x, y, z;      // The untransformed, 3D position for the vertex
    DWORD color;        // The vertex color
};

#endif