using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Collections;


namespace FTPBackup
{
    
    class XMLStorage
    {
        static String filename;
        public static String FTPName;
        public static String FTPUserName;
        public static String FTPPassword;
        public static String FTPBackupDirectory;
        public static DateTime BackupTime;

        const int SCRAMBLE = 10; // used to scramble the xml password

        const int MAXDIRECTORY = 10;

        public struct dirInfo {
            public String directory;
            public String recursesub;
        };
        public static ArrayList saveDirectories;

        /// <summary>
        /// This should be called when the program starts
        /// </summary>
        static public void ConfigXMLStorage()
        {
            filename = "FTPStorage.xml";
            FTPName = "Need ftp name";
            FTPUserName = ".";
            FTPPassword = ".";
            FTPBackupDirectory = ".";
            BackupTime = DateTime.Now;
            XMLStorage.saveDirectories = new ArrayList();
            LoadXMLData();
        }

       /// <summary>
       /// Saves the information to an xml file
       /// </summary>
        static public void SaveXML()
        {                      
            XmlWriter writer = XmlWriter.Create(filename);
            writer.WriteStartElement("FTPServer");
            writer.WriteElementString("FTPName", FTPName);
            writer.WriteElementString("FTPUserName", FTPUserName);
            // scramble up the string here
            String scramble = " ";
            char[] tchar = new char[100] ;
            tchar[0] = '0';

            tchar = FTPPassword.ToCharArray();

            for (int ix = 0; ix < FTPPassword.Length; ix++)
            {
                tchar[ix] = (char)(tchar[ix] + SCRAMBLE);
            }

            scramble = new String(tchar);

            writer.WriteElementString("FTPPassword", scramble);
            writer.WriteElementString("FTPBackupDirectory", FTPBackupDirectory);          
            writer.WriteElementString("LastBackup", BackupTime.ToString());
           
            //writer.WriteStartElement("SaveDirectories");
            dirInfo enumlist;
            for (int ix = 0; ix < saveDirectories.Count; ix++)
            {
               // writer.WriteStartElement("Entry");
                enumlist = (dirInfo)saveDirectories[ix];
                writer.WriteElementString("Directory", enumlist.directory);
                writer.WriteElementString("RecurseSubDirectory", enumlist.recursesub);
                //writer.WriteEndElement();
            }
            writer.WriteEndElement();
            writer.Close();
        }

        /// <summary>
        /// Load data from the xml file
        /// </summary>
        static public void LoadXMLData()
        {

            int count = 0;
            XmlReader reader;
            try
            {
                reader = XmlReader.Create(filename);
                reader.ReadStartElement();
                FTPName = reader.ReadElementString();
                FTPUserName = reader.ReadElementString();

                // unscramble the password
                String scramble = reader.ReadElementString();
                char[] tchar = new char[100];
                tchar[0] = '0';
                tchar = scramble.ToCharArray();
                for (int ix = 0; ix < scramble.Length; ix++)
                {
                    tchar[ix] = (char)(tchar[ix] - SCRAMBLE);
                }              
                FTPPassword = new String(tchar);

                FTPBackupDirectory = reader.ReadElementString();
                string temp = reader.ReadElementString();
                BackupTime = DateTime.Parse(temp);

                count++;
                //reader.ReadStartElement();

                dirInfo enumadd;
                XMLStorage.saveDirectories.Clear();

                bool done = false;
                while (reader.Read())
                {
                   // reader.ReadStartElement();
                  
                    enumadd.directory = reader.ReadString();
                    if (enumadd.directory != "")
                    {
                        done = reader.Read();
                        enumadd.recursesub = reader.ReadString();
                        saveDirectories.Add(enumadd);
                    }
                }                 
                reader.Close();
            }
            catch
            {
                // right.. make a new file
              if (count == 0)
                    SaveXML();              
            }
        }
        
    }
   
}
