#include "StdAfx.h"
#include "Space.h"

Space::Space(void)
{
}


//==========================================================================
// int Init(int xmax, int ymax)
//
//
// This function inits the space.  It just resets the array basically
//
//
//
//==========================================================================
void Space::Init(int xmax, int ymax)
{
	int ix,iy;

	if (xmax > MAXX)
		xmax = MAXX;
	if (ymax > MAXY)
		ymax = MAXY;

	m_xmax = xmax;
	m_ymax = ymax;
	for (ix = 0; ix < m_xmax; ix++)
	{
		for (iy = 0; iy < m_ymax; iy++)
		{
			m_aIndices[ix][iy] = NOPERSON;
		}
	}
}


//==========================================================================
// bool GetIndex(int x, int y, int &index)
//
//
// returns an index given and x,y coordinate.  Returns true if the index value is
//   valid
//
//
//==========================================================================
bool Space::GetIndex(int x, int y, int &index)
{
	if (x >= m_xmax)
		return false;
	if (y >= m_ymax)
		return false;
	if (x < 0)
		return false;
	if (y < 0)
		return false;

	if (m_aIndices[x][y] != NOPERSON)
	{
		index =  m_aIndices[x][y];
		return true;
	}

	return false;



}

//==========================================================================
// void SetPerson(int x, int y, int pindex)
//
//
// Assumes all the sanity checks are done
//
//
//==========================================================================
void Space::SetPerson(int x, int y, int pindex)
{
	m_aIndices[x][y] = pindex;
}


//==========================================================================
// bool IsFree(int x,int y)
//
//
// returns true if the space is free, false otherwise
//
//
//==========================================================================
bool Space::IsFree(int x,int y)
{
	//System.out.printf("in space %d %d",x,y);
	if (x >= m_xmax)
		return false;
	if (y >= m_ymax)
		return false;
	if (x < 0)
		return false;
	if (y < 0)
		return false;
	if (m_aIndices[x][y] == NOPERSON)
	{
		return true;
	}
	return false;
}


//==========================================================================
// bool MovePerson(int oldx, int oldy, int &newx, int &newy)
//
//
// moves a person from a given point to another point.  If returns true
// the person got moved... if returned false the person can't move to the new space
//
// newx and newy are returned in case the edges are hit to there values are the correct ones if
//  the function is true
//==========================================================================
bool Space::MovePerson(int oldx, int oldy, int &newx, int &newy)
{
	if (oldx < 0 || oldx > m_xmax)
		return false;

	if (oldy < 0 || oldy > m_ymax)
		return false;

	int index = m_aIndices[oldx][oldy];
	if (index == NOPERSON)
		return false;

	if (newx < 0)
		newx = oldx;
	if (newx > m_xmax)
		newx = oldx;
	if (newy > m_ymax)
		newy = oldy;
	if (newy > m_ymax)
		newy = oldy;

	
	if (!IsFree(newx,newy))
		return false;

	// clear the old space
	m_aIndices[oldx][oldy] = NOPERSON;
	m_aIndices[newx][newy] = index;

	

	return true;
}