// percDlg.cpp : implementation file
//

#include "stdafx.h"
#include "perc.h"
#include "percDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL



// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPercDlg dialog

CPercDlg::CPercDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPercDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPercDlg)
	m_RDivider = 0;
	m_Longevity = 0;
	m_SMultiplier = 0;
	m_SpeedMultiplier = 0;
	m_TotalPeople = 0;
	m_FRBottom = 0;
	m_FRLeft = 0;
	m_FRRight = 0;
	m_FRTop = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPercDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPercDlg)
	DDX_Text(pDX, IDC_DIVIDER, m_RDivider);
	DDV_MinMaxInt(pDX, m_RDivider, 1, 10);
	DDX_Text(pDX, IDC_LONGEVITY, m_Longevity);
	DDV_MinMaxInt(pDX, m_Longevity, 1, 200);
	DDX_Text(pDX, IDC_MULTIPLIER, m_SMultiplier);
	DDV_MinMaxInt(pDX, m_SMultiplier, 1, 10);
	DDX_Text(pDX, IDC_SMultiplier, m_SpeedMultiplier);
	DDV_MinMaxInt(pDX, m_SpeedMultiplier, 1, 4);
	DDX_Text(pDX, IDC_TPEOPLE, m_TotalPeople);
	DDV_MinMaxInt(pDX, m_TotalPeople, 1, 500000);
	DDX_Text(pDX, IDC_FRBOTTOM, m_FRBottom);
	DDV_MinMaxInt(pDX, m_FRBottom, 0, 600);
	DDX_Text(pDX, IDC_FRLEFT, m_FRLeft);
	DDV_MinMaxInt(pDX, m_FRLeft, 0, 600);
	DDX_Text(pDX, IDC_FRRIGHT, m_FRRight);
	DDV_MinMaxInt(pDX, m_FRRight, 0, 600);
	DDX_Text(pDX, IDC_FRTOP, m_FRTop);
	DDV_MinMaxInt(pDX, m_FRTop, 0, 600);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPercDlg, CDialog)
	//{{AFX_MSG_MAP(CPercDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_Restart, OnRestart)
	ON_BN_CLICKED(IDC_AdjustSettings, OnAdjustSettings)
	ON_BN_CLICKED(IDC_StartFire, OnStartFire)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPercDlg message handlers

BOOL CPercDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// initialize all the dialog gui stuff
	m_Longevity = 75;
	m_RDivider = 1;
	m_SMultiplier = 1;
	m_SpeedMultiplier = 1;
	m_TotalPeople = 10000;
	m_FRLeft = 0;
	m_FRTop = 0;
	m_FRRight = 100;
	m_FRBottom = 100;
	this->UpdateData(false);

	// creates the initial setup
	theMainClass.SetLongevity(m_Longevity);
	theMainClass.Init(m_TotalPeople);
	SetTimer(0,50,0);
	m_renderingx = m_renderingy = 430;

	this->SetWindowText("Perculation Simluation");
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPercDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// does the painting
void CPercDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
	
		CPaintDC dc(this); // device context for painting	

		// create the double buffer stuff over here
		CDC memdc;
		memdc.CreateCompatibleDC(&dc);
		CBitmap membitmap;
		membitmap.CreateCompatibleBitmap(&dc,m_renderingx,m_renderingy);
		CBitmap *oldBitmap=(CBitmap *)memdc.SelectObject(&membitmap);
		// end doubel buffer stuff

		// clear the double buffer
		CBrush whitebrush;
		whitebrush.CreateSolidBrush(RGB(255,255,255));
		memdc.FillRect(CRect(0,0,m_renderingx,m_renderingy),&whitebrush);

		// send the double buffer for rendering
		theMainClass.Render(memdc);
		
		// blit the double buffer
		dc.BitBlt(0,0,m_renderingx,m_renderingy,&memdc,0,0,SRCCOPY);

		CDialog::OnPaint();


	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPercDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

static int rcounter = 0;
void CPercDlg::OnTimer(UINT nIDEvent) 
{
	
	int ix;

	for (ix = 0; ix < m_SMultiplier; ix++)
		theMainClass.RunSimulation();

	rcounter++;
	if (rcounter >= m_RDivider)
	{
		CRect rect(0,0,m_renderingx,m_renderingy);
		InvalidateRect(rect,false);
		rcounter = 0;
	}
	
	CDialog::OnTimer(nIDEvent);
}

void CPercDlg::OnRestart() 
{
	this->UpdateData(true);
	theMainClass.SetSpeedMultiplier(m_SpeedMultiplier);
	theMainClass.SetLongevity(m_Longevity);	
	theMainClass.Init(m_TotalPeople);
}

void CPercDlg::OnAdjustSettings() 
{
	// load the data from the dialog
	this->UpdateData(true);
	theMainClass.SetSpeedMultiplier(m_SpeedMultiplier);
	theMainClass.SetLongevity(m_Longevity);


	
}

void CPercDlg::OnStartFire() 
{
	// TODO: Add your control notification handler code here
	this->UpdateData(true);
	theMainClass.StartFire(CRect(m_FRLeft,m_FRTop,m_FRRight,m_FRBottom));
	
}
