// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "ProtocalSim.h"
#include "ChildView.h"
#include "NetworkStats.h"
#include "TestNetwork.h"
#include "FtpNetwork.h"
#include "StreamingNetwork.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
	m_pNetwork = new StreamingNetwork;
//	m_pNetwork = new TestNetwork;
	m_pNetwork->Init();
	simThreadInfo.EndSimThread = true;
}

CChildView::~CChildView()
{
	if (m_pNetwork != NULL)
		delete m_pNetwork;
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_CHAR()
	ON_WM_DESTROY()
	ON_COMMAND(ID_START_THREAD, OnStartThread)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	if (simThreadInfo.EndSimThread)	
		dc.TextOut(0,0,"Sim Stopped");
	else
		dc.TextOut(0,0,"Sim Running");

	char tChar[100];
	if (m_pNetwork->TType == Network::TTYPE::MultiRun)
	{
		sprintf(tChar,"Multi Run: Run number %d/%d",m_pNetwork->m_nSaveStats,m_pNetwork->m_NumMultiRuns);
	}
	else if (m_pNetwork->TType == Network::TTYPE::ContRun)
	{
		sprintf(tChar,"Continous Run");
	}
	dc.TextOut(0,15,tChar);



	if (m_pNetwork->CanDraw())
	{
		// now display the time
		char tempo[200];
		sprintf(tempo,"Sim Time in Seconds %d    ",m_pNetwork->SGetSeconds());
		dc.TextOut(0,30,tempo);



		dc.TextOut(0,45,"Press ""s"" to start and stop simulation");

		CPoint Offset = CPoint(0,45);
		g_NetworkStats.DrawPhyStats(&dc,Offset);
		/*PhysicalLayer::STATISTICS Stats;
		m_pNetwork->SGetStats(Stats);

		sprintf(tempo,"Max Bit Rate %13d Actual Bit Rate %13d Idle Bit Rate %13d         ",Stats.p_MaxBitRate,Stats.p_ActualBitRate,Stats.p_IdleBitRate);
		dc.TextOut(0,45,tempo);

		int ActualRate = Stats.p_MaxBitRate - Stats.p_IdleBitRate; 
		float Eff = 100.0f*(float)Stats.p_ActualBitRate/(float)ActualRate;

		sprintf(tempo,"Efficiency: %8.4f  Avg Efficiency: %8.4f Avg WaitTime: %10.2f AvgResends = %5.2f "
			,Stats.p_CurrEfficiency,Stats.p_AvgEfficiency,Stats.n_AvgWaitTime,Stats.n_AvgResends);
		dc.TextOut(0,60,tempo);

		sprintf(tempo,"AvgSent: %10.2f AvgDropped: %10.2f  AvgMissed: %10.2f",
			Stats.n_AvgSent,Stats.n_AvgDropped,Stats.n_AvgMissed);
		dc.TextOut(0,75,tempo);

*/
		CRect ClientRect;
		GetClientRect(&ClientRect);

		// now draw the processes stats
	//	CPoint Offset = Offset;
		for (int ix = 0; ix < m_pNetwork->m_NumProcesses; ix++)
		{
			m_pNetwork->m_aProcess[ix]->DrawStats(&dc,Offset);			
			if (Offset.y > ClientRect.Height()- 30)
			{
				Offset.y = 115;
				Offset.x += 450;
			}
		}

		StatsGraph.SetValue((float)m_pNetwork->SGetSeconds(),g_NetworkStats.avgPhyLayerStats.eDataFrames);
		StatsGraph.Invalidate(false);
	}
}


int CChildView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd ::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	StatsGraph.InitDisplay(CPoint(200,200),this);
	
	return 0;
}

void CChildView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar == 'g')
		StatsGraph.ToggleDisplay();
	
	CWnd ::OnChar(nChar, nRepCnt, nFlags);
}

void CChildView::OnDestroy() 
{
	CWnd ::OnDestroy();
	
	if (!simThreadInfo.EndSimThread)
	{
		HANDLE hThread[2];
        hThread[0] = simThreadInfo.SimThreadPtr->m_hThread;

         // wait for the threads to end
        ::WaitForMultipleObjects(1,hThread,true,200); 
		delete simThreadInfo.SimThreadPtr;
		simThreadInfo.EndSimThread = true;
	}
	
}

/////////////////////////////////////////////////////////////////////////////
// CCSMACDSimView message handlers
///////////////////////////////////////////////////////////
// Function SimulatorThread(LPVOID lpInfo)
// 
// PURPOSE
// This is the thread that causes the simulator to run.
// It runs until it is told to stop
// it sleeps occasionally so UI could occur
///////////////////////////////////////////////////////////
UINT CChildView::SimulatorThread(LPVOID lpInfo)
{
    THREADINFO *ThreadInfo = (THREADINFO *)lpInfo;
	DWORD SleepIn = 200; // sleeps every 500 ticks

	DWORD StartCount = GetTickCount();

	while (!ThreadInfo->EndSimThread)
	{		
	
		for (int ix = 0; ix < 100; ix++)
		{
			ThreadInfo->ParentPtr->m_pNetwork->Run();
		}
		DWORD EndCount = GetTickCount();
		if (EndCount - StartCount >= SleepIn)
		{
			ThreadInfo->ParentPtr->Invalidate(false);
			ThreadInfo->ParentPtr->UpdateWindow();
			Sleep(25); // give up some time for user input
			StartCount = GetTickCount();
		}
		// check if the network still should run
		if (!ThreadInfo->ParentPtr->m_pNetwork->RunTestingCycle())
		{
			ThreadInfo->EndSimThread = true;
			ThreadInfo->ParentPtr->Invalidate(false);
		}

		
	
	}
    return 0;
}


void CChildView::OnStartThread() 
{
	
	if (simThreadInfo.EndSimThread)
	{
		simThreadInfo.EndSimThread = false;
		simThreadInfo.ParentPtr = this;		
		simThreadInfo.SimThreadPtr = AfxBeginThread(SimulatorThread,(LPVOID) &simThreadInfo, THREAD_PRIORITY_NORMAL);
	//	SetTimer(0,200,NULL);
		Invalidate(false);
	}
	else
	{	
		StopThread();		
		Invalidate(false);
	
	}
	
}

void CChildView::StopThread()
{
	// end the thread	
	simThreadInfo.EndSimThread = true;
	HANDLE hThread[2];
	if (simThreadInfo.SimThreadPtr->m_hThread != NULL)
	{
		hThread[0] = simThreadInfo.SimThreadPtr->m_hThread;

		 // wait for the threads to end
		::WaitForMultipleObjects(1,hThread,true,200);  
	//	KillTimer(0);	

	}
}
