// IncomingBuffer.cpp: implementation of the IncomingBuffer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "IncomingBuffer.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IncomingBuffer::IncomingBuffer()
{
	for (int ix = 0; ix < MAXBUFFERS; ix++)
	{
		m_nBytes[ix] = 0;
		m_aMIPInfo[ix].MessageNumber = -1;		
	}
	m_StartBufferIndex = 0;
	m_EndBufferIndex = 0;	

}

IncomingBuffer::~IncomingBuffer()
{

}

//=============================================================
// bool AddData(char *pBuffer, int nBytes, IPINFO IPInfo)
//
// Add data into the buffer
//
// returns true if we have a complete message
//=============================================================
bool IncomingBuffer::AddData(char *pBuffer, int nBytes, IPINFO IPInfo)
{
	// first find if we already loaded in bytes from the same fragment
	int tIndex = -1;
	int tTraversal = m_StartBufferIndex;
	while (tTraversal != m_EndBufferIndex)
	{
		// check if the message is from the same ip and 
		// if the message index is the same, then we have the same buffer
		if (m_aMIPInfo[tTraversal].MessageNumber == IPInfo.MessageNumber)
		{
			if (m_aMIPInfo[tTraversal].SourceIP == IPInfo.SourceIP)
			{
				// we have a match
				tIndex = tTraversal;
				tTraversal = m_EndBufferIndex; // break out
			}
		}

		if (tIndex == -1)
		{
			tTraversal++;
			if (tTraversal >= MAXBUFFERS)
				tTraversal = 0;
		}
	}

	if (tIndex == -1)
	{
		// create a new index
		tIndex = m_EndBufferIndex;
		m_bMessageReady[tIndex] = false;
		m_bMessageRead[tIndex] = false;
		m_nBytes[tIndex] = 0;
		m_aMIPInfo[tIndex] = IPInfo;
		m_LPacketIndex[tIndex] = -1;
		m_EndBufferIndex++;
		if (m_EndBufferIndex >= MAXBUFFERS)
			m_EndBufferIndex = 0;
		// if we are out of spaces in the buffer just kill the first one
		if (m_StartBufferIndex == m_EndBufferIndex)
			m_StartBufferIndex++;
		if (m_StartBufferIndex >= MAXBUFFERS)
			m_StartBufferIndex = 0;
		for (int iy = 0; iy < MAXPACKETS; iy++)
		{
			for (int iz = 0; iz < MAXBUFFERS; iz++)
				m_CPackets[iz][iy] = 0;
		}
	}

	// k copy over the data add to nbytes
	int Offset = IPInfo.PacketIndex*PACKETSIZE;
	memcpy(m_ReceivedBuffer[tIndex] + Offset
		,pBuffer,sizeof(char)*nBytes);
	
	// only increase the bytes if this is the first time we received this packet
	if (m_CPackets[tIndex][IPInfo.PacketIndex] == 0)
	{
		m_nBytes[tIndex] += nBytes;
		m_CPackets[tIndex][IPInfo.PacketIndex] = 1;
	}

	// check if the last one
	
	if (IPInfo.bLastPacket)
	{
		// copy in the last packet index
		m_LPacketIndex[tIndex] = IPInfo.PacketIndex;
	}

	
	bool Done;
	if (m_LPacketIndex[tIndex] != -1)
		Done = true;
	else 
		Done = false;

	if (m_LPacketIndex[tIndex] != -1)
	{
		// check if the message is complete
		for (int iy = 0; iy <= m_LPacketIndex[tIndex]; iy++)
		{
			if (m_CPackets[tIndex][iy] == 0)
				Done = false;
		}
	}

	if (Done)
	{
		// now check if the message is done	(and hasn't been done before)
		if (m_bMessageReady[tIndex] == false)
		{
			m_bMessageReady[tIndex] = true;
			return true;
		}		
	}

	return false;



}

//=============================================================
// int GetData(char *lpBuf, int &nBytes)
//
// Gets a completed message from the buffer if available if not
// returns 0
//=============================================================
int IncomingBuffer::GetData(char *lpBuf, int &nBytes)
{
	if (m_StartBufferIndex == m_EndBufferIndex)
		return 0;

	// now traverse the buffers looking for the first one that is "done"
	int tTraversal = m_StartBufferIndex;

	int MessageIndex = -1;
	while (tTraversal != m_EndBufferIndex)
	{
		if (m_bMessageReady[tTraversal])
		{
			MessageIndex = tTraversal;
			break;
		}

		tTraversal++;
		if (tTraversal >= MAXBUFFERS)
			tTraversal = 0;
	}
	
	if (MessageIndex == -1)
		return 0;

	// k send back the buffer
	int nCopyData = m_nBytes[MessageIndex];
	if (nBytes < m_nBytes[MessageIndex])
		nCopyData = nBytes;

	memcpy(lpBuf,m_ReceivedBuffer[MessageIndex],nCopyData*sizeof(char));

	m_bMessageReady[tTraversal] = false;
	m_bMessageRead[tTraversal] = true;

	// now do some maintnance, we want the start index to point to the first index
	// that is not done
	int StartOfQueue = m_StartBufferIndex;
	if (m_StartBufferIndex == tTraversal)
	{
		// k go up the queue until we find one that isn't ready and isn't read
		while (tTraversal != m_EndBufferIndex)
		{
			if (!m_bMessageReady[tTraversal] && m_bMessageRead[tTraversal])
			{		
				StartOfQueue = tTraversal;
			}
			else
			{
				// k break out here
				break;
			}

			tTraversal++;
			if (tTraversal >= MAXBUFFERS)
				tTraversal = 0;
		}
	}
	m_StartBufferIndex = StartOfQueue+1;
	if (m_StartBufferIndex >= MAXBUFFERS)
		m_StartBufferIndex = 0;

	return nCopyData;
}
