// IncomingBuffer.h: interface for the IncomingBuffer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_INCOMINGBUFFER_H__769469B3_C502_4ED3_91F2_D03F910254B7__INCLUDED_)
#define AFX_INCOMINGBUFFER_H__769469B3_C502_4ED3_91F2_D03F910254B7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "NetworkDef.h"
#include "Protocals.h"
#include "Packets.h"


// this class acts as the socket buffer for the OS.  It recombines messages that are more
// then one packet and buffers them so the receive calls can be delayed a bit

class IncomingBuffer  
{
public:
	// the two functions that can be called
	int GetData(char *lpBuf, int &nBytes);
	bool AddData(char *pBuffer, int nBytes, IPINFO IPInfo);

	IncomingBuffer();
	virtual ~IncomingBuffer();

	char m_ReceivedBuffer[MAXBUFFERS][MAXMESSAGESIZE];
	int m_StartBufferIndex; // circulur buffers for incoming data
	int m_EndBufferIndex;	
	int m_nBytes[MAXBUFFERS]; // number of incoming bytes
	bool m_bMessageReady[MAXBUFFERS]; // true if the message is ready
	bool m_bMessageRead[MAXBUFFERS]; // true if the message is ready
	IPINFO m_aMIPInfo[MAXBUFFERS]; // ip info for each message
	int m_CPackets[MAXBUFFERS][MAXPACKETS]; // used to see if the message is complete
	int m_LPacketIndex[MAXBUFFERS]; // stores the index of the last packet

};

#endif // !defined(AFX_INCOMINGBUFFER_H__769469B3_C502_4ED3_91F2_D03F910254B7__INCLUDED_)
