// IniFile.h: interface for the IniFile class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_INIFILE_H__85B3644A_4A0F_43C8_A280_601631C2093E__INCLUDED_)
#define AFX_INIFILE_H__85B3644A_4A0F_43C8_A280_601631C2093E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define DEFAULTSIMTYPE "Assignment1"
#define FILENAME "SimConfig5.txt"


#define SIMTYPE "SimType"

#define INIMAXFILESIZE 10000
#define INIMAXKEYSIZE 80
#define INIMAXVALUESIZE 80

class IniFile  
{
public:
	BOOL DirectXEnabled;
	BOOL isValid;

    // initilizes the file if never opened before
	void InitFile();

    // add/replace
	BOOL ReplaceKey(char *key, char *newvalue);
	BOOL AddKey(char *key, char *value);

    // coverts spaces to underscores
	void AddUnderScore(char *buffer);
    void RemoveUnderScore(CString &buffer);
	void RemoveUnderScore(char *buffer);
    
    // search functionality
    BOOL SearchforKey(char *key, CString &returnstring);
	BOOL SearchforKey(char *key,char *returnstring);


	CFile MainFile;
	IniFile();
	virtual ~IniFile();

};

#endif // !defined(AFX_INIFILE_H__85B3644A_4A0F_43C8_A280_601631C2093E__INCLUDED_)
