// NIC.h: interface for the NIC class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_NIC_H__BA3CB4B6_A1E6_4302_9F3B_5ACCA92723FA__INCLUDED_)
#define AFX_NIC_H__BA3CB4B6_A1E6_4302_9F3B_5ACCA92723FA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// network device
#include "NetworkDef.h"
#include "Packets.h"
#include "Protocals.h"
#include "OS.h"
#include "OutgoingQueue.h"

class OS;

class NIC  
{
public:
	
	// the circular queue that holds the packets
	OutgoingQueue m_DataPackets;	
	ULONGLONG m_PacketReadyToSendTime; // to generate stats
	char m_PacketToSend[MAXPACKETSIZE]; // this packet is the one to be sent one it is ready
	int m_PacketToSendSize;

	// stores a control packet
	OutgoingQueue m_ControlPackets;
	InterFraceSpaces m_FramePriority; // the priority of the frame
	bool m_bSendtheDataNow;

	bool m_bIsAP;
	

	MACTYPE m_MacAddress;
	MACTYPE GetMacAddress() {return m_MacAddress;};

	// NIC External Functions
	bool GetData(char *&pBuffer, int &nBufferLen);
	int DataToSend(InterFraceSpaces FrameType);
	bool EnterData(char *Buffer, int &nBufferLen); // enters data
	void SendData(char *Buffer, int nBufferLen); // from physical layer
	void DecrementBackoff(int Frames); // called by the physical layer

	// NIC Internal functions
	void QueueNextPacket();
	int GetBackoffFrames(int Resends);

	// NIC Event handling
	void ConfirmPacketSent(LANINFO LanInfo, IPINFO IPInfo);
	void ConfirmPacketCollision();

	OS *m_pOS; 

	// NIC Data members
	int m_FrameBackoff; // next possible time the nic can resend
									// if contention
	int m_ResendTries;			      // the current amount of tries to send will timeout

	// stats area
	struct NICSTATS
	{
		LONGLONG CAvgWaitTime;
		int AvgWaitTime;
		int nSentPackets;
		int NumDroppedPackets;
		int CAvgResendTime; // packets that are confirmed to be sent out
		float AvgResendTime; // packets that are confirmed to be sent out
		int NumPackQueueFull; // can't send out because nic is full of data
	} s_NicStats;

	void GetStats(NICSTATS &NicStats);
	
	NIC();
	virtual ~NIC();

};

#endif // !defined(AFX_NIC_H__BA3CB4B6_A1E6_4302_9F3B_5ACCA92723FA__INCLUDED_)
