// Network.h: interface for the Network class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_NETWORK_H__0EB3FF1A_216E_4620_B241_B20D3B1947F4__INCLUDED_)
#define AFX_NETWORK_H__0EB3FF1A_216E_4620_B241_B20D3B1947F4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAXPROCESS 100

#include "NetworkDef.h"
#include "Process.h"
#include "PhysicalLayer.h"
#include "IniFile.h"
#include "NetworkStats.h"
#include "APProcess.h"

class Network  
{
public:
	void Init();
	int m_NumMultiRuns;
	int DNSFindAddress(char *Name);

	struct DNSADDRESS
	{
		char Name[200];
		int IPAddress;
		bool Valid;
	} m_aDNSAddress[MAXPROCESS];
	int DNSGetIPAddress(char *&Name);

	// get the stats
	void SGetStats(PhysicalLayer::STATISTICS &Stats);
	int SGetSeconds();

	// called by the main thread to run the network
	void Run();

	// network testing run stuff
	bool RunTestingCycle(); // called by the main thread
	bool RunNextTest(); // called to config the network again

	// overridden by child
	virtual void SetupNetwork(); // init setup	
	virtual void SaveNetworkStats() {return;}; // called at the end to save the stats

	// network config information
	enum TTYPE { MultiRun, ContRun} TType;
	int RunsPerRun;

	// storing the processes
	Process *m_aProcess[MAXPROCESS];
	int m_NumProcesses;

	// used to save the stats
	//PhysicalLayer::STATISTICS m_SaveStats[200];
	int m_nSaveStats;

	int m_PrevStatsTime; // used to generate process stats

	// get the stats
	ULONGLONG NGetUTicks();
	ULONGLONG NGetTicks();

	Network();
	virtual ~Network();

	// is ready to draw
	bool CanDraw();
	bool m_bReady;	
	

};

extern PhysicalLayer *pPhysicalLayer;
extern Network *pNetwork; // for global function

ULONGLONG NGetTicks(); // get the ticks in milleseconds since the start of the network
ULONGLONG NGetUTicks(); // get the ticks in milleseconds since the start of the network

#endif // !defined(AFX_NETWORK_H__0EB3FF1A_216E_4620_B241_B20D3B1947F4__INCLUDED_)
