// NetworkStats.cpp: implementation of the NetworkStats class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "NetworkStats.h"
#include "DisplayTable.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

NetworkStats g_NetworkStats; // global reference

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

NetworkStats::NetworkStats()
{

	ResetStats();

	m_ArchiveIndex = 0;
	for (int ix = 0; ix < 100; ix++)
	{
		CustomStatsManager[ix].Used = false;
	}

}

NetworkStats::~NetworkStats()
{

}

//=====================================================================
// void PhyLayerCalcAvgStats()
//
// Calculate the physical layer avg stats
//=====================================================================
void NetworkStats::PhyLayerCalcAvgStats()
{

	// first calculate the ones that have to be calculate
	int TotalBR = PhyLayerStats.brMax - PhyLayerStats.brIdle;
	PhyLayerStats.eDataFrames = 100.0f*(float)PhyLayerStats.brDataFrames/(float)TotalBR;
	PhyLayerStats.eAllFrames = 100.0f*(float)PhyLayerStats.brAllFrames/(float)TotalBR;
	if (TotalBR == 0)
	{
		PhyLayerStats.eDataFrames = 0;
		PhyLayerStats.eAllFrames = 0;
	}

	PhyLayerStats.eErrorFrames = 100.0f*(float)(PhyLayerStats.brAllFrames-PhyLayerStats.brErrorFrames)/(float)(PhyLayerStats.brAllFrames);


	PhyLayerStats.pDataFrames = (float)PhyLayerStats.brDataFrames/(float)PhyLayerStats.brMax;
	PhyLayerStats.pErrorFrames = (float)PhyLayerStats.brErrorFrames/(float)PhyLayerStats.brMax;
	PhyLayerStats.pIFSFrames = (float)PhyLayerStats.brIFS/(float)PhyLayerStats.brMax;
	PhyLayerStats.pIdleFrames = (float)PhyLayerStats.brIdle/(float)PhyLayerStats.brMax;
	PhyLayerStats.pCollsionFrames = (float)PhyLayerStats.brCollisionFrames/(float)PhyLayerStats.brMax;
	PhyLayerStats.pAllFrames = (float)PhyLayerStats.brAllFrames/(float)PhyLayerStats.brMax;

	int All = PhyLayerStats.brAllFrames + PhyLayerStats.brErrorFrames + PhyLayerStats.brIFS + PhyLayerStats.brCollisionFrames;
	int Diff = TotalBR - All;
	if (PhyLayerStats.nWaitTimes == 0)
	{
		PhyLayerStats.eWaitTime = 0;
		PhyLayerStats.eAvgResends = 0;
	}
	else
	{
		PhyLayerStats.eWaitTime = (int)(PhyLayerStats.tWaitTimes/PhyLayerStats.nWaitTimes);
		PhyLayerStats.eAvgResends = (float)PhyLayerStats.nNumResends/(float)PhyLayerStats.nWaitTimes;
	}
	// now add to the counter struct
	CPhyLayerStats.tCounter += 1;
	CPhyLayerStats.brIFS += PhyLayerStats.brIdle;
	CPhyLayerStats.brMax += PhyLayerStats.brMax;
	CPhyLayerStats.brAllFrames += PhyLayerStats.brAllFrames;
	CPhyLayerStats.brDataFrames += PhyLayerStats.brDataFrames;
	CPhyLayerStats.brErrorFrames += PhyLayerStats.brErrorFrames;
	CPhyLayerStats.brCollisionFrames += PhyLayerStats.brCollisionFrames;
	CPhyLayerStats.brIdle += PhyLayerStats.brIdle;
	CPhyLayerStats.eAllFrames += PhyLayerStats.eAllFrames;
	CPhyLayerStats.eDataFrames += PhyLayerStats.eDataFrames;
	CPhyLayerStats.eErrorFrames += PhyLayerStats.eErrorFrames;
	// error frames stuff
	CPhyLayerStats.nBEFrames += PhyLayerStats.nBEFrames;
	CPhyLayerStats.nBERTS += PhyLayerStats.nBERTS;
	CPhyLayerStats.nBEACK += PhyLayerStats.nBEACK;
	CPhyLayerStats.nBEData += PhyLayerStats.nBEData;
	CPhyLayerStats.nBECTS += PhyLayerStats.nBECTS;
	CPhyLayerStats.nfACK += PhyLayerStats.nfACK;
	CPhyLayerStats.nfCTS += PhyLayerStats.nfCTS;
	CPhyLayerStats.nfData += PhyLayerStats.nfData;
	CPhyLayerStats.nFrameCollisions += PhyLayerStats.nFrameCollisions;
	CPhyLayerStats.nfRTS += PhyLayerStats.nfRTS;
	// wait time stuff
	CPhyLayerStats.tCounter += PhyLayerStats.tCounter;
	CPhyLayerStats.nWaitTimes += PhyLayerStats.nWaitTimes;
	CPhyLayerStats.eWaitTime += PhyLayerStats.eWaitTime;
	CPhyLayerStats.eAvgResends += PhyLayerStats.eAvgResends;
	// avg stuff
	CPhyLayerStats.pDataFrames += PhyLayerStats.pDataFrames;
	CPhyLayerStats.pErrorFrames += PhyLayerStats.pErrorFrames;
	CPhyLayerStats.pIFSFrames += PhyLayerStats.pIFSFrames;
	CPhyLayerStats.pIdleFrames += PhyLayerStats.pIdleFrames;
	CPhyLayerStats.pCollsionFrames += PhyLayerStats.pCollsionFrames;
	CPhyLayerStats.pAllFrames += PhyLayerStats.pAllFrames;

	// now get the long term average
	int Count = CPhyLayerStats.tCounter;
	avgPhyLayerStats.brIFS = CPhyLayerStats.brIdle/Count;
	avgPhyLayerStats.brMax = CPhyLayerStats.brMax/Count;
	avgPhyLayerStats.brAllFrames = CPhyLayerStats.brAllFrames/Count;
	avgPhyLayerStats.brDataFrames = CPhyLayerStats.brDataFrames/Count;
	avgPhyLayerStats.brIdle = CPhyLayerStats.brIdle/Count;
	avgPhyLayerStats.brCollisionFrames = CPhyLayerStats.brCollisionFrames/Count;
	avgPhyLayerStats.brErrorFrames = CPhyLayerStats.brErrorFrames/Count;
	avgPhyLayerStats.eAllFrames = CPhyLayerStats.eAllFrames/Count;
	avgPhyLayerStats.eDataFrames = CPhyLayerStats.eDataFrames/Count;
	avgPhyLayerStats.eErrorFrames = CPhyLayerStats.eErrorFrames/Count;
	avgPhyLayerStats.nfACK = CPhyLayerStats.nfACK/Count;
	avgPhyLayerStats.nfCTS = CPhyLayerStats.nfCTS/Count;
	avgPhyLayerStats.nfData = CPhyLayerStats.nfData/Count;
	avgPhyLayerStats.nFrameCollisions = CPhyLayerStats.nFrameCollisions/Count;
	avgPhyLayerStats.nfRTS = CPhyLayerStats.nfRTS/Count;
	avgPhyLayerStats.nBEFrames = CPhyLayerStats.nBEFrames/Count;
	avgPhyLayerStats.nBERTS = CPhyLayerStats.nBERTS/Count;
	avgPhyLayerStats.nBEACK = CPhyLayerStats.nBEACK/Count;
	avgPhyLayerStats.nBEData = CPhyLayerStats.nBEData/Count;
	avgPhyLayerStats.nBECTS = CPhyLayerStats.nBECTS/Count;
	avgPhyLayerStats.eWaitTime = CPhyLayerStats.eWaitTime/Count;
	avgPhyLayerStats.eAvgResends = CPhyLayerStats.eAvgResends/Count;
	avgPhyLayerStats.pDataFrames = CPhyLayerStats.pDataFrames/Count;
	avgPhyLayerStats.pErrorFrames = CPhyLayerStats.pErrorFrames/Count;
	avgPhyLayerStats.pIFSFrames = CPhyLayerStats.pIFSFrames/Count;
	avgPhyLayerStats.pIdleFrames = CPhyLayerStats.pIdleFrames/Count;
	avgPhyLayerStats.pCollsionFrames = CPhyLayerStats.pCollsionFrames/Count;
	avgPhyLayerStats.pAllFrames = CPhyLayerStats.pAllFrames/Count;
	int mBitRate = PhyLayerStats.brMax;
	avgPhyLayerStats.avgCollisionFrames = (int)(avgPhyLayerStats.pCollsionFrames*mBitRate);
	avgPhyLayerStats.avgDataFrames = (int)(avgPhyLayerStats.pDataFrames*mBitRate);
	avgPhyLayerStats.avgErrorFrames = (int)(avgPhyLayerStats.pErrorFrames*mBitRate);
	avgPhyLayerStats.avgIdleFrames = (int)(avgPhyLayerStats.pIdleFrames*mBitRate);
	avgPhyLayerStats.avgIFSFrames = (int)(avgPhyLayerStats.pIFSFrames*mBitRate);
	avgPhyLayerStats.avgAllFrames = (int)(avgPhyLayerStats.pAllFrames*mBitRate);



	LPhyLayerStats = PhyLayerStats; // store the last one for storage
	// reset everything else

	PhyLayerStats.brIFS = 0;
	PhyLayerStats.brAllFrames = 0;
	PhyLayerStats.brCollisionFrames = 0;
	PhyLayerStats.brDataFrames = 0;
	PhyLayerStats.brErrorFrames = 0;
	PhyLayerStats.brIdle = 0;
	PhyLayerStats.nfData = 0;
	PhyLayerStats.nfACK = 0;
	PhyLayerStats.nfCTS = 0;
	PhyLayerStats.nfRTS = 0;
	PhyLayerStats.nFrameCollisions = 0;
	PhyLayerStats.nBEFrames = 0;
	PhyLayerStats.nBERTS = 0;
	PhyLayerStats.nBEACK = 0;
	PhyLayerStats.nBEData = 0;
	PhyLayerStats.nBECTS = 0;
	PhyLayerStats.tWaitTimes = 0;
	PhyLayerStats.nWaitTimes = 0;
	PhyLayerStats.eWaitTime = 0;
	PhyLayerStats.nNumResends = 0;
	PhyLayerStats.eAvgResends = 0;


}

//=====================================================================
// void DrawPhyStats(CDC *pDC, CPoint &Offset)
//
// Draw the phy datas on the screen
//=====================================================================
void NetworkStats::DrawPhyStats(CDC *pDC, CPoint &Offset)
{
	char Buffer[1000];
	int TextSpacing = 15;
	PHYLAYERSTATS S = LPhyLayerStats;

	DisplayTable DT,NT;

	
	int Lowest = 0;

	sprintf(Buffer,"Data Efficiency: %7.4f All Frames Efficiency: %7.4f	     "
		,LPhyLayerStats.eDataFrames,LPhyLayerStats.eAllFrames);
	pDC->TextOut(Offset.x,Offset.y,Buffer);
	Offset.y += TextSpacing;

	sprintf(Buffer,"avg Data Efficiency: %7.4f avg All Frames Efficiency: %7.4f	    "
		,avgPhyLayerStats.eDataFrames,avgPhyLayerStats.eAllFrames);
	pDC->TextOut(Offset.x,Offset.y,Buffer);
	Offset.y += TextSpacing;	

	sprintf(Buffer,"Avg Wait time 1second: %d avg: %d  NumResends: %5.2f avgNumResends: %5.2f        ",
		LPhyLayerStats.eWaitTime,avgPhyLayerStats.eWaitTime,LPhyLayerStats.eAvgResends,avgPhyLayerStats.eAvgResends);
	pDC->TextOut(Offset.x,Offset.y,Buffer);
	Offset.y += TextSpacing;

	CPoint tOffset = Offset;
	DT.SetWidth(2);
	DT.EnterTitle("Bit Rate Table");
	DT.EnterDesc("Usage","BitRate","Avg Bit Rate");


	DT.EnterValue("Max Rate",S.brMax,S.brMax); 
	int UsedRate = S.brMax - S.brIdle;
	int UsedAvg = S.brMax - avgPhyLayerStats.avgIdleFrames;
	int OverHeadFrames = avgPhyLayerStats.avgAllFrames - avgPhyLayerStats.avgDataFrames - avgPhyLayerStats.avgErrorFrames;
	DT.EnterValue("Used Rate",UsedRate,UsedAvg);	
	DT.EnterValue("Idle Rate",S.brIdle,avgPhyLayerStats.avgIdleFrames);
	DT.EnterValue("Data usage",S.brDataFrames,avgPhyLayerStats.avgDataFrames);
	DT.EnterValue("Overhead frames",S.brAllFrames - S.brDataFrames - S.brErrorFrames,OverHeadFrames);
	DT.EnterValue("IFS usage",S.brIFS,avgPhyLayerStats.avgIFSFrames);
	DT.EnterValue("Collisions",S.brCollisionFrames,avgPhyLayerStats.avgCollisionFrames);
	DT.EnterValue("Errors usage",S.brErrorFrames,avgPhyLayerStats.avgErrorFrames);
	DT.DrawTable(pDC,tOffset);
	Lowest = tOffset.y;

	NT.SetWidth(2);
	NT.EnterTitle("Number Ofs");
	NT.EnterDesc("Attribute","Number Of","Total Of");
	NT.EnterValue("RTS Frames",S.nfRTS,CPhyLayerStats.nfRTS);
	NT.EnterValue("CTS Frames",S.nfCTS,CPhyLayerStats.nfCTS);
	NT.EnterValue("Data Frames",S.nfData,CPhyLayerStats.nfData);
	NT.EnterValue("Ack Frames",S.nfACK,CPhyLayerStats.nfACK);	
	NT.EnterValue("Error Frames",S.nBEFrames,CPhyLayerStats.nBEFrames);
	tOffset = Offset;
	tOffset.x += 300;
	NT.DrawTable(pDC,tOffset);
	if (tOffset.y > Lowest)
		Lowest = tOffset.y;

	Offset.y = Lowest;

	


}

//=====================================================================
// void ArchiveStats()
//
// Call this function to archive the stats into storage
//=====================================================================
void NetworkStats::ArchiveStats(bool bResetStats)
{
	SPhy[m_ArchiveIndex] = avgPhyLayerStats;
	// now call the process to save their stats
	Process *pTProcess = NULL;
	for (int ix = 0; ix < 100; ix++)
	{
		if (CustomStatsManager[ix].Used)
		{
			if (CustomStatsManager[ix].pProcess != pTProcess)
			{
				pTProcess = CustomStatsManager[ix].pProcess;
				pTProcess->OnSaveStats();
			}
		}
	}

	m_ArchiveIndex++; 

	if (bResetStats)
		ResetStats();

}

//=====================================================================
// void ResetStats()
//
// Call this function to reset the stats
//=====================================================================
void NetworkStats::ResetStats()
{
	PhyLayerStats.brIdle = 0;
	PhyLayerStats.brIFS = 0;
	PhyLayerStats.brMax = 0;
	PhyLayerStats.brErrorFrames = 0;
	PhyLayerStats.brCollisionFrames = 0;
	PhyLayerStats.brAllFrames = 0;
	PhyLayerStats.brDataFrames = 0;
	PhyLayerStats.eAllFrames = 0;
	PhyLayerStats.eDataFrames = 0;
	PhyLayerStats.eErrorFrames = 0;
	PhyLayerStats.nBEFrames = 0;
	PhyLayerStats.nBERTS = 0;
	PhyLayerStats.nBEACK = 0;
	PhyLayerStats.nBEData = 0;
	PhyLayerStats.nBECTS = 0;
	PhyLayerStats.nfACK = 0;
	PhyLayerStats.nfCTS = 0;
	PhyLayerStats.nfData = 0;
	PhyLayerStats.nFrameCollisions = 0;
	PhyLayerStats.nfRTS = 0;
	PhyLayerStats.tCounter = 0;
	PhyLayerStats.tWaitTimes = 0;
	PhyLayerStats.nWaitTimes = 0;
	PhyLayerStats.eWaitTime = 0;
	PhyLayerStats.nNumResends = 0;
	PhyLayerStats.eAvgResends = 0;
	PhyLayerStats.pDataFrames = 0;
	PhyLayerStats.pErrorFrames = 0;
	PhyLayerStats.pIFSFrames = 0;
	PhyLayerStats.pIdleFrames = 0;
	PhyLayerStats.pCollsionFrames = 0;
	PhyLayerStats.pAllFrames = 0;
	PhyLayerStats.avgDataFrames = 0;
	PhyLayerStats.avgErrorFrames = 0;
	PhyLayerStats.avgIFSFrames = 0;
	PhyLayerStats.avgIdleFrames = 0;
	PhyLayerStats.avgCollisionFrames = 0;
	PhyLayerStats.avgAllFrames = 0;


	CPhyLayerStats = avgPhyLayerStats = PhyLayerStats;

}

//=====================================================================
// int GetCustomStats(char *pName)
//
// Call this function to return the stats index either new or old
//=====================================================================
int NetworkStats::GetCustomStats(Process *pProcess, char *pName)
{
	for (int ix = 0; ix < 100; ix++)
	{
		if (CustomStatsManager[ix].Used)
		{
			if (!strcmp(pName,CustomStatsManager[ix].Names))
			{
				CustomStatsManager[ix].pProcess = pProcess;
				return ix;
			}
		}
	}
	// k make a new entry
	for (ix = 0; ix < 100; ix++)
	{
		if (!CustomStatsManager[ix].Used)
			break;
	}

	// ix is the right index
	if (ix == 100)
		return -1;
	else
	{
		CustomStatsManager[ix].Used = true;
		strcpy(CustomStatsManager[ix].Names,pName);
		CustomStatsManager[ix].pProcess = pProcess;
		return ix;
	}


}

//=====================================================================
// void GetCustomHeader(char *&pBuffer)
//
// Get the header for the custom stats
//=====================================================================
void NetworkStats::GetCustomHeader(char *&pBuffer)
{
	char tempo[100];
	for (int ix = 0; ix < 100; ix++)
	{
		if (CustomStatsManager[ix].Used)
		{
			sprintf(tempo,"%s ",CustomStatsManager[ix].Names);
			strcat(pBuffer,tempo);
		}
	}

	sprintf(tempo,"\n");
	strcat(pBuffer,tempo);
}

//=====================================================================
// void GetCustomData(char *&pBuffer, int Index)
//
// Get teh data from the custom stats
//=====================================================================
void NetworkStats::GetCustomData(char *&pBuffer, int Index)
{
	char tempo[100];
	for (int ix = 0; ix < 100; ix++)
	{
		if (CustomStatsManager[ix].Used)
		{
			sprintf(tempo,"%9.4f ",CustomStats[Index].AnyStats[ix]);
			strcat(pBuffer,tempo);
		}
	}

	sprintf(tempo,"\n");
	strcat(pBuffer,tempo);

}

//=====================================================================
// void AddCustomStats(int index, float value)
//
// Add custom data to the stats to be archived
//=====================================================================
void NetworkStats::AddCustomStats(int index, float value)
{
	if (index == -1)
		return;
	if (index >= 100)
		return;

	CustomStats[m_ArchiveIndex].AnyStats[index] = value;
	
}
