// NetworkStats.h: interface for the NetworkStats class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_NETWORKSTATS_H__E960B3CF_BD8F_4E90_BB62_5E6418E348A8__INCLUDED_)
#define AFX_NETWORKSTATS_H__E960B3CF_BD8F_4E90_BB62_5E6418E348A8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Process.h"

class NetworkStats  
{
public:	

	// deal with saving stats from processes
	void AddCustomStats(int index, float value);
	void GetCustomData(char *&pBuffer, int Index);
	void GetCustomHeader(char *&pBuffer);
	int GetCustomStats(Process *pProcess, char *pName);

	void ResetStats();
	int m_ArchiveIndex;
	void ArchiveStats(bool bResetStats = true);
	// draw the stats on the screen
	void DrawPhyStats(CDC *pDC, CPoint &Offset);
	// calc the average call this once a second I guess
	void PhyLayerCalcAvgStats();

	struct PHYLAYERSTATS
	{	
		// bit rate stats
		int brMax; // the max bit rate e.g 10mbs
		int brAllFrames; // the bit rate used for frames
		int brDataFrames; // the bit rate of just the data frames
		int brIFS; // the bit rate used for IFS Frames of any kind
		int brIdle; // idle bit rate 
		int brErrorFrames; // bit rate used up for all error frames
		int brCollisionFrames; // bit rate used up in collisions

		// effeciency measures
		float eDataFrames; // the effieiciy of all data bits over all bits 
		float eAllFrames;// the effiecieny of all frame bits over all bits used
		float eErrorFrames; // the effeicieny of all frame bits vs all bits lost to error
		
		// percentage stuff
		float pAllFrames;
		float pDataFrames;
		float pErrorFrames;
		float pIFSFrames;
		float pIdleFrames;
		float pCollsionFrames;
		int avgAllFrames;
		int avgDataFrames;
		int avgErrorFrames;
		int avgIFSFrames;
		int avgIdleFrames;
		int avgCollisionFrames;

		// number of frames stats
		int nfData;
		int nfRTS;
		int nfCTS;
		int nfACK;

		// bad things happening stats
		int nFrameCollisions; // the total frame collisions
		int nBEFrames; // the total error frames;
		int nBERTS; // number of RTS packets with a Bit Error
		int nBEACK; // Ack bit error
		int nBEData; // data bit error
		int nBECTS; // cts bit error

		ULONGLONG tWaitTimes; // wait time counter
		int		  eWaitTime; // wait time avg
		int		  nNumResends;
		float	  eAvgResends;
		int		  nWaitTimes; // wait time number c/n = avg

		int tCounter; // total counter for the average version
	public:
		void ResetStats();
	} PhyLayerStats, // the ones used as the current counter
		LPhyLayerStats, // stores the previous results
		CPhyLayerStats, // counter for the avg
		avgPhyLayerStats, // stores the avg
		SPhy[100];

	// general storage for any stats 

	struct CUSTOMSTATSM
	{
		char Names[100];
		Process *pProcess;
		bool Used;
	} CustomStatsManager[100];

	struct CUSTOMSTATS
	{
		float AnyStats[100];		
	} CustomStats[100];

	NetworkStats();
	virtual ~NetworkStats();

};

extern NetworkStats g_NetworkStats;

#endif // !defined(AFX_NETWORKSTATS_H__E960B3CF_BD8F_4E90_BB62_5E6418E348A8__INCLUDED_)
