// PhysicalLayer.cpp: implementation of the PhysicalLayer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "PhysicalLayer.h"
#include "Protocals.h"
#include "NetworkStats.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PhysicalLayer::PhysicalLayer()
{
	Reset();
}

PhysicalLayer::~PhysicalLayer()
{

}

//===================================================
// Run()
//
// Called to simulate it. Should be called by the network
// each run
//===================================================
void PhysicalLayer::Run()
{
	
/*(	while (m_CurrBitTick < m_CurrentQuantas && !b_NoTraffic)
	{
		
		m_CurrBitTick++;
	}
	m_CurrentQuantas++;
	m_CurrBitTick = 0;*/
}

//===================================================
// void SetQuantaTime(int nBits)
//
// This function sets the time that the physical layer executes in 
// terms of bit rate before giving up execution time for the processes
// this is the time it stays in run, speeds up the simulation by allowing it
// to skip if nothing is on the network
//
// e.g if the bit rate was 10 mBits and nBits was 10000 the process would get
// get executed at 10k/10m
//===================================================
void PhysicalLayer::SetQuantaTime(int nBits)
{
	m_CurrBitQuanta = nBits;
}

//===================================================
// void GenerateStatistics
//
// Calls once every so often to generate the statistics of the system
//===================================================
void PhysicalLayer::GenerateStatistics()
{
	g_NetworkStats.PhyLayerStats.brMax = m_BitRate;
	g_NetworkStats.PhyLayerCalcAvgStats();

	m_Stats.p_ActualBitRate = m_BitsPerQuanta;
	m_Stats.p_MaxBitRate = m_BitRate;
	m_Stats.p_IdleBitRate = m_IdleBitsPerQuanta;
	int ActualRate = m_BitRate - m_IdleBitsPerQuanta; 
	m_Stats.p_CurrEfficiency = 100.0f*(float)m_BitsPerQuanta/(float)ActualRate;
	m_Stats.p_AvgEfficiencyCounter += m_Stats.p_CurrEfficiency;
	m_Stats.p_nAvgEfficiency++;
	m_Stats.p_AvgEfficiency = m_Stats.p_AvgEfficiencyCounter/m_Stats.p_nAvgEfficiency;

	m_BitsPerQuanta = 0;
	m_IdleBitsPerQuanta = 0;

}

//===================================================
// void SGetBitRate (int &m_BitRate, int &m_BitsPerQuanta)
//
// Returns the bit rate
//===================================================
void PhysicalLayer::SGetStats (STATISTICS &Stats)
{
	Stats = m_Stats;
}

//===================================================
// void RegisterNIC(NIC *pNIC)
//
// Register a NIC with the physical layer
//===================================================
bool PhysicalLayer::RegisterNIC(NIC *pNIC)
{
	if (m_NumNIC >= MAXNIC)
		return false;

	m_aNIC[m_NumNIC] = pNIC;
	m_NumNIC++;
	return true;
}

//===================================================
// void RegisterAP(NIC *pNIC)
//
// Register a AP with the physical layer
//===================================================
bool PhysicalLayer::RegisterAP(NIC *pNIC)
{
	m_APNIC = pNIC;
	return RegisterNIC(pNIC); // also register as a nic;
}



//===================================================
// void Reset()
//
// Restes the network
//===================================================
void PhysicalLayer::Reset()
{
	m_CurrBitTick = 0;
	m_CurrBitQuanta = 10000;
	m_BitRate = BITRATE;
	m_StatsNumTimes = 0;
	m_TotalCollisions = 0;
	m_GenStatsTime = m_BitRate/m_CurrBitQuanta; // called once a second
	m_CGenStatsTime = 0;
	m_BitsPerQuanta = 0;
	m_IdleBitsPerQuanta = 0;
	m_LastBitTick = 0;
	m_USecondsTicks = 0;
	m_NumNIC = 0;
	m_bPacketToSend = false;
	m_nCurrPacket = 0;
	m_nCurrPacketSize = 0;
	m_USecondsTicks = 0;
	m_Stats.p_AvgEfficiencyCounter = 0;
	m_Stats.p_nAvgEfficiency = 0;
	m_Stats.p_AvgEfficiency = 0;
	m_Stats.p_CurrEfficiency  = 0;
	m_Stats.p_ActualBitRate = 0;
	m_Stats.p_IdleBitRate = 0;
	m_Stats.p_MaxBitRate = 0;
	m_APNIC = NULL;

}

//===================================================
// void SendData()
//
// This function is called when data is confirmed to be sent
//
// It sends the data to the other network devices.
//===================================================
void PhysicalLayer::SendData()
{
	// parse the data to see what kind of file it is
	LANINFO LanInfo;
	char *tPtr = m_CurrPacket;
	g_Protocals.L0GetInfo(tPtr,LanInfo);
	tPtr = m_CurrPacket;

	// check if we have a bit error for this packet
	if (CheckBitErrors())
	{
		return;
	}

	if (LanInfo.FrameControl == RTSFrame)	
	{
		g_Protocals.L0GetRTSInfo(tPtr,LanInfo);
		g_NetworkStats.PhyLayerStats.nfRTS++;
	}
	else if (LanInfo.FrameControl == CTSFrame)	
	{
		g_Protocals.L0GetCTSInfo(tPtr,LanInfo);	
		g_NetworkStats.PhyLayerStats.nfCTS++;
	}
	else if (LanInfo.FrameControl == ACKFrame)	
	{
		g_Protocals.L0GetACKInfo(tPtr,LanInfo);	
		g_NetworkStats.PhyLayerStats.nfACK++;
	}
	else if (LanInfo.FrameControl == DataFrame)
	{
		g_Protocals.L0GetInfo(tPtr,LanInfo);
		g_NetworkStats.PhyLayerStats.nfData++;
		g_NetworkStats.PhyLayerStats.brDataFrames += m_nCurrPacketSize*8;
	}
	else
	{
		ASSERT(0);
	}

	// k now go through all the nics seeing which ones we should send it to 
	// if any
	for (int ix = 0; ix < m_NumNIC; ix++)
	{
		MACTYPE MacAddress = m_aNIC[ix]->GetMacAddress();
		ASSERT(LanInfo.SourceMac != 255);
		if (MacAddress != LanInfo.SourceMac)
		{
			if (LanInfo.LanType == BroadcastType)
			{
				// k send it
				m_aNIC[ix]->SendData(m_CurrPacket,m_nCurrPacketSize-PHYPREABLEB);

			}
			else if (LanInfo.LanType == ConnectionType)
			{
				if (MacAddress == LanInfo.DestMac)
				{
					// k send it
					m_aNIC[ix]->SendData(m_CurrPacket,m_nCurrPacketSize-PHYPREABLEB);
				}
			}
		}
	}
}


//===================================================
// void IncrementTime(int uSeconds)
//
// increment the clock by a certain amount of uSeconds
//
//===================================================
void PhysicalLayer::IncrementTime(int uSeconds)
{
//	g_NetworkStats.PhyLayerStats.brIFS += uSeconds*DIFFUTICKSBITRATE;
	m_CurrBitTick += uSeconds*DIFFUTICKSBITRATE;			
	m_USecondsTicks += (m_CurrBitTick-m_LastBitTick)/DIFFUTICKSBITRATE;
	m_LastBitTick = m_CurrBitTick;

}

//===================================================
// bool CheckBitErrors()
//
// this function checks if there is a bit error in the packet, and if 
// so it returns true
//
//===================================================
bool PhysicalLayer::CheckBitErrors()
{

	int TotalBits = m_nCurrPacketSize*8;
	double probError = (double)TotalBits/(double)BER;

	// we need double rand because of bit size

	double Rand = (double)(rand());
	double RandDiv = (double)(RAND_MAX);
	double prob = (double)(rand()*rand())/(double)((RAND_MAX)*(RAND_MAX));
	double prob1 = Rand/RandDiv;

	if (prob1 <= probError)
	{
		// we have an error
		// classify the packet size
		LANINFO LanInfo;
		char *tPtr = m_CurrPacket;
		g_Protocals.L0GetInfo(tPtr,LanInfo);

		if (LanInfo.FrameControl == RTSFrame)			
			g_NetworkStats.PhyLayerStats.nBERTS++;		
		else if (LanInfo.FrameControl == CTSFrame)	
			g_NetworkStats.PhyLayerStats.nBECTS++;	
		else if (LanInfo.FrameControl == ACKFrame)	
			g_NetworkStats.PhyLayerStats.nBEACK++;
		else if (LanInfo.FrameControl == DataFrame)
			g_NetworkStats.PhyLayerStats.nBEData++;

		g_NetworkStats.PhyLayerStats.brErrorFrames += TotalBits;
		g_NetworkStats.PhyLayerStats.nBEFrames++;


		return true;
	}
	return false;

}
