// PhysicalLayer.h: interface for the PhysicalLayer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PHYSICALLAYER_H__69A3D707_8351_4679_864C_85BCE6075FF4__INCLUDED_)
#define AFX_PHYSICALLAYER_H__69A3D707_8351_4679_864C_85BCE6075FF4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// virtual class of a physical layer
#include "NetworkDef.h"
#include "NIC.h"
#include "Packets.h"


class PhysicalLayer  
{
public:
	// check for bit errors
	bool CheckBitErrors();
	void IncrementTime(int uSeconds);
	void SendData();
	void Reset();
	int m_NumNIC;
	bool RegisterNIC(NIC *pNIC); // register a normal NIC
	bool RegisterAP(NIC *pNIC); // register the access point NIC

	struct STATISTICS
	{
		int p_MaxBitRate;
		int p_ActualBitRate;
		int p_IdleBitRate;
		float p_AvgEfficiency;
		float p_AvgEfficiencyCounter;
		float p_CurrEfficiency;
		int p_nAvgEfficiency;

		// filled in by the network
		float n_AvgWaitTime;
		float n_AvgResends;
		float n_AvgSent;
		float n_AvgMissed;
		float n_AvgDropped;
	};

	STATISTICS m_Stats;
	void GenerateStatistics();
	void SetQuantaTime(int nBits);

	ULONG SGetTime () {return m_StatsNumTimes;};
	void SGetStats (STATISTICS &Stats);
	// the bit rate of the network
	int m_BitRate;
	// the propgation time
	int m_PropTime;

	// the current amount of ticks this quanta
	int m_CurrBitTick;
	// the current number of ticks per quanta
	int m_CurrBitQuanta;

	// stores when the stats function should be called
	int m_GenStatsTime; // when to call it
	int m_CGenStatsTime; // the counter

	int m_BitsPerQuanta; // the bits tramitted this Quanta
	int m_IdleBitsPerQuanta;

	int m_TotalCollisions;

	ULONGLONG m_USecondsTicks;
	int m_LastBitTick; // used to calculate the USeconds

	// for statics tracking
	ULONG m_StatsNumTimes; // number of stats time

	bool m_bPacketToSend;
	char m_CurrPacket[MAXPACKETSIZE];
	int m_nCurrPacketSize;
	int m_nCurrPacket;
	int m_CurrPacketNICIndex;
	NIC *m_aNIC[MAXNIC];
	NIC *m_APNIC; // the access point nic

	virtual void Run();
	PhysicalLayer();
	virtual ~PhysicalLayer();

};

#endif // !defined(AFX_PHYSICALLAYER_H__69A3D707_8351_4679_864C_85BCE6075FF4__INCLUDED_)
