// Protocals.h: interface for the Protocals class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PROTOCALS_H__DB36323A_73CC_4C86_A8EC_35F2560F9134__INCLUDED_)
#define AFX_PROTOCALS_H__DB36323A_73CC_4C86_A8EC_35F2560F9134__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "NetworkDef.h"

#define WRITE_WORD(pbCur, word) {WORD* __pword = (WORD*)pbCur; *(__pword++) = word;\
                             pbCur = (char *)__pword;}

#define READ_WORD(pbCur, word) {WORD* __pword = (WORD*)pbCur; word = *(__pword++);\
                             pbCur = (char *)__pword;}

#define WRITE_DWORD(pbCur, dword) {DWORD* __pdword = (DWORD*)pbCur; *(__pdword++) = dword;\
                             pbCur = (char *)__pdword;}

#define READ_DWORD(pbCur, dword) {DWORD* __pdword = (DWORD*)pbCur; dword = *(__pdword++);\
                             pbCur = (char *)__pdword;}

#define WRITE_LWORD(pbCur, dword) {ULONGLONG* __pdword = (ULONGLONG*)pbCur; *(__pdword++) = dword;\
                             pbCur = (char *)__pdword;}

#define READ_LWORD(pbCur, dword) {ULONGLONG* __pdword = (ULONGLONG*)pbCur; dword = *(__pdword++);\
                             pbCur = (char *)__pdword;}

// this class stores everything needed for the protocals


enum SOCKETTYPE {SockStream, SockDataGram};
struct IPINFO
{
	IPTYPE SourceIP;
	IPTYPE DestIP;
	int Port;
	int MessageNumber; // just a number to we know if we are from the same message
	int PacketIndex; // the index for reconstruction
	int bLastPacket; // if it is the last packet or not
	SOCKETTYPE SocketType;
};

enum LANTYPE {BroadcastType, ConnectionType};
struct LANINFO
{
	FRAMECONTROL FrameControl;
	MACTYPE SourceMac;
	MACTYPE DestMac;
	MACTYPE TrueDestMac; // the true destination
	LANTYPE LanType;
	int	DSFlags; // stores from or to DS
};

struct RTPINFO
{
	ULONGLONG TimeStamp;
	int FrameNumber;
};

class Protocals  
{
public:		

	// add info to a buffer
	void L1CatInfo(char *&buffer, IPINFO IPInfo);
	// get info from a buffer
	void L1GetInfo(char *&buffer, IPINFO &IPInfo);

	// add info to a buffer
	void L0CatInfo(char *&buffer, LANINFO IPInfo);
	// get info from a buffer
	void L0GetInfo(char *&buffer, LANINFO &IPInfo);

	void GetRTPInfo(char *&buffer, RTPINFO &RTPinfo);
	void CatRTPInfo(char *&buffer, RTPINFO RTPInfo);
	int GetRTPSize();

	// create specialized packets
	void L0CatRTSInfo(char *&buffer, LANINFO &LanInfo, bool fromDS = false);
	void L0CatCTSInfo(char *&buffer, LANINFO &LanInfo);
	void L0CatACKInfo(char *&buffer, LANINFO &LanInfo);
	void L0GetRTSInfo(char *&buffer, LANINFO &LanInfo);
	void L0GetCTSInfo(char *&buffer, LANINFO &LanInfo);
	void L0GetACKInfo(char *&buffer, LANINFO &LanInfo);
	int L0GetRTSSize();
	int L0GetCTSSize();
	int L0GetACKSize();

	int L1GetHeaderSize();
	int L0GetHeaderSize();

	Protocals();
	virtual ~Protocals();

};

extern Protocals g_Protocals;

#endif // !defined(AFX_PROTOCALS_H__DB36323A_73CC_4C86_A8EC_35F2560F9134__INCLUDED_)
