// ServerProcess.cpp: implementation of the ServerProcess class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "ServerProcess.h"
#include "Network.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ServerProcess::ServerProcess()
{
	m_SendTime = 0;
	m_IntervalTime = 200;


}

ServerProcess::~ServerProcess()
{

}

void ServerProcess::Run()
{	
	m_CurrTime = NGetTicks();
//	ASSERT(m_SendTime < m_CurrTime + 240);
	if (m_CurrTime >= m_SendTime)
	{
		// send something out
		int ExtraTime = m_IntervalTime*rand()/RAND_MAX;
		m_SendTime = m_CurrTime + m_IntervalTime/2 + ExtraTime; // 200 ms
		if (m_SendSocket != -1)
			m_pOS->SendTo(m_SendSocket,ACCESSPOINTIP,m_SendBuffer,10000);
		//	m_pOS->Send(m_SendSocket,m_SendBuffer,10000);
	}
	
}

void ServerProcess::Init()
{
	
	strcpy(m_ProcessName,"Server");
	// init create the socket
	Process::Init();
	m_SendSocket = m_pOS->CreateSocket(0,SockDataGram);
	m_pOS->SetSockOpt(m_SendSocket,BROADCAST);

}

void ServerProcess::SetDataRate(int BRData)
{
	// set it up to match the bit rate approx
	int MPerSecond = BRData/10000;
	m_IntervalTime = 1000/MPerSecond;
}
