// VideoClientProcess.cpp: implementation of the VideoClientProcess class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "VideoClientProcess.h"
#include "VideoServerProcess.h"
#include "Network.h"
#include "NetworkStats.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VideoClientProcess::VideoClientProcess()
{
	m_StreamingTime = 0;
	m_StreamingTimeInt = FRAMERATE;
	m_CurrBufferSize = 0;
	m_NumTimesSkipped = 0;

	m_bPlayedLastFrame = true;
	m_RunCounter = 0;
	m_TotalPlayedRuns = 0;
	m_TotalMissedRuns = 0;
	m_PlayedRunSizeC = 0;
	m_MissedRunSizeC = 0;
	m_AvgPlayedRunSize = 0;
	m_AvgMissedRunSize = 0;

	m_BufferSizeC = 0; 
	m_BufferSizeT = 0;

	m_MaxHBuffer = 30;
	m_MinHBuffer = 10;
	m_bBufferBigEnough = false;

	m_StatsAvgPlayedRun = g_NetworkStats.GetCustomStats(this,"AvgPlayedRun");
	m_StatsAvgMissedRun = g_NetworkStats.GetCustomStats(this,"AvgMissedRun");
	m_StatsNumTimesSkipped = g_NetworkStats.GetCustomStats(this,"NumTimesSkipped");
	m_StatsAvgBufferSize = g_NetworkStats.GetCustomStats(this,"AvgBufferSize");


}

VideoClientProcess::~VideoClientProcess()
{

}

//====================================================================
// void Init();
//
// Init the server
//
//====================================================================
void VideoClientProcess::Init()
{
	strcpy(m_ProcessName,"VideoStreamingClient");
	// init create the socket
	Process::Init();
	m_DataSocket = m_pOS->CreateSocket(VIDEODATAPORT,SockDataGram,this);
	m_pOS->SetSockOpt(m_DataSocket,BROADCAST);
	m_ControlSocket = m_pOS->CreateSocket(VIDEOCONTROLPORT,SockDataGram,this);
	m_pOS->SetSockOpt(m_ControlSocket,BROADCAST);

}

//====================================================================
// void OnStart();
//
// Called after all of the processes init
//
//====================================================================
void VideoClientProcess::OnStart()
{

}

//====================================================================
// void DrawStats(CDC *pDC, CPoint &Offset)
//
// Called after all of the processes init
//
//====================================================================
void VideoClientProcess::UserDrawStats(CDC *pDC, CPoint Offset, CPoint &Size)
{
	m_AvgBufferSize	=	(float)m_BufferSizeC/(float)m_BufferSizeT;
	m_AvgPlayedRunSize = (float)m_PlayedRunSizeC/(float)m_TotalPlayedRuns; // avg playing run size
	m_AvgMissedRunSize = (float)m_MissedRunSizeC/(float)m_TotalMissedRuns; 


	char tempo[200];
	sprintf(tempo,"Buffer Size: %6.2f Skipped Frames : %d",m_AvgBufferSize,m_NumTimesSkipped);
	pDC->TextOut(Offset.x+2,Size.y,tempo);	
	Size.y += 15;

	sprintf(tempo,"Played Frames: %d Missed Frames : %d"
		,m_VideoBuffer.m_StatsGoodFrames,m_VideoBuffer.m_StatsSkippedFrames);
	pDC->TextOut(Offset.x+2,Size.y,tempo);	
	Size.y += 15;

	sprintf(tempo,"Buffer resets: %d "
		,m_VideoBuffer.m_StatsNumResetBuffer);
	pDC->TextOut(Offset.x+2,Size.y,tempo);	
	Size.y += 15;

		
	
	sprintf(tempo,"Avg play Runs: %6.2f Avg missed Runs: %6.2f"
		,m_AvgPlayedRunSize,m_AvgMissedRunSize);
	pDC->TextOut(Offset.x+2,Size.y,tempo);	
	Size.y += 15;


}

void VideoClientProcess::Run()
{	
	if (m_StreamingTime <= NGetTicks())
	{
		m_CurrBufferSize = m_VideoBuffer.GetNumFrames();
//		ASSERT(m_CurrBufferSize < 40);
		m_BufferSizeC += m_CurrBufferSize;
		m_BufferSizeT++;

		bool CanPlay = false;
		if (m_bBufferBigEnough)
		{
			if (m_CurrBufferSize > m_MinHBuffer)
				CanPlay = true;
			else
				m_bBufferBigEnough = false;
		}
		else
		{
			if (m_CurrBufferSize > m_MaxHBuffer)
			{
				CanPlay = true;
				m_bBufferBigEnough = true;
			}
		}

		if (CanPlay)
		{
			char *tBuffer = m_ReceiveBuffer;
			bool ValidData = m_VideoBuffer.GetData(tBuffer);
			if (m_bPlayedLastFrame)
			{
				if (ValidData)
				{
					m_RunCounter++;
					if (m_RunCounter >= 50)
					{
						m_TotalPlayedRuns++;
						m_PlayedRunSizeC += m_RunCounter;
						m_RunCounter = 1;
					}

				}
				else
				{
					m_TotalPlayedRuns++;
					m_PlayedRunSizeC += m_RunCounter;
					m_bPlayedLastFrame = false;
					m_RunCounter = 1;
				}
			}
			else
			{
				if (ValidData)
				{
					m_bPlayedLastFrame = true;
					m_TotalMissedRuns++;
					m_MissedRunSizeC += m_RunCounter;
					m_RunCounter = 1;
				}
				else
				{
					m_RunCounter++;
					if (m_RunCounter >= 50)
					{
						m_TotalMissedRuns++;
						m_MissedRunSizeC += m_RunCounter;
						m_RunCounter = 1;
					}
				}
			}

		}
		else
			m_NumTimesSkipped++;

		m_StreamingTime += m_StreamingTimeInt; // no jitter for now
	}

}

void VideoClientProcess::OnMessageSent(int Port)
{
}

void VideoClientProcess::OnMessageReceived(int SourceIP, int Port)
{
	if (Port == VIDEOCONTROLPORT)
	{	
		
	}
	else if (Port == VIDEODATAPORT)
	{
		m_pOS->Receive(m_DataSocket,m_ReceiveBuffer,MAXMESSAGESIZE);
		m_VideoBuffer.AddData(m_ReceiveBuffer);		
	}

}

//====================================================================
// void OnGenerateStats()
//
// Called once a second to generate statistics
//
//====================================================================
void VideoClientProcess::OnSaveStats()
{
	m_AvgPlayedRunSize = (float)m_PlayedRunSizeC/(float)m_TotalPlayedRuns; // avg playing run size
	m_AvgMissedRunSize = (float)m_MissedRunSizeC/(float)m_TotalMissedRuns; 
	m_AvgBufferSize	=	(float)m_BufferSizeC/(float)m_BufferSizeT;

	g_NetworkStats.AddCustomStats(m_StatsAvgPlayedRun,m_AvgPlayedRunSize);
	g_NetworkStats.AddCustomStats(m_StatsAvgMissedRun,m_AvgMissedRunSize);
	g_NetworkStats.AddCustomStats(m_StatsNumTimesSkipped,m_NumTimesSkipped);
	g_NetworkStats.AddCustomStats(m_StatsAvgBufferSize,m_AvgBufferSize);

}