// VideoClientProcess.h: interface for the VideoClientProcess class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIDEOCLIENTPROCESS_H__FFBE8FC5_3593_47D9_928F_0EB8BE2503D5__INCLUDED_)
#define AFX_VIDEOCLIENTPROCESS_H__FFBE8FC5_3593_47D9_928F_0EB8BE2503D5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Process.h"
#include "VideoBuffer.h"

class VideoClientProcess  : public Process  
{
public:

	// virtual overrides
	void OnMessageReceived(int SourceIP, int Port);
	void OnMessageSent(int Port);
	void OnStart();
	void Run();
	void Init();
	void UserDrawStats(CDC *pDC, CPoint Offset, CPoint &Size);
	void OnSaveStats();

	int m_DataSocket;
	int m_ControlSocket;
	int m_StreamingTime;
	int m_StreamingTimeInt;
	bool m_bBufferBigEnough; // heisterisis for the buffer pauses and lets it fill up
	int m_MaxHBuffer; // maximum before turning playing on
	int m_MinHBuffer; // minimum before turning playing off

	int m_CurrBufferSize;
	int m_NumTimesSkipped;

	// statistics on the nature of the runs 
	bool m_bPlayedLastFrame; // is the last frame played or missed
	int m_RunCounter; // the current num in the current run
	int m_TotalPlayedRuns; // total played run for avg
	int m_TotalMissedRuns; // total missed run for avg
	int m_PlayedRunSizeC; // total played run counter
	int m_MissedRunSizeC; // total missed run counter
	float m_AvgPlayedRunSize; // avg playing run size
	float m_AvgMissedRunSize; // avg missed run size
	float m_AvgBufferSize;
	int m_BufferSizeC;
	int m_BufferSizeT;

	int m_StatsAvgPlayedRun;
	int m_StatsAvgMissedRun;
	int m_StatsNumTimesSkipped;
	int m_StatsAvgBufferSize;

	char m_ReceiveBuffer[MAXMESSAGESIZE]; // just a dummy buffer to send messages

	VideoBuffer m_VideoBuffer;

	VideoClientProcess();
	virtual ~VideoClientProcess();

};

#endif // !defined(AFX_VIDEOCLIENTPROCESS_H__FFBE8FC5_3593_47D9_928F_0EB8BE2503D5__INCLUDED_)
