// VideoServerProcess.cpp: implementation of the VideoServerProcess class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ProtocalSim.h"
#include "VideoServerProcess.h"
#include "NetworkDef.h"
#include "Network.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VideoServerProcess::VideoServerProcess()
{
	m_ReadyToSend = true;
	m_SkippedSending = 0;

	m_SendTime = 0;
	m_SendIncTime = FRAMERATE; // 30 frames per second
	m_FrameSize = 20000; // 20000 bytes per frame
	m_FrameNumber = 0;

}

VideoServerProcess::~VideoServerProcess()
{

}

//====================================================================
// void Init();
//
// Init the server
//
//====================================================================
void VideoServerProcess::Init()
{
	strcpy(m_ProcessName,"VideoStreamingServer");
	// init create the socket
	Process::Init();
	m_DataSocket = m_pOS->CreateSocket(VIDEODATAPORT,SockDataGram,this);
	m_pOS->SetSockOpt(m_DataSocket,BROADCAST);
	m_ControlSocket = m_pOS->CreateSocket(VIDEOCONTROLPORT,SockDataGram,this);
	m_pOS->SetSockOpt(m_ControlSocket,BROADCAST);

}

//====================================================================
// void OnStart();
//
// Called after all of the processes init
//
//====================================================================
void VideoServerProcess::OnStart()
{

}

//====================================================================
// void DrawStats(CDC *pDC, CPoint &Offset)
//
// Called after all of the processes init
//
//====================================================================
void VideoServerProcess::UserDrawStats(CDC *pDC, CPoint Offset, CPoint &Size)
{
	char tempo[200];
	sprintf(tempo,"Skipped Frames %d",m_SkippedSending);
	pDC->TextOut(Offset.x+2,Size.y,tempo);	
	Size.y += 15;

}

void VideoServerProcess::Run()
{	
	if (m_SendTime <= NGetTicks())
	{
	//	if (m_ReadyToSend)
	//	{
			char *tBuffer = m_SendBuffer;
			RTPINFO RTPInfo;
			RTPInfo.TimeStamp = NGetUTicks();
			RTPInfo.FrameNumber = m_FrameNumber;
			m_FrameNumber++;
			g_Protocals.CatRTPInfo(tBuffer,RTPInfo);
			m_pOS->Send(m_DataSocket,m_SendBuffer,m_FrameSize);
			m_ReadyToSend = false;

	//	}
	//	else
	//	{
	//		m_FrameNumber++;
	//		m_SkippedSending++;
	//	}
		m_SendTime += m_SendIncTime; // no jitter for now
	}

}

void VideoServerProcess::OnMessageSent(int Port)
{
	m_ReadyToSend = true;
}

void VideoServerProcess::OnMessageReceived(int SourceIP, int Port)
{
	if (Port == VIDEOCONTROLPORT)
	{	
	}
	else if (Port == VIDEODATAPORT)
	{
	}
}

