// ChildView.h : interface of the CChildView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHILDVIEW_H__1A22E6B3_4D15_4A45_9CBC_415AE076C84B__INCLUDED_)
#define AFX_CHILDVIEW_H__1A22E6B3_4D15_4A45_9CBC_415AE076C84B__INCLUDED_

#include "UDraw.h"	// Added by ClassView
#include "UQuadTree.h"	// Added by ClassView
#include "UConsole.h"	// Added by ClassView
#include "ULinearAlgebra.h"	// Added by ClassView

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CChildView window

// used to get the system resources
#define SYSTEMRESOURCETIMER 1
#define GFSR_SYSTEMRESOURCES	0
#define GFSR_GDIRESOURCES		1
#define GFSR_USERRESOURCES		2
typedef LONG (CALLBACK* GETRES)(int);

#define CONSOLEID 100
#define CONSOLELOGID 101


class CChildView : public CWnd 
{
// Construction
public:
	CChildView();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChildView)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
    public:

public:
	int PrevCursor;
    UConsole ConsoleClass;
    UConsole::CONSOLESTRUCT Console;

	void ResizeConsole();
	void InitConsole();

    BOOL E_SonarSensorEnabled;
    BOOL E_IRSensorEnabled;
	BOOL E_MoveObject;
	BOOL E_SnapEnabled;
	BOOL E_SelectEnabled;	
    BOOL E_DrawArcEnabled;
	BOOL E_DrawLineEnabled;
    BOOL E_PanEnabled;
	BOOL E_ZoomEnabled;
    BOOL E_BumpSensorEnabled;
	BOOL E_RobotPlacementEnabled;

    void LoadCursors();
	UDraw Draw;
	BOOL Once;
	long lUsrRes;
	long lGdiRes;
	long lSysRes;
	int CurCursor;
    HCURSOR m_hCursor[16];
	HCURSOR PanCursor;
	BOOL LButtonDown;
	void ResetAllActions();

	UQuadTree QuadTree;
	virtual ~CChildView();

	// Generated message map functions
protected:
public:
	CPoint OldScrollMousePoint;
	ULinearAlgebra LAUtils;
	CPoint MousePoint;
	CString SaveFileName;
	LRESULT OnSaveState(WPARAM,LPARAM);
	void PopupAlignChecks();
	CMenu Popup;
	CRect SelectingBox;
	BOOL E_IsSelectingBox;
        
    	//{{AFX_MSG(CChildView)
	afx_msg void OnPaint();
	afx_msg void OnZoom();
	afx_msg void OnPan();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnOptionsZoomout();
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDrawline();
	afx_msg void OnSelect();
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnOptionsDrawingoptions();
	afx_msg void OnDrawingtoolsDrawarc();
	afx_msg void OnDrawingtoolsGroup();
	afx_msg void OnDrawingtoolsUngroup();
	afx_msg void OnFileSaveAs();
	afx_msg void OnFileOpen();
	afx_msg void OnFileNew();
	afx_msg void OnDrawingtoolsMoveobjects();
	afx_msg void OnEditCopy();
	afx_msg void OnEditPaste();
	afx_msg void OnEditCut();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnFilePrint();
	afx_msg void OnDrawingtoolsAdddepth();
	afx_msg void OnDrawingtoolsRotate();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnPopupTogglegridsnap();
	afx_msg void OnPopupTogglepolarsnap();
	afx_msg void OnPopupTogglesnaptoendpoint();
	afx_msg void OnModeloptionsAddbumpsensor();
	afx_msg void OnEditUndo();
	afx_msg void OnEditRedo();
	afx_msg void OnFileSave();
	afx_msg void OnModeloptionsEditproperties();
	afx_msg void OnModeloptionsAddirsensor();
	afx_msg void OnModeloptionsAddsonarsensor();
	afx_msg void OnFileSavewoarcs();
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnPlacerobot();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHILDVIEW_H__1A22E6B3_4D15_4A45_9CBC_415AE076C84B__INCLUDED_)
