// UConsole.h: interface for the UConsole class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UCONSOLE_H__EB9D7E7A_EB9A_45B9_83B6_12372B2CD78C__INCLUDED_)
#define AFX_UCONSOLE_H__EB9D7E7A_EB9A_45B9_83B6_12372B2CD78C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define BREAKCHARACTER '>'

#include "UDraw.h"
#include "UEdit.h"

#define MAXDEPTH 5000
#define MINDEPTH 0


enum POINTTYPE {Normal,Delta,Polar};
/******************************************************************
* The might console class.  It handles all user input
*
*
*
******************************************************************/

class UConsole
{
    struct CONSOLESTATE
    {
        BOOL line1; // user typed in line
        BOOL line2; // user entered the starting coordinates
        BOOL line3; // user specified delta coordinates
        BOOL line4; // user specified polar coordinates
        CPoint LineStart; // in case delta/ or polar coordinates are specified
        BOOL Arc1;
        BOOL Arc2;
        BOOL Arc3;
        BOOL Depth1;
        BOOL Depth2;
        int Depth;
        BOOL inSide;
        BOOL Rotate1;
        BOOL Rotate2;
        CPoint RotateCenter;
        BOOL Move1;
        BOOL Move2;
        BOOL BumpSensor1;
        BOOL BumpSensor2;
        BOOL BumpSensor3;
        BOOL IRSensor1;
        BOOL IRSensor2;
        BOOL IRSensor3;
        BOOL IRSensor4;
        long IRMin;
        long IRMax;
        BOOL SonarSensor1;
		BOOL RobotPlacement1;
    };

public:

    struct CONSOLESTRUCT
    {
        int ConsoleLongYSize;
	    int ConsoleYOffset;
	    int ConsoleYSize;
    	CRect ConsoleLogRect;
	    CRect ConsoleRect;
	    UEdit ConsoleLog;
	    UEdit Console;
    };

public:

	void CreateUndoState();
	BOOL SM_Move(CString &Instruction);
	BOOL SM_Move(CPoint Point);
	BOOL isMoveState();

	BOOL SM_Rotate(CPoint Point);
	BOOL SM_Rotate(CString &Instruction);
	BOOL isRotateState();

	BOOL isDepthState();
	BOOL SM_AddDepth(CString &Instruction);

	BOOL SM_Arc(CPoint Point);
	BOOL SM_Arc(CString &Instruction);
	BOOL isArcState();

    BOOL SM_BumpSensor(CPoint Point);
	BOOL SM_BumpSensor(CString &Instruction);
	BOOL isBumpSensorState();

    
    BOOL SM_IRSensor(CPoint Point);
	BOOL SM_IRSensor(CString &Instruction);
	BOOL isIRSensorState();

    
    BOOL SM_SonarSensor(CPoint Point);
	BOOL SM_SonarSensor(CString &Instruction);
	BOOL isSonarSensorState();

    BOOL SM_RobotPlacement(CPoint Point);
	BOOL SM_RobotPlacement(CString &Instruction);
	BOOL isRobotPlacementState();

	BOOL isLineState();
    BOOL SM_Line(CPoint Point);
    BOOL SM_Line(CString &Instruction);

    CWnd *ParentPtr;
	CONSOLESTRUCT *theConsole;
	void EnterText(CString Text);

    CString Enter;
	void CancelCommand();

    // helper functions
	CPoint ParsePoint(CString &Instruction);
    BOOL IsValidNumber(int number); 
	
	BOOL ParseInstruction(CString &Instruction);
	void ClearAllStates();
	
	BOOL isInitialState();

    UDraw *DrawPtr;
    CONSOLESTATE ConsoleState;

    // used by the window class
    void OnEnter(CONSOLESTRUCT &theConsole);

	UConsole();
	virtual ~UConsole();

};

#endif // !defined(AFX_UCONSOLE_H__EB9D7E7A_EB9A_45B9_83B6_12372B2CD78C__INCLUDED_)
