// UDraw.cpp: implementation of the UDraw class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Mapper.h"
#include "UDraw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

UDraw::UDraw()
{
    DrawingArea.top=40;
    DrawingArea.bottom=400;
    DrawingArea.left=40;
    DrawingArea.right=400;
    // this is half the size of a cursor icon, or in the middle of it.
    CursorOffset.x=16;
    CursorOffset.y=16;
    ZoomRatio = 1; // 1 cm per pixel
    CurrentView.top=0;
    CurrentView.bottom=12800;
    CurrentView.left=0;
    CurrentView.right=12800;
    PanLimit = false; // if the user can't pan beyond the quad tree limits
    isDrawingLine = false;
    SelectRange = 3; // 3 works fine

    E_SnapToEndPoint = true;
    SnapApetureSize = 5;
    E_ForcePolar = false;
    ForcePolarAngle = 15;
    E_ForceGrid = false;
    ForceGridDX = 100;
    ForceGridDY = 100;

    RealSensorScale = true;

    E_SelectBoxMustbeInside = false;

    ResetDrawArc();

}

UDraw::~UDraw()
{

}

// toPan is the mouse position, not a displacement.
void UDraw::PanView(CPoint toPan)
{
        int XPan = (int)((PrevMousePos.x-toPan.x)*8);
        int YPan = (int)((PrevMousePos.y-toPan.y)*8);
        int CurrViewWidth = CurrentView.Width();
        int CurrViewHeight = CurrentView.Height();
        CurrentView.top+=YPan;
        CurrentView.bottom+=YPan;
        CurrentView.left+=XPan;
        CurrentView.right+=XPan;

        
        // if statements to make sure the user does't pan off the screen
        if (PanLimit)
        {
            if (CurrentView.left < XMin)
            {
                CurrentView.left = 0;
                CurrentView.right = CurrViewWidth;
            }
            else if (CurrentView.right > XMax)
            {
                CurrentView.right = XMax;
                CurrentView.left = XMax-CurrViewWidth;
            }
            if (CurrentView.top < YMin)
            {
                CurrentView.top = 0;
                CurrentView.bottom = CurrViewHeight;
            }
            else if (CurrentView.bottom > YMax)
            {
                CurrentView.bottom = YMax;
                CurrentView.top = YMax-CurrViewHeight;
            }
        }

}

void UDraw::ZoomView(CPoint point)
{
    float ZoomFactor;
    int YPan = (PrevMousePos.y-point.y);
    if (YPan > 0)
    {
        ZoomFactor=(float)1.1;
    }
    else
    {
        ZoomFactor=(float).9;            
    }
    
    // make the mouse the center of the screen.
    int newWidth = (int)(CurrentView.Width()/ZoomFactor);
    int newHeight = (int)(CurrentView.Height()/ZoomFactor);

     bool Donotchangezoom = false;

    // make sure the user can't zoom greater then the screen area.
    if (newWidth > XMax)
    {
        newWidth = XMax;
        Donotchangezoom = true;
    }
    if (newHeight > YMax)
    {
        newHeight = YMax;
        Donotchangezoom = true;
    }   

    if (newWidth < MINZOOM)
    {
        newWidth = MINZOOM;
        Donotchangezoom = true;
    }
    if (newHeight < MINZOOM)
    {
        newHeight = MINZOOM;
        Donotchangezoom = true;
    }
    if (!Donotchangezoom)
    {
        // change the global ratio, currently used for move responsive panning
        ZoomRatio *=ZoomFactor;
    }

    // zoom into the area where the mouse cursor is, (that is why there is the extra math
    CurrentView.left = ZoomMousePos.x - newWidth/2;
    CurrentView.right = CurrentView.left + newWidth;
    CurrentView.top =  ZoomMousePos.y - newWidth/2;
    CurrentView.bottom = CurrentView.top + newHeight;
    // if statements to make sure the user does't pan off the screen
    if (CurrentView.left < XMin)
    {
        CurrentView.left = 0;
        CurrentView.right = newWidth;
    }
    else if (CurrentView.right > XMax)
    {
        CurrentView.right = XMax;
        CurrentView.left = XMax-newWidth;
    }
    if (CurrentView.top < YMin)
    {
        CurrentView.top = 0;
        CurrentView.bottom = newHeight;
    }
    else if (CurrentView.bottom > YMax)
    {
        CurrentView.bottom = YMax;
        CurrentView.top = YMax-newHeight;
    }

}

void UDraw::ResetView()
{
    CurrentView.top=0;
    CurrentView.bottom=12800;
    CurrentView.left=0;
    CurrentView.right=12800;
    ZoomRatio = 1;

}

// sets a point for the zoom in to occur.
void UDraw::SetZoomCenter(CPoint point)
{
    ZoomMousePos = ScreentoReal(point);
    
}

CPoint UDraw::ScreentoReal(CPoint Coord)
{
    CPoint temp;
     // translate the mouse point into a real point
    temp.x = (int)((float)(Coord.x-DrawingArea.left+CursorOffset.x)/(float)(DrawingArea.Width())*CurrentView.Width() + CurrentView.left);//CurrentView.Width());
    temp.y = (int)((float)(Coord.y-DrawingArea.top+CursorOffset.y)/(float)(DrawingArea.Height())*CurrentView.Height() + CurrentView.top);//CurrentView.Height());

    // snap to end take precendent over all other "snap" modes
    if (E_SnapToEndPoint)
    {
        int Range = (int)(SnapApetureSize*CurrentView.Width()/DrawingArea.Width())+1;
        CPoint tempo = QuadTreePtr->DraftingSnaptoEndpoint(temp,Range);

        if (tempo.x != -1)
            return tempo;
       // else
         //   return temp;
    }
          // first check the angle
        // algorithm, find the angle of the current point, then pick the closest set angle
        // to that and use the same distance.
    if (E_ForcePolar)
    {
        CPoint Reference = QuadTreePtr->DraftingGetStartPoint();
        if (Reference.x != -1)
        {
            double Angle = LinearAlgebra.GetAngle(temp,Reference);
            float Distance = LinearAlgebra.GetDistance(Reference,temp);

            // get the snap angle
            long Inc = (long)((Angle+ForcePolarAngle/2)/(long)ForcePolarAngle);
            double SnapAngle = Inc*ForcePolarAngle;
            double Cos = cos(SnapAngle*PI/180.0);
            double Sin = sin(SnapAngle*PI/180.0);

            // to stop annoying PI is not PI error
            if (Cos > 0)
            {
                if (Cos < 0.0001)
                    Cos = 0;
            }
            else
            {
                if (Cos > -0.0001)
                    Cos = 0;
            }

            if (Sin > 0)
            {
                if (Sin < 0.0001)
                    Sin = 0;
            }
            else
            {
                if (Sin > -0.0001)
                    Sin = 0;
            }
            temp.x = (long)(Reference.x + Distance*Cos);
            temp.y = (long)(Reference.y - Distance*Sin);
        }

    }
    // Next check the grid, should be done in this order, won't really work but should be close
    if (E_ForceGrid)
    {
        if (ForceGridDX != 0)
        {
            temp.x = (temp.x/ForceGridDX)*ForceGridDX;
        }
        if (ForceGridDY != 0)
        {
            temp.y = (temp.y/ForceGridDX)*ForceGridDY;
        }
    }
    
    
   

    return temp;


}

void UDraw::DrawLine(CPoint Point, BOOL isReal)
{
    if (!isReal)
    {
        QuadTreePtr->DraftingAddLine(ScreentoReal(Point));
    }
    else
    {
        QuadTreePtr->DraftingAddLine(Point);
    }   

}

int UDraw::SelectObject(CPoint point, BOOL Select)
{
    CPoint NewPoint = ScreentoReal(point);
    float Range = (((float)SelectRange*(float)CurrentView.Width())/(float)DrawingArea.Width());
    // could happen
    if (Range <= 0)
    {
        Range = 1;
    }
    return QuadTreePtr->SelectObject(NewPoint,Range,Select);

}

// just a wrapper
void UDraw::DeleteSelectedObject()
{
    QuadTreePtr->SelectDeleteAll();

}

void UDraw::SetCenterCursorOffset()
{
    // this is half the size of a cursor icon, or in the middle of it.
    CursorOffset.x=16;
    CursorOffset.y=16;

}

void UDraw::ResetCursorOffset()
{
    CursorOffset.x=0;
    CursorOffset.y=0;

}

// tell the QuadTree to relase any drafting features.
void UDraw::OnLButtonUp()
{
    QuadTreePtr->DraftingOnMouseUp();    

}

void UDraw::OnMouseMove(CPoint Point, BOOL isReal)
{
    if (!isReal)
        QuadTreePtr->DraftingOnMouseMoved(ScreentoReal(Point));    
    else
        QuadTreePtr->DraftingOnMouseMoved(Point); 


}

void UDraw::OnDrawingOptions()
{
    DOptions temp;

    temp.m_SelectionRange = SelectRange;
    temp.m_SnapApetureSize = SnapApetureSize;
    temp.m_SnaptoEndpoint = E_SnapToEndPoint;
    temp.m_SnapRectange = QuadTreePtr->RenderApetureSize;
    temp.m_NLinesinArc = QuadTreePtr->DefaultLinesinArc; 
    temp.m_ForcePolar = E_ForcePolar;
    temp.m_ForceGrid = E_ForceGrid;
    temp.m_ForceDX = ForceGridDX;
    temp.m_ForceDY = ForceGridDY;
    temp.m_ForceAngle = ForcePolarAngle;
    temp.m_SelectBoxMustbeInside = E_SelectBoxMustbeInside;
    temp.m_RealSensorsScale = RealSensorScale;
    
    if (temp.DoModal() == IDOK)
    {
        SelectRange = temp.m_SelectionRange;
        SnapApetureSize = temp.m_SnapApetureSize;
        E_SnapToEndPoint = temp.m_SnaptoEndpoint;
        QuadTreePtr->RenderApetureSize = temp.m_SnapRectange;
        QuadTreePtr->DefaultLinesinArc = temp.m_NLinesinArc;
        E_ForcePolar = temp.m_ForcePolar;
        E_ForceGrid = temp.m_ForceGrid; 
        ForceGridDX = temp.m_ForceDX; 
        ForceGridDY = temp.m_ForceDY; 
        ForcePolarAngle = temp.m_ForceAngle;
        E_SelectBoxMustbeInside = temp.m_SelectBoxMustbeInside;
        RealSensorScale = temp.m_RealSensorsScale;

        if (RealSensorScale)
            QuadTreePtr->SensorRenderingScale = REALSENSORSCALE;
        else
            QuadTreePtr->SensorRenderingScale = BIGSENSORSCALE;
    }
    

}

void UDraw::DrawArc(CPoint thePoint, BOOL isReal)
{
 /*   if (DrawingArc.start.x == -1)
    {
        DrawingArc.start = ScreentoReal(thePoint);
    }
    else if (DrawingArc.middle.x == -1)
    {
        DrawingArc.middle = ScreentoReal(thePoint);
    }
    else
    {
        QuadTreePtr->AddArc(DrawingArc.start,DrawingArc.middle,ScreentoReal(thePoint));
        ResetDrawArc();
    }*/

    if (isReal)
    {
        QuadTreePtr->DraftingAddArc(thePoint);
    }
    else
    {
        QuadTreePtr->DraftingAddArc(ScreentoReal(thePoint));
    }

}

void UDraw::ResetDrawArc()
{
    DrawingArc.start.x = -1;
    DrawingArc.middle.x = -1;
    DrawingArc.end.x = -1;

}


// wrapper for quadtree group objects
void UDraw::GroupObjects()
{
    QuadTreePtr->SelectCreateGroup();
    // not covered by the console, so neccessary here
    AddtoUndoState();
}

// wrapper for quadtree ungroup objects
void UDraw::UngroupObjects()
{

    QuadTreePtr->SelectDeleteGroup();
    // not covered by the console, so neccessary here
    AddtoUndoState();
}


// wrapper for quadtree move object
void UDraw::MoveObjects(CPoint Point, BOOL isReal)
{    
    if (!isReal)
    {
        QuadTreePtr->DraftingMoveGroup(ScreentoReal(Point));
    }
    else
    {
        QuadTreePtr->DraftingMoveGroup(Point);
    }   
}

// wrapper for quadtree Copy Group
void UDraw::CopyGroup()
{
    QuadTreePtr->DraftingCopyGroup();
    // not covered by the console, so neccessary here
    AddtoUndoState();
}

// wrapper for quadtree Move Group
void UDraw::PasteGroup(CPoint Point)
{
    QuadTreePtr->DraftingPasteGroup(ScreentoReal(Point));
    // not covered by the console, so neccessary here
    AddtoUndoState();

}

void UDraw::CutGroup()
{
    QuadTreePtr->DraftingCutGroup();
    // not covered by the console, so neccessary here
    AddtoUndoState();

}

// selects all objects in an area
void UDraw::SelectBox(CRect SelectingBox)
{
    // need to get the real coordinates
    CPoint Start,End;

    Start.x = SelectingBox.left;
    Start.y = SelectingBox.top;
    End.x = SelectingBox.right;
    End.y = SelectingBox.bottom;

    Start = ScreentoReal(Start);
    End = ScreentoReal(End);

    SelectingBox.left = Start.x;
    SelectingBox.top = Start.y;
    SelectingBox.right = End.x;
    SelectingBox.bottom = End.y;

    // need to make sure top left and bottom right are used
    if (SelectingBox.top > SelectingBox.bottom)
    {
        long tempo;
        tempo = SelectingBox.top;
        SelectingBox.top = SelectingBox.bottom;
        SelectingBox.bottom = tempo;
    }
    if (SelectingBox.left > SelectingBox.right)
    {
        long tempo;
        tempo = SelectingBox.left;
        SelectingBox.left = SelectingBox.right;
        SelectingBox.right = tempo;
    }

    QuadTreePtr->SelectArea(SelectingBox,E_SelectBoxMustbeInside);

}

void UDraw::RotateGroup(CPoint CenterPoint, int Angle, BOOL isReal)
{
    if (!isReal)
    {
        QuadTreePtr->DraftingRotate(ScreentoReal(CenterPoint),Angle);
    }
    else
    {
        QuadTreePtr->DraftingRotate(CenterPoint,Angle);
    }

}

void UDraw::AddBumpSensor(CPoint thePoint, BOOL isReal)
{
    if (!isReal)
    {
        QuadTreePtr->DraftingAddBumpSensor(ScreentoReal(thePoint));
    }
    else
    {
        QuadTreePtr->DraftingAddBumpSensor(thePoint);
    }   
}

void UDraw::AddIRSensor(CPoint thePoint, long MinRange, long MaxRange, long Angle)
{

    QuadTreePtr->DraftingAddIRSensor(thePoint,MinRange,MaxRange,Angle);

}

void UDraw::AddSonarSensor(CPoint thePoint, BOOL isReal)
{
    if (!isReal)
    {
        QuadTreePtr->DraftingAddSonarSensor(ScreentoReal(thePoint));
    }
    else
    {
        QuadTreePtr->DraftingAddSonarSensor(thePoint);
    }   
}


// Called when the user undos
void UDraw::OnUndo()
{
    if (UndoStruct.UndoIndex != UndoMod(UndoStruct.LastIndex+1))
    {
        UndoStruct.UndoIndex = UndoMod(UndoStruct.UndoIndex-1);
    
        // we want the one before the index
        int temp = UndoMod(UndoStruct.UndoIndex-1);

        UndoStruct.UndoFile[temp].SeekToBegin();
        CurrentView = QuadTreePtr->FileOpenMap(UndoStruct.UndoFile[temp]);

    }


}

// Called when the user redos
void UDraw::OnRedo()
{
    if (UndoStruct.RedoIndex != UndoStruct.UndoIndex)
    {        
        UndoStruct.UndoFile[UndoStruct.UndoIndex].SeekToBegin();
        CurrentView = QuadTreePtr->FileOpenMap(UndoStruct.UndoFile[UndoStruct.UndoIndex]);
        UndoStruct.UndoIndex = UndoMod(UndoStruct.UndoIndex+1);
    }
}

// called when it is time to update the state of the undo list.
void UDraw::AddtoUndoState()
{
    // "closes the file"
    delete UndoStruct.UndoFile[UndoStruct.UndoIndex].Detach();

    UndoStruct.UndoFile[UndoStruct.UndoIndex].SeekToBegin();
    QuadTreePtr->FileSaveMap(UndoStruct.UndoFile[UndoStruct.UndoIndex],CurrentView, false);

    UndoStruct.UndoIndex = UndoMod(UndoStruct.UndoIndex+1);

    UndoStruct.RedoIndex = UndoStruct.UndoIndex;

    if (UndoStruct.UndoIndex == 0)
        UndoStruct.WrappedAround = true;

    if (UndoStruct.WrappedAround)
    {
        UndoStruct.LastIndex = UndoStruct.UndoIndex;
    }


}

int UDraw::UndoMod(int number)
{
    if (number > MAXUNDO-1)    
            return 0;
    else if (number < 0)
        return MAXUNDO-1;
    else
        return number;
}

void UDraw::FlushUndo()
{
    UndoStruct.LastIndex = 0;
    UndoStruct.RedoIndex = 0;
    UndoStruct.UndoIndex = 0;
    UndoStruct.WrappedAround = false;
    AddtoUndoState(); // start up the undo pointers

}

void UDraw::AddRobotPlacement(CPoint thePoint, BOOL isReal)
{
    if (!isReal)
    {
        QuadTreePtr->AddRobotPlacement(ScreentoReal(thePoint),0);
    }
    else
    {
        QuadTreePtr->AddRobotPlacement(thePoint,0);
    }   
}
