// UDraw.h: interface for the UDraw class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UDRAW_H__865DE48E_C43D_412F_A940_F8971C365976__INCLUDED_)
#define AFX_UDRAW_H__865DE48E_C43D_412F_A940_F8971C365976__INCLUDED_

#include "UQuadTree.h"	// Added by ClassView
#include "DOptions.h"
#include "ULinearAlgebra.h"	// Added by ClassView

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// used to define maximum size of drawable area
#define XMax 12800
#define YMax 12800
#define XMin 0
#define YMin 0
#define MINZOOM 25

#define MAXUNDO 30 // really n-1

#define BIGSENSORSCALE (float)0.03 
#define REALSENSORSCALE 3

class UDraw  
{
public:

    struct DRAWINGARC
    {
        CPoint start;
        CPoint middle;
        CPoint end;
    };  

    // used to perform undo operations
    struct UNDOSTRUCT
    {
        CMemFile UndoFile[MAXUNDO];      
        int UndoIndex; // index of the most recent change
        int RedoIndex; // index for the redo
        int LastIndex; // index to prevent a wrap around.
        BOOL WrappedAround;
    };

public:
	BOOL RealSensorScale;
	void FlushUndo();
	int UndoMod(int number);
	void AddtoUndoState();
	void OnRedo();
	void OnUndo();
	UNDOSTRUCT UndoStruct;

	

	void AddRobotPlacement(CPoint thePoint, BOOL isReal);
    void AddIRSensor(CPoint thePoint, long MinRange, long MaxRange, long Angle);
    void AddSonarSensor(CPoint thePoint, BOOL isReal);
	void AddBumpSensor(CPoint thePoint, BOOL isReal);
	void RotateGroup(CPoint CenterPoint, int Angle, BOOL isReal);
	BOOL E_SelectBoxMustbeInside;
	void SelectBox(CRect SelectingBox);
	ULinearAlgebra LinearAlgebra;
	int ForceGridDX;
	int ForceGridDY;
	BOOL E_ForceGrid;
	int ForcePolarAngle;
	BOOL E_ForcePolar;
	void CutGroup();
	void PasteGroup(CPoint Point);
	void CopyGroup();
	void MoveObjects(CPoint Point, BOOL isReal);
	CPoint PrevMove;
	int SnapApetureSize;
	BOOL E_SnapToEndPoint;
	void UngroupObjects();
	void GroupObjects();
	void ResetDrawArc();
	DRAWINGARC DrawingArc;
	void DrawArc(CPoint thePoint, BOOL isReal);
	void OnDrawingOptions();
	void OnMouseMove(CPoint Point, BOOL isReal);
	void OnLButtonUp();
	int SelectRange;
	void ResetCursorOffset();
	void SetCenterCursorOffset();
	CPoint CursorOffset;
	void DeleteSelectedObject();
	int SelectObject(CPoint point, BOOL Select);
	UQuadTree *QuadTreePtr;
	CPoint isDrawingLineStart;
	void DrawLine(CPoint Point, BOOL isReal);
	BOOL isDrawingLine;  // used to keep track if a line is in the process of being drawn.
	CPoint ScreentoReal(CPoint Coord);
	void SetZoomCenter(CPoint point);
	CPoint ZoomMousePos;
	void ResetView();
	void ZoomView(CPoint point);
	BOOL PanLimit;
	CPoint PrevMousePos;
	void PanView(CPoint toPan);
    float ZoomRatio;
    CRect CurrentView;
    CRect DrawingArea;
	UDraw();
	virtual ~UDraw();

};

#endif // !defined(AFX_UDRAW_H__865DE48E_C43D_412F_A940_F8971C365976__INCLUDED_)
