// AIDisplayGraph.h: interface for the AIDisplayGraph class.
//
// this class could accuratly display a topolical graph
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_AIDISPLAYGRAPH_H__88FA6D45_865D_477E_81DC_ADFD4B9CEC0E__INCLUDED_)
#define AFX_AIDISPLAYGRAPH_H__88FA6D45_865D_477E_81DC_ADFD4B9CEC0E__INCLUDED_

#include "AIGraph.h"	// Added by ClassView
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ULinearAlgebra.h"
#include "AIGraphH.h"
#include "AIExplorer.h"

#define BLACKPEN 0
#define REDPEN 1
#define BLUEPEN 2
#define SELECTPENA 3
#define HALLWAYPEN 4
#define SELECTPENB 5
#define SHORTESTPATH 6

#define ZOOMPERCENT .01 

#ifdef SIMULATOR
#define TQSend AI->AIParseMessage
#endif

class AIDisplayGraph  
{
public:
	void FileSaveGraphAscii(CString FileName);
	void AIGetStates(CString &S1, CString &S2,  CString &S3, CString &S4);

	CString State1,State2,State3,State4;

	// printing functionality
	int PrintNotchSize;
	int RCGetNotchSize();
	float PrintZoomRatio;
	float PrintPrevZoom;
	void RCRestoreZoom();
	void RCSetPrintZoom(CRect OldRect, CRect PrintRect);
	CBrush BlueBrush;
	void RCEnableNormalPens();
	void RCEnablePrintPens();

	// to send a map over realiabily.
	STREAMMODE StreamMode;
	void DGRunSendMap(BOOL TimeOut);
	void DGSetupSendMap();
	void DGParseMessage(char *Ptr);

	// old an new send command functions
	void RCSendXPCommand(XPMessageStruct Message);
	void RCSetDestination();
	void RCSetCurrentNode();	
	void GetShortestPath();
	
	// two possible nodes for shortest path
	BOOL TurnA;
	int NodeSelectedA;
	int NodeSelectedB;
	void RCMouseDown(CPoint Point);	

	// file functionality
	BOOL IsUpdating; // semaphore like
	void FileOpenGraph(CString TheFileName);
	void FileSaveGraph(CString TheFileName);

	// a red pen
	CPen Pens[10];

	// pointer to AI, simulator only
	AIExplorer *AI;	

	// used to update current position
	void EnterCurrPosition(short Distance, char TDirection, unsigned short Node);
	void UpdatePosition();
	

	// standard user interface functions, variables
	CPoint DisplayPrevZoomPoint;
	CRect DisplayRect;	
	BOOL DisplayAutoCenter;
	void RCToggleAutoCenter();	
	CPoint RCScreentoReal(CPoint In);
	FPoint RCScreentoRealF(CPoint In);
	void RCSetZoomPoint(CPoint Point);
	void RCZoom(CPoint Point);
	void RCReset();

	// updates the graph, simulator only
	void UpdateGraph();

	// the linear algebra library
	ULinearAlgebra LAUtils;

	// used for saving function parameters
	struct GLOBALRENDERING
	{
		float XTransform;
		float YTransform;
		float XScale;
		float YScale;
		CRect Screen;
		CRect OldScreen;
		CRect TransformedScreen;
		CRect ExpandedArea;
		int Radius; // general radius for objects
		int RulerDepth; // depth of rules on screen	
	} GlobalRendering;

	// used for storing current position
	struct CURRENTPOSTION
	{
		unsigned short Node;
		char TDirection;
		short Distance;
	} CurrentPosition;

	// the one and only heap
	NODE Heap[MAXNODE];	
	
	// for updating the graph
	void ChartoShort(char *&ptr, short &Output);
	void ChartoShort(char *&ptr, unsigned short &Output);

	// constructor
	void InitGraph();
	

	FPoint DisplayPointCenter;
	float ZoomRatio; // =1 if 1 to 1, the greater, the greater the zoom

	// Enters a node based on graph output
	unsigned short EnterNode(char *ptr);	

	// GDI renderer
	void RenderGDI(CDC &MemDC, CRect Screen);
	void RenderLink(CDC &MemDC, GPOINT Start, GPOINT End);
	void RenderLink(CDC &MemDC, FPoint Start, FPoint End);
	void RenderRuler(CDC &MemDC, int XStart, int YStart, int Width, int Height,  int NMarks);
	void RenderLandMarks(CDC &MemDC, NODE &Node);
	void RenderSetupBorder(CDC &MemDC);
	void RenderNode(CDC &MemDC, int NodeIndex, BOOL StandardPens = true);
	void RenderHallwaySymbol2(CDC &MemDC, short Direction, GPOINT StartingPosition);
	void RenderHallwaySymbol(CDC &MemDC, NODE &Node);


	AIDisplayGraph();
	virtual ~AIDisplayGraph();

};

#endif // !defined(AFX_AIDISPLAYGRAPH_H__88FA6D45_865D_477E_81DC_ADFD4B9CEC0E__INCLUDED_)
