#ifndef AIGRAPH_H
#define AIGRAPH_H

#include "AIGraphH.h"

/////////////////////////////////////////////////////////////////////////
// Header for of the graph used for robot navigation
// Written in C not C+
/////////////////////////////////////////////////////////////////////////

#define SIMULATOR
//#define Embedded

// to say weather or not to get absolute position when using the simulator
//#define CHEATPOSITION



// For C+ access
extern "C" 
{
//private
	// initializes a node to initial state.
	void GInitNode(NODE *Node);

	// get a new node
	unsigned short GGetNewNode(void);
	void GDeleteNode(NODE *NodePtr);

	// helper function for linking nodes
	void GLinkNodes(NODE *oldNode, NODE *newNode, char TDirection);

// public

	// intialize the graph
	void GInitialize(void);

	// add a landmark node
	BOOL GAddLandmarkNode(char TDirection, char LDirection, LANDMARK Landmark, short RoC, short Displacement);
	// add a special node
	BOOL GAddSpecialNode(SPECIAL SpecialType, char Direction);
	// note that the decision node is automatically linked to other nodes interally.
	// the the add may just append the information if a decision node already exists at the position
	BOOL GAddDecisionNode(char TDirection, short Possibilities[4], short Location, BOOL isWallDecisionNode);
	// simular to GAddDecisionNode, except it checks if the decision node, is the same
	// as the closed loop node;
	BOOL GIsLoopClosed(char TDirection, short Possibilities[4], short Location);
	// function which closes the loop
	void GCloseLoop(char TDirection, short Location);
	// checks if the robot returned to where is started the current loop, only applicable
	// on not the first loop
	BOOL GIsDoneBigLoop(NODE *NodePtr);

	// when the second loop is closed, it is required to clone the connecting decision node,
	// this function does it
	NODE* GCloneDecisionNode(NODE *TobeCloned, char OffsetDiretion, short Offset, BOOL PremptStack, BOOL *isFourPointsJ);

	void GSetCloseLoopMark(unsigned short In);
	short GGetLastCLOffset(void);

	

	NODE *GGetCurrNode(void); // returns the current node
	NODE *GGetFirstNode(void); // returns the first node in the heap
	BOOL GSetCurrNode(unsigned short Node); // sets the current node
	BOOL GisNodeValid(unsigned short Node); // is the input node valid?
	NODE *GGetNode(unsigned short Node); // gets the node with the input ID
// private
	// appends an unknown node to a decision node when required, this function is internal (private)
	BOOL GAddUnknownNode(char Direction, NODE *DecisionNode);

	void GAddPossibilities(NODE *tNodePtr,short Possibilities[4]); // used in the clone node routine, to still
	// input unknown area information


// public

	// File saving functions
	void GSetupEnum(void); // set up the enum
	void GRollBackEnum(void); // Roll back the enum if a timeout occurs up the enum
	BOOL GEnumGraph(char *ptr); // process the enum
	void GEnumAppend(char *ptr, short Input); // copies a short into a char string
	void GEnumStatus(char *ptr); // gets the four current state shorts.
	void GEnumStatus4(short Status[4]);  // same as above

	// file open function
	void GEnumAppendR(char *ptr, short *Input); // copies a short from a char string
	void GEnumAppendRU(char *ptr, unsigned short *Input); // copies a short from a char string
	void GSetupLoad(void); // sets up a graph load
	void GLoadGraph(char *ptr); // loads up a graph
	void GLoadStatus(char *ptr); // loads the four status shorts
	void GLoadGraphAscii(); // loads a graph from the LUT

	// send over current node
	unsigned short GSendCurrNode(void);
}

#endif