#ifndef AIGraphH_H
#define AIGraphH_H

// type definitions for the AIGraph and others

#define MAXNODE 1000// the maximum amount of nodes.

struct GPOINT
{
	short x;
	short y;
};

enum SPECIAL
{
	SPCNone,
	StartingPoint,
	Hazard,
	AtWallDecision
};

enum NODETYPE
{
	Empty,
	Landmark,
	Decision,	
	Unknown,
	Special,
	NA
};

struct NODE // 25 bytes a node // 28 bytes archive
{
	GPOINT Location; // location of the node
	unsigned short Index; // the index of the nodes (somewhat linked list)

	// if the distance has increased the value is positive, if it has decreased it is negative
	// 0 if not valid
	short LandMarkN;
	short LandMarkE;
	short LandMarkS;
	short LandMarkW;
	
	NODETYPE NodeType;
	BOOL hasCloseLoopMarker; // obsolete
	// if it is a decision node, the links specify valid paths that could be traveled
	unsigned short LinkN;
	unsigned short LinkE;
	unsigned short LinkS;
	unsigned short LinkW;

	SPECIAL Special; // obsolete
};

typedef NODE *NodePtr;

// for adding landmarks
enum LANDMARK
{
	LDMNone,
	LostDetection,
	GainDetection,
	RateofChange	
};

#define North 0x01
#define East 0x02
#define South 0x04
#define West 0x08

// for the sonar, don't want to use as enum, because it is going into a short
#define SNRHallway 0
#define SNRWall 1
#define SNRUnknown 2
#define SNRConnection 0 // same as a hallway

#define UNKNOWNDISTANCECONSTANT 60 // place a unknown node 60 cm away from the decision node
// more for graphical reasons then anything else

// defines some Roc Constants
#define RoCLostDetection 1000
#define RoCGainDetection -1000
#define RoCNone 0

// to send a directive
struct XPMessageStruct
{
	BOOL MappingMode;
	BOOL NavigationMode;
	char Direction;
	char OffsetDirection;
	BOOL LeftSideMapping;
	BOOL RightSideMapping;
	unsigned short DecisionNode;
};

// for sending maps across
enum STREAMMODE
{
    Off,
	Starting,
	Streaming,
	Ending,
	ReceivingStream
};

#endif