// SIRSensor.h: interface for the SIRSensor class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SIRSENSOR_H__2CFACD56_9A2D_4A32_BC07_E3A98BD053E3__INCLUDED_)
#define AFX_SIRSENSOR_H__2CFACD56_9A2D_4A32_BC07_E3A98BD053E3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ULinearAlgebra.h"
#include "SQuadTree.h"

#define MAXIRSENSOR 8

#define NODETECTION -1

#define SENSORSCALE (float)0.03

#define GDIBEAMANGLE 5 // 5 degree beam angle just for looks.

#define RED 1

// for detection distance
#define NODETECTIOND 255

#define RIGHTIR 1
#define FRONTIR 0
#define RFOWARDIR 2
#define LEFTIR 4
#define LEFTFOWARD 3
#define RIGHTREAR 5
#define LEFTREAR 6


class SIRSensor  
{
public:

    
    struct IRSENSORTYPE
    {
        FPoint DisplayPoint;   
        float BeamAngle; // for rendering, and detection
        BOOL Valid;
        long MaxRange;
        long MinRange;
        // rendering stuff
        unsigned short DetectionDistance;
        FPoint DetectionPoint;            
    };

    struct MODELINFO
    {     
        #ifdef USEFLOAT
            float x,y; // position        
            float CurrAngle; // Current Angle
        #else
            double x,y; // position        
            double CurrAngle; // Current Angle
        #endif  
        FPoint Center;      
    };

    // called on an update to see if any IR detections happened
    void FindDetection();

            // noise simulator
	void RandomizeIR(unsigned short &IRDistance);

    // robot API
	unsigned char GetFrontIR();
	unsigned char GetRightIR();
	unsigned char GetRFowardIR();
	unsigned char GetLFowardIR();
	unsigned char GetLeftIR();
	unsigned char GetRRearIR();
	unsigned char GetLRearIR();

    

    // no ideality stuff
	void SetIRNonIdeality(int NonIdeality);
	int NonIdealityFactor;
	
	
    // when the IRs are initially loaded they need to moved around the model center
	void AdjustforCenter(float Left, float Top);
    
    // the usual... rendering
	void GDIRender(CDC &MemDC, FRect Quad, CRect Screen, float SRScale, FPoint RenderModelCenter);
    
    // directX rendering
    void DirectXRender(VERTEX* &pVertex, FPoint RenderModelCenter, int &VertexCount);

    // translates the position of the sensors and places them in
    // the global TransformedIRSensors structure
	void TranslateSensors();
    void TranslateSensors(FPoint RenderModelCenter); // rendering version

    // pointer to quadtree
    SQuadTree *MapPtr;

    // linear algebra math library
    ULinearAlgebra LAUtils;

    MODELINFO ModelInfo;

    void UpdateModel(SIRSensor::MODELINFO ModelInfo);

    IRSENSORTYPE TransformedIRSensorsR[MAXIRSENSOR]; // render version
    IRSENSORTYPE TransformedIRSensors[MAXIRSENSOR]; // simulation version
    IRSENSORTYPE IRSensors[MAXIRSENSOR];

    // assorted pens
    CPen ColorPens[5];
    COLORREF Colors[5];   


    // load a sensor when the model is being loaded
	void LoadIRSensor(CPoint DisplayPoint, long MinRange, long MaxRange, long BeamAngle, long ID);

	SIRSensor();
	virtual ~SIRSensor();

};

#endif // !defined(AFX_SIRSENSOR_H__2CFACD56_9A2D_4A32_BC07_E3A98BD053E3__INCLUDED_)
