#if !defined(AFX_SSIMCONTROL_H__B5583BD5_6984_4F34_BF32_2CC81CDAD6F1__INCLUDED_)
#define AFX_SSIMCONTROL_H__B5583BD5_6984_4F34_BF32_2CC81CDAD6F1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// SSimControl.h : header file
//

#include "Resource.h"
#include "MessageMap.h"
#define MAXSIMSPEED 1000
#define MINSIMSPEED 10
#define MINRENDERSPEED 10
#define MAXRENDERSPEED 100
#define DEFAULTSIM 50
#define DEFAULTRENDER 35
#define SLIDERRANGE 1000

#define DEFAULTSPEEDOFSOUND (float)343/2
#define MINSPEEDOFSOUND 1
#define MAXSPEEDOFSOUND 1000

#define DEFAULTSONARSTREAMANGLE (float)30
#define MINSTREAMANGLE 0
#define MAXSTREAMANGLE 360

#define DEFAULTSONARBEAMANGLE (float)15
#define MINSONARBEAMANGLE 1
#define MAXSONARBEAMANGLE 360

#define DEFAULTNPASTBEAMS 12
#define MINNPASTBEAMS 1
#define MAXNPASTBEAMS 100

#define DEFAULTMAXSONARDISTANCE 1000 // 10 meters
#define MINMAXSONARDISTANCE 1
#define MAXMAXSONARDISTANCE 50000

#define DEFAULTIRNONIDEALITY 0
#define MINIRNONIDEALITY 0
#define MAXIRNONIDEALITY 5

#define DEFAULTSIMMULTIPLIER 1.0f
#define MINSIMMULTIPLIER 0.1f
#define MAXSIMMULTIPLIER 20.0f

/////////////////////////////////////////////////////////////////////////////
// SSimControl dialog

class SSimControl : public CDialog
{
// Construction
public:
    
    struct SIMCONTROLMESSAGE
    {
        // Simulation/Rendering Speed
        int ActualSimSpeed;
        int ActualRenderSpeed;
		float ActualSimMultiplier;

        // Rendering Options
        BOOL RealRenderingScale;
        BOOL FollowModel;
        BOOL ExtraSonarFlipping;

        // Sonar Control
        BOOL RenderPastSonarBeams;
        BOOL RenderPastSonarCollisions;
        int NumberofPastSonarCollisions;
        float SonarSpeedofSound;
        float SonarStreamAngle;
        float SonarBeamAngle;
        float SonarMaximumDistance;
		

        //
        int IRNonIdeality;
    };

	void SendUpdateMessage();
	int ActualSimSpeed;
	int ActualRenderSpeed;
	void SetSliderDefaults();
	int RenderTickstoInt(int Position);
	int RenderInttoTicks(int number);
    int SimulationTickstoInt(int Position);
	int SimulationInttoTicks(int number);
	BOOL Create();
	SSimControl(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(SSimControl)
	enum { IDD = IDD_SIMCONTROL };
	CSpinButtonCtrl	m_IRSpin;
	CSliderCtrl	m_RenderSpeedSldr;
	CSliderCtrl	m_SimulationSpeedSldr;
	int		m_RenderSpeed;
	int		m_SimulationSpeed;
	BOOL	m_RealSensorScale;
	float	m_SpeedOfSound;
	float	m_SonarStreamAngle;
	float	m_SonarBeamAngle;
	int		m_NSonarPastBeams;
	BOOL	m_RSonarPastBeams;
	BOOL	m_RSonarPastCollisions;
	BOOL	m_FollowModel;
	float	m_SonarMaxDistance;
	BOOL	m_ExtraFlipping;
	int		m_IRNonIdeality;
	float	m_SimMultiplier;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(SSimControl)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

    public:
	    LRESULT OnSpeedUpSim(WPARAM,LPARAM);
	    LRESULT OnSlowDownSim(WPARAM,LPARAM);
	    float ActualSimMultiplier;
	    int ActualIRNonIdeality;
	    float ActualMaximumSonarDistance;
	    int ActualNRenderPastBeams;
	    float ActualBeamAngle;
	    float ActualStreamAngle;
	    float ActualSpeedofSound;
    
    CWnd* m_pParent; // used for modeless operations
	int m_nID;

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(SSimControl)
	afx_msg void OnHide();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	virtual BOOL OnInitDialog();
	afx_msg void OnKillfocusSimulationspeed();
	afx_msg void OnKillfocusRenderspeed();
	afx_msg void OnDefault();
	afx_msg void OnRsensors();
	afx_msg void OnKillfocusSpeedofsound();
	afx_msg void OnKillfocusSonarstreamangle();
	afx_msg void OnKillfocusSonarbeamangle();
	afx_msg void OnRsonarpastcollisions();
	afx_msg void OnRsonarpastbeams();
	afx_msg void OnKillfocusNSonarPastBeams();
	afx_msg void OnFollowmodel();
	afx_msg void OnExtraflipping();
	afx_msg void OnKillfocusSonarmaxdistance();
	afx_msg void OnDeltaposSpinir(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnKillfocusSimmultiplier();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SSIMCONTROL_H__B5583BD5_6984_4F34_BF32_2CC81CDAD6F1__INCLUDED_)
