// XPControl.cpp : implementation file
//

#include "stdafx.h"
#include "Simulator.h"
#include "XPControl.h"
#include "MessageMap.h"
#include "AIGraphH.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// XPControl dialog


XPControl::XPControl(CWnd* pParent /*=NULL*/)
	: CDialog(XPControl::IDD, pParent)
{
	//{{AFX_DATA_INIT(XPControl)
	m_LeftSide = FALSE;
	m_RightSide = TRUE;
	m_Map = FALSE;
	m_Nav = TRUE;
	//}}AFX_DATA_INIT

   m_pParent = pParent;  // used to enable the modeless dialog, don't ask!
   m_nID = XPControl::IDD;   

   Once = TRUE;
}

// Used for Modeless operation
BOOL XPControl::Create()
{
    return CDialog::Create(IDD, m_pParent);
}


void XPControl::DoDataExchange(CDataExchange* pDX)
{
	
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(XPControl)
	DDX_Control(pDX, IDC_DIRECTION2, m_Direction2);
	DDX_Control(pDX, IDC_DIRECTION, m_Direction);
	DDX_Check(pDX, IDC_LEFTSIDE, m_LeftSide);
	DDX_Check(pDX, IDC_RIGHTSIDE, m_RightSide);
	DDX_Check(pDX, IDC_MAP, m_Map);
	DDX_Check(pDX, IDC_NAV, m_Nav);
	//}}AFX_DATA_MAP
	if (Once)
	{
		Once = FALSE;
		m_Direction.SetCurSel(0);
		m_Direction2.SetCurSel(0);
	}

}


BEGIN_MESSAGE_MAP(XPControl, CDialog)
	//{{AFX_MSG_MAP(XPControl)
	ON_BN_CLICKED(IDC_HIDE, OnHide)
	ON_BN_CLICKED(IDC_ORDER, OnOrder)
	ON_BN_CLICKED(IDC_NAV, OnNav)
	ON_BN_CLICKED(IDC_MAP, OnMap)
	ON_BN_CLICKED(IDC_RIGHTSIDE, OnRightside)
	ON_BN_CLICKED(IDC_LEFTSIDE, OnLeftside)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// XPControl message handlers

void XPControl::OnHide() 
{
	  ShowWindow(SW_HIDE);
    // need to deactivate window so the parent could get the focus
    EnableWindow(false);
    ::SendMessage(m_pParent->m_hWnd,WM_USER_SET_FOCUS,0,0);
	
}

BOOL XPControl::PreTranslateMessage(MSG* pMsg) 
{
	

     // disable the escape key
    BOOL bHandleNow = FALSE;

    switch (pMsg->message)
    {
    case WM_KEYDOWN:
        switch (pMsg->wParam)
        {
        case VK_UP:
        case VK_DOWN:
        case VK_LEFT:
        case VK_DELETE:
        case 'w':
            OnHide();
        case 'W':            
            OnHide();
        // disable the enter key
        case 13:
            SetFocus();
            return true;
        }
        if (bHandleNow)
            OnKeyDown(pMsg->wParam, LOWORD(pMsg 
                ->lParam), HIWORD(pMsg->lParam));
        break;
    }
	
	return CDialog::PreTranslateMessage(pMsg);
}

void XPControl::OnOrder() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	XPMessageStruct Message;

	if (m_RightSide)
	{
		Message.LeftSideMapping = FALSE;
		Message.RightSideMapping = TRUE;
	}
	else
	{
		Message.LeftSideMapping = TRUE;
		Message.RightSideMapping = FALSE;
	}
	

	if (m_Nav)
	{
		Message.NavigationMode = TRUE;
		Message.MappingMode = FALSE;
	}
	else
	{
		Message.NavigationMode = FALSE;
		Message.MappingMode = TRUE;
	}

	int Direction = m_Direction.GetCurSel();

	/*if (Direction == 0)
		Message.Direction = North;
	else if (Direction == 1)
		Message.Direction = East;
	else if (Direction == 2)
		Message.Direction = South;
	else if (Direction == 3)
		Message.Direction = West;*/
	Message.Direction = Direction+1;

	Direction = m_Direction2.GetCurSel();

	if (Direction == 0)
		Message.OffsetDirection = North;
	else if (Direction == 1)
		Message.OffsetDirection = East;
	else if (Direction == 2)
		Message.OffsetDirection = South;
	else if (Direction == 3)
		Message.OffsetDirection = West;

	::SendMessage(m_pParent->m_hWnd,WM_XPOPTIONS,(WPARAM )(&Message),0);

	OnHide();	
}

void XPControl::OnNav() 
{
	m_Map = FALSE;
	m_Nav = TRUE;
	UpdateData(false);
	
}

void XPControl::OnMap() 
{
	m_Nav = FALSE;
	m_Map = TRUE;
	UpdateData(false);
	
}

void XPControl::OnRightside() 
{
	m_LeftSide = FALSE;
	m_RightSide = TRUE;
	UpdateData(false);
	
}

void XPControl::OnLeftside() 
{
	m_RightSide = FALSE;
	m_LeftSide = TRUE;
	UpdateData(false);
	
}
