%this is from An Introduction to the Kalman Filter, Greg Welch and Gary Bishop
% rkalman_intro.pdf

% this is a demo of showing the kalman filter trying to denoise a single noisy constant value

% the interesting this is to show how changing the noise model, R and Q changes the convergence and how smooth the results are
% to make it more interesting I changed the value of x half way just to show the convergence rate

clear all;

num = 100;
var = .05;
val = 1;

m(1:50) =  randn(1,50)*var+val;
m(51:100) =  randn(1,50)*var+2;


xr(1) = 1;
pr(1) = .3;
A = 1;
H = 1;
R = .5;
Q = 0.01;
for ix = 2:num
    xnext = A*xr(ix-1);
    pknext = A*pr(ix-1) + Q ; % note if q is 0 then the thing will try to converge into a single value;
    Kk = pknext*H'*((H*pknext*H'+R)^(-1));
    x = xnext + Kk*(m(ix)-H*xnext);
    pr(ix) = (1-Kk*H)*pknext;
    xr(ix) = x;
    Kr(ix) = Kk;
end    
end

hold on;
plot(m,'r.');
plot(xr,'bo');
plot(pr,'g');
plot(Kr,'k');
hold off;

