// AIPathFollow.cpp: implementation of the AIPathFollow class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Simulator.h"
#include "AIPathFollow.h"
#include "AIPath.h"
#include "ChildView.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern AIPath theAIPath;
extern CChildView *GlobalPtr;
AIPathFollow theAI;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

AIPathFollow::AIPathFollow()
{
	FPoint temp;
	theAction = Decide;
	int newIndex = 0;
	// initialize AIPath;
	PathPlanner.EnumPathStart(); // start the enum

	while (PathPlanner.EnumPath(temp))
	{
		theAIPath.Links[newIndex] = temp;
		newIndex++;
	}

	theAIPath.NumofLinks = newIndex;
	theAIPath.CurrentLink = 0;




}

AIPathFollow::~AIPathFollow()
{

}

void AIPathFollow::RunAI()
{
	if (MVIsBlocking())
    {
        // do nothing
    }
	else if (theAction == Decide)
	{

		theAIPath.SetCurrentPoint(GlobalPtr->GlobalGetPosition(),GlobalPtr->GlobalGetAngle());

		float dAngle = theAIPath.GetNewDelta();

		float K = 1;

		float KA = (float)(dAngle*K/12.5);

		TurnTicks = (int)(KA);

		FowardTicks = 10;

		if (TurnTicks > 8)
		{
			FowardTicks = 10 + 8 - TurnTicks;
			TurnTicks = 8;
			FowardTicks = 0;
		}
		if (TurnTicks < -8)
		{
			TurnTicks = -8;
			FowardTicks = 10 + 8 + TurnTicks;
			FowardTicks = 0;
		}

		if (FowardTicks < 0)
			FowardTicks = 0;
		
	
		theAction = Foward;

		MVTurn(-TurnTicks);

	}
	else if (theAction == Foward)
	{
		MVGoFowardT(7,FowardTicks); // fo foward 10*1.2 cm at a speed of 7
		theAction = Decide;
	}

}
