// AIPathPlanner.h: interface for the AIPathPlanner class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_AIPATHPLANNER_H__81093975_DBDE_41FC_9D61_219E15B40C25__INCLUDED_)
#define AFX_AIPATHPLANNER_H__81093975_DBDE_41FC_9D61_219E15B40C25__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ULinearAlgebra.h"
#include "AIPath.h"	// Added by ClassView

//========================================================================
// AIPathPlanner uses a quadtree segmentation algorithm, to classify areas as
// full, empty or mixed and then uses an algorithm to search that graph for
// the shortest path
//
// Inputs
// SetQuadtreeDimen
//
// Things to do to make this class work
//
// call to add objects to the list, all objects are circles
// void EnumAddObjects(FPoint Point, float Radius);
//
// call to tell it what the start points and end points are
// void SetStartGoalPoints(FPoint Start, FPoint Goal);
// 
// Call to set teh quadtrees dimensions
// void SetQuadtreeDimensions(float width, float height);
//
// Adjust to change quadtree size
// #define FIELDX 8 // number of vertical quadrants
// #define DELTAX 40.0f // size of vertical quadrants
// #define FIELDY 8 // number of horizontal quadrants
// #define DELTAY 27.5f // size of horizontal quadrants
//
// Call to generate a new quadtree
// void GenerateQuadTree();
//
// Call to generate the new path
// void GeneratePath();
// 
// Call to start the path enumeration
// void EnumPathStart();
// Call to extract points of the path
// bool EnumPath(FPoint &point);

	
/*#define FIELDX 8 // 274/8 34.25cm
#define DELTAX 34.25f
#define FIELDY 8 // 152/8 = 19cm
#define DELTAY 19.0f*/

// simulator only
#define FIELDX 8 // 320/8 34.25cm
#define DELTAX 40.0f
#define FIELDY 8 // 220/8 = 19cm
#define DELTAY 27.5f


/*#define FIELDX 2 // 274/8 34.25cm
#define DELTAX 137.0f
#define FIELDY 2 // 152/8 = 19cm
#define DELTAY 76.0f*/

/*#define FIELDX 16 // 274/8 34.25cm
#define DELTAX 17.125f
#define FIELDY 16 // 152/8 = 19cm
#define DELTAY 8.5f*/

#define MAXSEARCHSTACK 1000

class AIPathPlanner  
{


private:
	void InitializeSearch();


	// structure to store the list of objects
	typedef struct ObjectList1;

	struct ObjectList1
	{
		FPoint CenterPoint;
		float Radius;
		ObjectList1 *Next;
	};



	ObjectList1 *ObjectList; // the object list

	typedef struct QuadTree;

	typedef struct QuadTreeList;

	struct QuadTreeList
	{
		QuadTree *Current;
		QuadTreeList *Next;
	};

	typedef struct FRect
	{
		float Top;
		float Bottom;
		float Left;
		float Right;
	};

	typedef enum QuadStatus1 {Full, Empty, Mixed};
	typedef enum QuadStatus2 {Initial, Goal, Normal};
	typedef enum QuadStatus3 {OnPath, NotonPath};


	// the actual quadtree
	struct QuadTree
	{

		// variables for the quadtree
		FRect Rect;

		QuadTreeList *QuadTop;
		QuadTreeList *QuadBottom;
		QuadTreeList *QuadLeft;
		QuadTreeList *QuadRight;

		QuadStatus1 QuadStatus;

		QuadStatus2 KeyPoint; 

		QuadStatus3 PathInfo;

		QuadTree *Next; // for the rendering routine

		// variables for search
		float CurrentDistance; // the distance currently traversed by the path
		QuadTree *PathPtr; // for searching routine
		// speeds up searching if precomputed
		FPoint CenterPoint;
		// the A* g(x) and h(x) precomputed
		float hx;
		float IncDistance; // the distance of the quadrant
		
	
	};

	QuadTree *theQuadTree; // pointer that is used for rendering or traversals

	// the height and width of the player field
	float Height;
	float Width;

	// Math utility functions
	inline float GetDistance(FPoint one, FPoint two)
	{
		return (float)sqrt((one.x-two.x)*(one.x-two.x) + (one.y-two.y)*(one.y-two.y));
	}

	inline int Round(float In)
	{
		if (In - (int)In > 0.5)
			return (int)In + 1;
		else
			return (int)In;
	}

	inline bool PointInRect(FPoint Point, FRect Rect)
	{		
		if ((Point.y <= Rect.Left) && (Point.y >= Rect.Right))
			if ((Point.x <= Rect.Top) && (Point.x >= Rect.Bottom))
				return true;
		
		return false;
	}

	// create a line from points in the form of ax+by+c = 0
	LineStruct PointstoLine(FPoint start, FPoint end);

	// checks if a circle (object) intersects with a rectangle (the quadrant)
	// this is used after doing a circle intersection test
	bool DoesIntersect(FRect Rect, FPoint CCenter, float CRadius);
	// helper function for function above.
	bool DoesIntersect(LineStruct Line, FPoint CCenter, float Radius);

	// for the construction of the quadtree use a pointer table
	QuadTree *PointerTable[FIELDX][FIELDY];

	// Recursive call to generate the quad tree
	void GenerateQuadTree(ObjectList1 *Objects, FRect Rect);

	// helper function for above, does actual creation
	QuadTree* CreateQuad(FRect Rect);

	FPoint GoalPoint;
	FPoint InitialPoint;

	QuadTree *GoalQuad;
	QuadTree *InitialQuad;

	QuadTree *SearchStack[MAXSEARCHSTACK];
	int SearchStackIndex;

	inline void AddtoStack(QuadTree *In)
	{
		SearchStack[SearchStackIndex] = In;
		SearchStackIndex++;
	}

	inline QuadTree* PopStack()
	{
		if (SearchStackIndex == 0)
			return NULL;

		SearchStackIndex--;
		
		return SearchStack[SearchStackIndex];
	}

	inline bool StackisEmpty()
	{
		if (SearchStackIndex == 0)
			return true;

		return false;
	}

	inline SearchPath(QuadTreeList *Traverse,QuadTree *CurrentQuad, float CurrentDistance)
	{
		while (Traverse != NULL)
		{
			// check if we are going in a shorter direction
			// otherwise we are backtracking
			// must be empty
			if (Traverse->Current->QuadStatus == Empty)
			{
				if (Traverse->Current->CurrentDistance > CurrentDistance + Traverse->Current->IncDistance)
				{
					// increment its distance
					Traverse->Current->CurrentDistance = CurrentDistance
						+ Traverse->Current->IncDistance;																	

					// link it to the path
					Traverse->Current->PathPtr = CurrentQuad;

					AddtoStack(Traverse->Current);				
				}
			}
			Traverse = Traverse->Next;
		}
	}

    typedef struct PathPoints1;

	struct PathPoints1
	{
		FPoint Points;
		PathPoints1 *Next;
	};

	PathPoints1 *PathPoints;
	PathPoints1 *TraversePath;

	// internal function to that generates the path
	void GeneratePathPoints(QuadTree *PathPtr);

	// destructer
	void Destruct();



public:
	void EnumPathStart();
	bool EnumPath(FPoint &point);

	// call this to generate the path
	void GeneratePath();

	void SetStartGoalPoints(FPoint Start, FPoint Goal);

	// sets dimensions
	void SetQuadtreeDimensions(float width, float height);

	// adds an object
	void EnumAddObjects(FPoint Point, float Radius); // adds an objects to the list

		// function called on the outside to generate the quadtree calls reccursive call
	void GenerateQuadTree();


	// directXRendering function
	void DirectXRender(VERTEX *&pVertex, FPoint RenderModelCenter, int &VertexCount);






	AIPathPlanner();
	virtual ~AIPathPlanner();



};

#endif // !defined(AFX_AIPATHPLANNER_H__81093975_DBDE_41FC_9D61_219E15B40C25__INCLUDED_)
