// SDirectXTread.h: interface for the SDirectXTread class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SDIRECTXTREAD_H__89094F34_9E1F_4237_8B28_C9D6E573508D__INCLUDED_)
#define AFX_SDIRECTXTREAD_H__89094F34_9E1F_4237_8B28_C9D6E573508D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ULinearAlgebra.h"


class SDirectXTread  
{
public:

	
/************************************************************************
* Here is how the treads work.  It is segmeneted into 4 zones, the two
* linear zones (the top and bottom) and the two radial zones the front and back
*
* The front and back are easy to calculate by using distance.  The radial zones
* are based on angle.  The distance starts at 0 and goes to length.  The angle goes from 0 
* degrees and goes to 180.
*
* In every cycle only the seed point is moved according to the distance.  All the other points
* Are generated based on the seed
*
* Note in turns of how the rest of the treads are generated from the seed, they are generated from
* a counterclockwise traversal around the tread.  In this, when entering raidal angles, the starting
* angle is 0, and the entering distance is always 0.
*
*************************************************************************/

	enum { VERTEX_TYPE = D3DFVF_XYZ|D3DFVF_DIFFUSE | D3DFVF_TEX1};

    enum SEEDLOCATION
    {
        Top, // top of the tread
        Front, // front of the tread (in cicle part)
        Bottom, // bottom of the tread
        Back // back of the tread (in cicle part)
    };

	struct TREAD
    {
        SEEDLOCATION SeedLocation;
		float SeedDistance;
		float SeedAngle;
    };

	TREAD Tread;

	TREAD MoveLink(TREAD TreadIn, float Distance);

	void Update(float Distance, D3DVECTOR CenterPoint, float Angle);
	void Render();

	struct TREADINFO
	{
		float Length; // the length of the two lines segments of the tread
		float Width; // the width of the tread
		float Radius; // the raidius of the two wheels
		int NumofTreads; // the number of treads
		float LinkLength; // calculate once
		float Angle; // angle of tread, only used for rendering
		D3DVECTOR CenterPoint; // the centerpoint of the tread, only used for rendering
	} TreadInfo;

	void Create(TREADINFO tTreadInfo, LPDIRECT3DDEVICE8 tm_pd3dDevice);

	void FormLink(VERTEX* pVertex, TREAD TreadIn, BOOL Alt);

	LPDIRECT3DVERTEXBUFFER8 g_pTreadVB;  // the vertex buffer that holds the treads information

	LPDIRECT3DDEVICE8 m_pd3dDevice; // pointer to the directX device

	SDirectXTread();
	virtual ~SDirectXTread();

};

#endif // !defined(AFX_SDIRECTXTREAD_H__89094F34_9E1F_4237_8B28_C9D6E573508D__INCLUDED_)
