// SGDIRender.h: interface for the SGDIRender class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SGDIRENDER_H__B8756F4C_CC60_4A3A_88FB_B0F00BF3EDBF__INCLUDED_)
#define AFX_SGDIRENDER_H__B8756F4C_CC60_4A3A_88FB_B0F00BF3EDBF__INCLUDED_

#include "SQuadTree.h"	// Added by ClassView
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "GenericModel.h"
#include "ULinearAlgebra.h"	// Added by ClassView

#define ZOOMPIXELPERCENT .01 // a one pixel movement is a 5% zoom in.

#define XMax 1280000 // should be 12800 for the quadtree
#define YMax 1280000
#define XMin 0
#define YMin 0
#define MINZOOM 10

/************************************************************************
* class SGDIRender  
*
* PURPOSE
* The class handles all of the GDI rendering functionality.  Its only purpose is to draw.  
* it does not server any logic purpose
*************************************************************************/

class SGDIRender  
{
public:
	ULinearAlgebra LAUtils;
	void RCSetModelCoord(FPoint Point);

	float SensorRenderingScale;
	CPoint RealToScreen(FPoint Coord);
	SQuadTree *MapPtr;
	void RCResetView();
	void RCZoom(CPoint Point);

    // SET RENDERING OPTIONS
    // set zoom ratio
	void RCZoom(float ratio);
    // toogle option to lock onto the model
    void RCSetFollowModel(BOOL ToFollow);
    // set the zoom in center point
	void RCSetZoomPoint(CPoint Point);

    struct RENDERCONTROL
    {
        CPoint ZoomPoint; // physical start point of zoom
        CPoint PrevZoomedPoint; // current point of zoom movement
        CPoint ZoomMousePos; //real start point of zoom point
        BOOL LockonModel; // should the model always be in the middle of the screen?
        FPoint ModelLockPoint; // if so this is where the model position is stored
    };

    RENDERCONTROL RenderControl;

    // a pointer to the model
	SGenericModel *ModelPtr;

    // called by window class.  Renders the simulation using GDI
	void Render(CDC &MemDC);

    // screen to real coordinates
	CPoint ScreentoReal(CPoint Coord);

    CRect RectDrawingArea; // Defines the area in the window that it could draw in.
    FRect RectCurrentView; // Defines the area current view.

	SGDIRender();
	virtual ~SGDIRender();

};

#endif // !defined(AFX_SGDIRENDER_H__B8756F4C_CC60_4A3A_88FB_B0F00BF3EDBF__INCLUDED_)
