// SShaftEncoders.h: interface for the SShaftEncoders class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SSHAFTENCODERS_H__9F26508B_4B4B_41DE_B7CB_DFB9024CEB95__INCLUDED_)
#define AFX_SSHAFTENCODERS_H__9F26508B_4B4B_41DE_B7CB_DFB9024CEB95__INCLUDED_

#include "ULinearAlgebra.h"	// Added by ClassView
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class SShaftEncoders  
{
public:	
	// since I could render 3D moving treads I need to know there displacement for each rendering
	// these functions and variables do the trick
	float RightShaftEncoder3D;
	float LeftShaftEncoder3D;
	float GetRightDelta();
	float GetLeftDelta();

    // ROBOT API software counter functions
	void SEResetTick3();
	void SEResetTick2();
	void SEResetTick1();
	short SEGetTick3();
	short SEGetTick2();
	short SEGetTick1();

    // two software tick counters for the API
	float TickCounter3;
	float TickCounter2;
	float TickCounter1;

	float TicksConst; // ratio of distance to ticks
    float RightShaftEncoder; // real distance without rounding
	float LeftShaftEncoder; // real distance without rounding
	float DistanceFromCenter; // the distance of the center of track to the middle of the model

    // external gets
	long SEGetRightTicks();
	long SEGetLeftTicks();

    // standard Math library
	ULinearAlgebra LAUtils;

    // Called when the model moves
	void IncrementDisplacement(float PrevAngle, float DAngle, float DX, float DY, BOOL Foward);
    void IncrementDisplacement(float &toIncrement, float PrevAngle, float DAngle, float DX, float DY, BOOL Left, BOOL Abs, BOOL Foward);
    //reset
	void SEReset(BOOL Complete);
	
	SShaftEncoders();
	virtual ~SShaftEncoders();

};

#endif // !defined(AFX_SSHAFTENCODERS_H__9F26508B_4B4B_41DE_B7CB_DFB9024CEB95__INCLUDED_)
