// AABB.cpp: implementation of the AABB class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "AABB.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

AABB::AABB()
{
	m_AMax.x = 0;
	m_AMax.y = 0;
	m_AMax.z = 0;
	m_AddIndex = 0;
	m_CurrMaxIndex = MAXADDVERTICES1;
	m_AddVertices = new Point3[MAXADDVERTICES1];


}

AABB::~AABB()
{
	//delete m_AddVertices;
}

//////////////////////////////////////////////////////////////////////
// void enumStartAddVertices()
//
// This function starts the adding of vertices that can be used to form the
// AABB information
//
//////////////////////////////////////////////////////////////////////
void AABB::enumAddVertices(Point3 Vertices)
{
	m_AddVertices[m_AddIndex] = Vertices;
	m_AddIndex++;
	if (m_AddIndex == m_CurrMaxIndex)
	{
		// k increase array size
		Point3 *tempo = new Point3[MAXADDVERTICES1 + m_CurrMaxIndex];
		memcpy(tempo,m_AddVertices,sizeof(Point3)*m_CurrMaxIndex);
		m_CurrMaxIndex = m_CurrMaxIndex + MAXADDVERTICES1;
		delete []m_AddVertices;
		m_AddVertices = tempo;
		ASSERT(m_AddIndex >= 0 && m_AddIndex < 10000);
	}
}

//////////////////////////////////////////////////////////////////////
// void enumStartAddVertices()
//
// This function starts the enumeration to add vertices
//
//////////////////////////////////////////////////////////////////////
void AABB::enumStartAddVertices()
{
	m_AddIndex = 0;
}

//////////////////////////////////////////////////////////////////////
// void FormAABB()
//
// This function starts the forming of the AABB by taking a look at all added
// vertices
//
// Algorithm
// simply look at every vertex and check if it is the minimum or maximum then add it
//////////////////////////////////////////////////////////////////////
void AABB::FormAABB()
{
	m_AMin.x = 9999.9;
	m_AMin.y = 9999.9;
	m_AMin.z = 9999.9;
	m_AMax.x = 0;
	m_AMax.y = 0;
	m_AMax.z = 0;
	for (int ix = 0; ix < m_AddIndex; ix++)
	{

		if (m_AddVertices[ix].x < m_AMin.x)
			m_AMin.x = m_AddVertices[ix].x;
		if (m_AddVertices[ix].y < m_AMin.y)
			m_AMin.y = m_AddVertices[ix].y;
		if (m_AddVertices[ix].z < m_AMin.z)
			m_AMin.z = m_AddVertices[ix].z;

		if (m_AddVertices[ix].x > m_AMax.x)
			m_AMax.x = m_AddVertices[ix].x;
		if (m_AddVertices[ix].y > m_AMax.y)
			m_AMax.y = m_AddVertices[ix].y;
		if (m_AddVertices[ix].z > m_AMax.z)
			m_AMax.z = m_AddVertices[ix].z;
	}

}
