// Box.h: interface for the Box class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BOX_H__78CB6BE3_999A_4764_8CBB_87649CFA1478__INCLUDED_)
#define AFX_BOX_H__78CB6BE3_999A_4764_8CBB_87649CFA1478__INCLUDED_

#include "stddef.h"	// Added by ClassView
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BaseObject.h"


class Box : public BaseObject  
{
public:
	bool RayIntersectObject(Point3 &Org, Point3 &Dir, Point3 &intersection);
	void GetLightMaps();
	
	bool RayIntersectObject(Point3 &Org, Point3 &Dir);
	
	bool RayOBBIntersect(Point3 Org, Point3 Dir, Point3 &Intersect);
	void DirectXFormSquare(TLNVERTEXSTRUCT *&pVertex, int &VertexCount, Point3 v1, Point3 v2, Point3 v3, Point3 v4, DWORD Color);
	void DirectXRender(TLNVERTEXSTRUCT *&pVertex, int &VertexCount, int *&pLightmap,int &LightMapCount);
	void SetParameters(double AngleX, double AngleY, double AngleZ, double HalfX, double HalfY, double HalfZ, Point3 Center, int TextureType);
	Box();
	virtual ~Box();

	// lightmap stuff
	int lightMapIndex[6];
	//IDirect3DTexture8* ppLightMap[6]; // create the lightmap textures


private:
	double m_AngleX;
	double m_AngleY;
	double m_AngleZ;
	double m_HalfX;
	double m_HalfY;
	double m_HalfZ;
	// the normailied vectors for the slab test
	Point3 Au;
	Point3 Av;
	Point3 Aw;
	Point3 m_Center;
	Point3 m_Vertices[8]; // the 8 vertices of the box;
};

#endif // !defined(AFX_BOX_H__78CB6BE3_999A_4764_8CBB_87649CFA1478__INCLUDED_)
