// ChildView.h : interface of the CChildView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHILDVIEW_H__8D92305C_66B7_4190_A3E0_D264EC3BE616__INCLUDED_)
#define AFX_CHILDVIEW_H__8D92305C_66B7_4190_A3E0_D264EC3BE616__INCLUDED_

#include "R3DWindow.h"	// Added by ClassView
#include "OctTree.h"	// Added by ClassView
#include "DynamicObject.h"
#include "DynamicObjectManager.h"
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CChildView window

class CChildView : public CWnd
{
// Construction
public:
	CChildView();

// Attributes
public:

    struct THREADINFO
    {
        BOOL EndSimThread;       
        CChildView *ParentPtr;       
        CWinThread *SimThreadPtr;
		double simTimeQuanta;
		int simsPerQuanta;
		int actualSimsperQuanta; //stats
    } simThreadInfo;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChildView)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	static UINT SimulatorThread(LPVOID lpInfo);
	OctTree TempGrid;
	CWnd* FramePtr;
	R3DWindow Renderer;
	virtual ~CChildView();

	DynamicObject *car1,*car2;

	// Generated message map functions
protected:
	//{{AFX_MSG(CChildView)
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSimStart();
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHILDVIEW_H__8D92305C_66B7_4190_A3E0_D264EC3BE616__INCLUDED_)
