// DynamicObject.h: interface for the DynamicObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DYNAMICOBJECT_H__650BA23D_308D_4BFB_8C80_4C976698BB26__INCLUDED_)
#define AFX_DYNAMICOBJECT_H__650BA23D_308D_4BFB_8C80_4C976698BB26__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BaseObject.h"
#include "Model.h"
#include "Matrix.h"

class DynamicObject : public BaseObject, public Model 
{
public:
	void SetMovement(Point3 translation, double rotation);
	void GetMovement(Point3 &translation, double &rotation);
	void SetMovement(double linearAccel, double angleAccel);
	void MoveObject(double deltaTime, bool moveBack);
	bool PointInTriangle(Point3 v0, Point3 v1, Point3 v2, Point3 norm);
	bool isEdgeCollision(DynamicObject &otherObject, double deltaTime, Point3 &intersectionPoint);
	bool isIntersectionQuick(DynamicObject &otherObject);
	bool isCollision(Point3 p1, Point3 p2, Point3 p3, Point3 p4, Point3 v1, Point3 v2, Point3 v3, Point3 v4,Point3 &intersectionPoint);
	void setSpeed(double deltaTime);
	int enumNumTriangle();
	bool generateMovesCoords(double deltaTime, bool forcePrevInput);
	bool enumGetTriangle(Point3 &v0, Point3 &v1, Point3 &v2);
	bool isCollision(DynamicObject &otherObject, double deltaTime, Point3 &intersection);
	double yAngle;
	double prevLinearAccel;
	float angularAccel;
	float linearAccel;
	void simulate(double deltaTime);
	void moveTo(Point3 newLocation);
	void DirectXRender(LPDIRECT3DDEVICE8 g_pd3dDevice);
	void init(LPDIRECT3DDEVICE8 g_pd3dDevice,char *fileName);

	int enumCurrIndex,enumCurrIndexO;

	Point3 currLocation;

	double phyAngularAccel;
	double phyLinearAccel;

	bool hasMoved;

	// move here so they don't init a million times in debug mode
	Point3 u0[300];
	Point3 u1[300];
	Point3 u2[300];

	Point3 *tPhysicsPoints;
	Point3 *tPrevPhysicsPoints;
	int numPhysicsPoints;

	Point3 prevTranslation;
	double prevRotation;
	Point3 forcedTranslation;
	double forcedRotation;

	DynamicObject();
	virtual ~DynamicObject();

	Model renderModel;

};

#endif // !defined(AFX_DYNAMICOBJECT_H__650BA23D_308D_4BFB_8C80_4C976698BB26__INCLUDED_)
