// DynamicObjectManager.cpp: implementation of the DynamicObjectManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "DynamicObjectManager.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

DynamicObjectManager theDOManager;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

DynamicObjectManager::DynamicObjectManager()
{
	
}

DynamicObjectManager::~DynamicObjectManager()
{
	currRenderIterator = DObjectList.begin();	
	endRenderIterator = DObjectList.end();	

	while (currRenderIterator != endRenderIterator)
	{
		delete (*currRenderIterator);
		currRenderIterator++;
	}

}

//=========================================================
// void addObject(DynamicObject *theObject)
//
// Add an object to the object manager
//
//=========================================================
void DynamicObjectManager::addObject(DynamicObject *theObject)
{
	DObjectList.push_back(theObject);
}

//=========================================================
// bool enumObjects(DynamicObject *&theObject)
//
// Basically use for rendering
//
//=========================================================
bool DynamicObjectManager::enumObjects(DynamicObject *&theObject)
{
	if (currRenderIterator != endRenderIterator)
	{
		theObject = *currRenderIterator;
		currRenderIterator++;
		return true;
	}
	else
		return false;

}

//=========================================================
// enumStart()
//
// Basically starts the enum for the above function
//
//=========================================================
void DynamicObjectManager::enumStart()
{
	currRenderIterator = DObjectList.begin();	
	endRenderIterator = DObjectList.end();	
}

//=========================================================
// void Interate(double deltaTime)
//
// Basically move all of the objects by deltaTime
//
// Algorithm
// 1) Go though the list seeing which objects are close enough to collide
//     together.
// 2a) If they are not going to collide simply move them
// 2b) If they are going to collide resolve the collision
//=========================================================
void DynamicObjectManager::Interate(double deltaTime)
{
	DObjectList1::iterator curr,curr1; 
	DObjectList1::iterator end; 

	curr = DObjectList.begin();
	end = DObjectList.end();
	// iterate through the object list

	int index1 = theProfiler.getTimeBlockIndex("Physics1");
	int index2 = theProfiler.getTimeBlockIndex("Physics2");
	int index3 = theProfiler.getTimeBlockIndex("Physics3");

	// set them all to haven't moved
	while (curr != end)	
	{
		(*curr )->hasMoved = false;
		curr++;
	}


	curr = DObjectList.begin();
	theR3DWindow.renderIntersection = false;


	while (curr != end)
	{
		// make sure we haven't moved yet
	//	if (!(*curr)->hasMoved)
	//	{
			curr1 = DObjectList.begin();
			// k now check this object against every other object
			bool collisionOccured = false;
			while (curr1 != end)
			{
				if (curr1 != curr)
				{			

					theProfiler.startTiming(index1);
					Sphere *one,*two;
					one = (*curr1)->GetBoundingSphere();
					two = (*curr)->GetBoundingSphere();

					Point3 oneL = (*curr1)->currLocation;
					Point3 twoL = (*curr)->currLocation;

					double distance = Point3::Hypot2(one->m_Center + oneL,two->m_Center + twoL);
					double maxMovement = 4;

					theProfiler.stopTiming(index1);
					if (distance < (one->m_Radius + two->m_Radius)*(one->m_Radius + two->m_Radius) + maxMovement)
					{
						theProfiler.startTiming(index2);
						// get the relivite acceleration and rotation here
						// now to do this we first get our own, and then figure out how the other
						// object rotation has the potential to add extra translation for our object
						double totalAccel = (*curr)->linearAccel;
						double totalRot = (*curr)->angularAccel;

						(*curr)->SetMovement(totalAccel,totalRot);
						(*curr1)->SetMovement(0,0);				
						(*curr)->generateMovesCoords(deltaTime,false);
						(*curr1)->generateMovesCoords(deltaTime,false);
						
					
						theProfiler.stopTiming(index2);
						theProfiler.startTiming(index3);
					//	if ((*curr)->isIntersectionQuick(*(*curr1)))
						Point3 Intersection;
						if ((*curr)->isCollision(*(*curr1),deltaTime,Intersection))					
						{
							// resolve collision here and if so figure out how to move them											
						//	Beep(100,100);
							theR3DWindow.collisionPoint = Intersection;
							theR3DWindow.renderIntersection = true;
							collisionOccured = true;
							(*curr)->hasMoved = true;
							(*curr1)->hasMoved = true; // don't want to move the other one
							theProfiler.stopTiming(index3);
						}
						else
						{
							theProfiler.stopTiming(index3);
							// now apply the same movement to the other object and see what happens
							Matrix rot,translation;
							// find out the translation
							Point3 prevTranslation;
							double prevRotation;
							theProfiler.startTiming(index2);

							// now reverse which vertex vs polygon check we are doing
							Point3 diff = (*curr1)->currLocation - (*curr)->currLocation ;
							MatrixTranslation(translation,diff.x,diff.y,diff.z);
							double angle = (*curr1)->angularAccel;
							double angle2 = (*curr1)->angularAccel*PI/180.0;
							MatrixRotationY(rot,(*curr1)->angularAccel*PI/180.0); 
							rot = translation*rot;
							Point3 currLoc = (*curr)->currLocation;
							Point3 currLoc1 = (*curr1)->currLocation;
							Point3 next = (*curr)->currLocation*rot;


							(*curr)->GetMovement(prevTranslation,prevRotation);
							prevTranslation = -prevTranslation;
							// add the extra translation due to rotation
							Point3 extra;
							extra.x =  next.x - (*curr1)->currLocation.x;
							extra.z = next.z - (*curr1)->currLocation.z;
							prevTranslation.x += extra.x;
							prevTranslation.z += extra.z;

							(*curr1)->SetMovement(prevTranslation,-prevRotation);							
							// this forces curr1 to move opposite as curr moved


							// k now find out the angles and the translation
						//	double totalAccel1 = Point3::Hypot(next,(*curr1)->currLocation);

						//	ASSERT(totalAccel1 == 0);
							
							// total accel is added to the forced displacement
							(*curr1)->SetMovement(totalAccel,totalRot);
							(*curr)->SetMovement(0,0);				
							(*curr1)->generateMovesCoords(0,true); // force it to use inputted movement
							(*curr)->generateMovesCoords(0,false);
							theProfiler.stopTiming(index2);
							theProfiler.startTiming(index3);
//
								if ((*curr1)->isCollision(*(*curr),deltaTime,Intersection))					
								{
									// resolve collision here and if so figure out how to move them											
								//	Beep(100,100);
									theR3DWindow.collisionPoint = Intersection;
									theR3DWindow.renderIntersection = true;
									collisionOccured = true;
									(*curr)->hasMoved = true;
									(*curr1)->hasMoved = true; // don't want to move the other one									
								}
					


							// get the translation of the other one and reverse it and that 
							// is the translation of this one
								theProfiler.stopTiming(index3);

						}
						
						
					}
				}
				curr1++;		
			}
			if (!collisionOccured)
			{
				if (!(*curr)->hasMoved)
					(*curr)->MoveObject(deltaTime,false);
				// have the object do its default movements
			}
	//	}
	/*	else
		{
			if ((*curr)->linearAccel != 0)
				int adf =34;
		}*/
	
		curr++;
	}

}
