// OctTree.cpp: implementation of the OctTree class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "OctTree.h"
#include "stddef.h"
#include "Profiler.h"
#include "VTManager.h"
#include "Plane.h"
#include "math.h"
#include "Box.h"
#include "LightMaps.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

OctTree::OctTree()
{
	m_XPartitions = 0;
	m_YPartitions = 0;
	m_ZPartitions = 0;

	m_Root = new OctNode;

	DebugPickFlag = 1;

	m_Root->Area.m_AMax.x = 100;
	m_Root->Area.m_AMax.y = 100;
	m_Root->Area.m_AMax.z = 100;

/*	for (int ix = 0; ix < m_XPartitions; ix++)
		m_Root->Area.m_AMax.x *= 2;

	for (ix = 0; ix < m_YPartitions; ix++)
		m_Root->Area.m_AMax.y *= 2;

	for (ix = 0; ix < m_ZPartitions; ix++)
		m_Root->Area.m_AMax.z *= 2;*/
	
	m_Root->Area.m_AMin.x = 0;
	m_Root->Area.m_AMin.y = 0;
	m_Root->Area.m_AMin.z = 0;

	theProfiler.EnterStartTime("Construct");

	Init();

	theLightMaps.octTreePtr = this;

		theProfiler.EnterEndTime("Construct");
	double hello = theProfiler.GetExecutionTime("Construct");
		double hello1 = theProfiler.GetExecutionTime("Init1");
			double hello2 = theProfiler.GetExecutionTime("Init2");

			char tempo[100];

			sprintf(tempo,"Prof1 %f6.3  PRof2 %f6.3 Prof3 %f6.3",hello,hello1,hello2);
		//	AfxMessageBox(tempo);

	DebugPickPointer = NULL;


}

OctTree::~OctTree()
{
	// go down as far as possible, then go up and delete and check to go down again
	// else go up and delete
	OctNodePtr Traverse = m_Root;
	OctNodePtr toDelete;
	bool Done = false;
	bool GoneDown;

	while (!Done)
	{
		GoneDown = false;
		for (int ix = 0; ix < 8; ix++)
		{
			if ( Traverse->Children[ix] != NULL)
			{
				Traverse = Traverse->Children[ix];
				GoneDown = true;
				break;
			}
		}
		if (!GoneDown)
		{
			if (Traverse->Parent == NULL)
			{
				// we are done
				Done = true;
				DeleteObjectList(Traverse);
				delete Traverse;
			}
			else
			{
				// go up and delete current
				toDelete = Traverse;
				Traverse = Traverse->Parent;
				for (int ix = 0; ix < 8; ix++)
				{
					if ( Traverse->Children[ix] == toDelete)
					{
						Traverse->Children[ix] = NULL;		
						break;
					}
				}
				DeleteObjectList(toDelete);
				delete toDelete;
			}
		}
	}
}


//////////////////////////////////////////////////////////////////////
// void Init()
//
// Init actually create the octtree and all of the nodes are empty but connected
//
// Algorithm
// 1) Create the tree don't worry about connecting the neighbours now
// 1a) Figure out how many splits each dimension needs
// 1b) Add root node into stack
// 1c) Extract from stack, split into the dimensions as required, add nodes into stack
// 1d) Stack is empty, now join neighbours
// 2) Join neighbours

//////////////////////////////////////////////////////////////////////
void OctTree::Init()
{

	theProfiler.EnterStartTime("Init1");


	ConstructOct tConstructOct,tNewConstructOct;

	tConstructOct.NodePtr = m_Root;

	// figure out how many splits are required do log 2 operations
/*	int tX = m_XPartitions;
	tConstructOct.XSplitsLeft = 0;
	while (tX > 1)
	{
		tConstructOct.XSplitsLeft++;
		tX = tX/2;
	}

	int tY = m_YPartitions;
	tConstructOct.YSplitsLeft = 0;
	while (tY > 1)
	{
		tConstructOct.YSplitsLeft++;
		tY = tY/2;
	}

	int tZ = m_ZPartitions;
	tConstructOct.ZSplitsLeft = 0;
	while (tZ > 1)
	{
		tConstructOct.ZSplitsLeft++;
		tZ = tZ/2;
	}*/
	tConstructOct.ZSplitsLeft = m_ZPartitions;
	tConstructOct.YSplitsLeft = m_YPartitions;
	tConstructOct.XSplitsLeft = m_XPartitions;


	ConstructStack.push(tConstructOct);

	while (!ConstructStack.empty())
	{
		// There are 8 possible cases, each one of them is manually coded oh well
		// if (
		 
		tConstructOct = ConstructStack.top();
		ConstructStack.pop(); // pop it out here

		// do first the three cases where only one of the dimensions are split
		int Index0,Index1;
		Point3 newMax,newMin;
		bool AddOneFlag = false;
		if ((tConstructOct.XSplitsLeft == 0) && (tConstructOct.YSplitsLeft == 0) && (tConstructOct.ZSplitsLeft == 0))
		{
			// we have no where to go don't split
		}
		else
		{
			if ((tConstructOct.XSplitsLeft > tConstructOct.YSplitsLeft) &&
				(tConstructOct.XSplitsLeft > tConstructOct.ZSplitsLeft))
			{
				// split in x dimension
				Index0 = 0;
				Index1 = 1;
				newMax = tConstructOct.NodePtr->Area.m_AMax;
				newMax.x = (tConstructOct.NodePtr->Area.m_AMax.x + tConstructOct.NodePtr->Area.m_AMin.x)/2.0;
				newMin = tConstructOct.NodePtr->Area.m_AMin;
				newMin.x = newMax.x;

				// create the structure needed for the stack
				tNewConstructOct = tConstructOct;
				tNewConstructOct.XSplitsLeft--;

				AddOneFlag = true;
			}
			else if ((tConstructOct.YSplitsLeft > tConstructOct.XSplitsLeft) &&
				(tConstructOct.YSplitsLeft > tConstructOct.ZSplitsLeft))
			{
				//split in Y dimension
				Index0 = 0;
				Index1 = 4;
				newMax = tConstructOct.NodePtr->Area.m_AMax;
				newMax.y = (tConstructOct.NodePtr->Area.m_AMax.y + tConstructOct.NodePtr->Area.m_AMin.y)/2.0;
				newMin = tConstructOct.NodePtr->Area.m_AMin;
				newMin.y = newMax.y;

				// create the structure needed for the stack
				tNewConstructOct = tConstructOct;
				tNewConstructOct.YSplitsLeft--;

				AddOneFlag = true;
			}
			else if ((tConstructOct.ZSplitsLeft > tConstructOct.YSplitsLeft) &&
				(tConstructOct.ZSplitsLeft > tConstructOct.XSplitsLeft))
			{
				//split in Z dimension
				Index0 = 0;
				Index1 = 3;
				newMax = tConstructOct.NodePtr->Area.m_AMax;
				newMax.z = (tConstructOct.NodePtr->Area.m_AMax.z + tConstructOct.NodePtr->Area.m_AMin.z)/2.0;
				newMin = tConstructOct.NodePtr->Area.m_AMin;
				newMin.z = newMax.z;
				
				// create the structure needed for the stack
				tNewConstructOct = tConstructOct;
				tNewConstructOct.ZSplitsLeft--;

				AddOneFlag = true;
			}

			if (AddOneFlag)
			{
			
				// we only need to split along the x axis
				// create the new octnodes
				tConstructOct.NodePtr->Children[Index0] = new OctNode;
				tConstructOct.NodePtr->Children[Index1] = new OctNode;
				// link them to the parents
				tConstructOct.NodePtr->Children[Index0]->Parent = tConstructOct.NodePtr;
				tConstructOct.NodePtr->Children[Index1]->Parent = tConstructOct.NodePtr;			
				// chance the dimensions
				tConstructOct.NodePtr->Children[Index0]->Area.m_AMax = tConstructOct.NodePtr->Area.m_AMax;
				tConstructOct.NodePtr->Children[Index0]->Area.m_AMin = newMin;			
				tConstructOct.NodePtr->Children[Index1]->Area.m_AMax = newMax;
				tConstructOct.NodePtr->Children[Index1]->Area.m_AMin = tConstructOct.NodePtr->Area.m_AMin;

				// add the two to the stack
				tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[Index0];
				ConstructStack.push(tNewConstructOct);
				tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[Index1];
				ConstructStack.push(tNewConstructOct);
			}
			else
			{
				int Index0,Index1,Index2,Index3;
				Point3 Index0Max,Index0Min,Index1Max,Index1Min,Index2Max,Index2Min
					,Index3Max,Index3Min;
				bool AddTwoFlag = false;
				// next do the 3 cases where 2 of them have to be split
				if ((tConstructOct.XSplitsLeft == tConstructOct.YSplitsLeft) &&
				(tConstructOct.XSplitsLeft > tConstructOct.ZSplitsLeft))
				{
					// x and y is to be split
					Index0 = 0;
					Index1 = 1;
					Index2 = 4;
					Index3 = 5;
					// find the new dimensions
					Index0Max = tConstructOct.NodePtr->Area.m_AMax;
					Index0Min = tConstructOct.NodePtr->Area.m_AMin;
					Index0Min.x = (tConstructOct.NodePtr->Area.m_AMax.x + tConstructOct.NodePtr->Area.m_AMin.x)/2.0;
					Index0Min.y = (tConstructOct.NodePtr->Area.m_AMax.y + tConstructOct.NodePtr->Area.m_AMin.y)/2.0;

					Index1Max = tConstructOct.NodePtr->Area.m_AMax;
					Index1Min = tConstructOct.NodePtr->Area.m_AMin;
					Index1Max.x = Index0Min.x;
					Index1Min.y = Index0Min.y;

					Index2Max = tConstructOct.NodePtr->Area.m_AMax;
					Index2Min = tConstructOct.NodePtr->Area.m_AMin;
					Index2Max.y = Index1Min.y;
					Index2Min.x = Index1Max.x;

					Index3Max = tConstructOct.NodePtr->Area.m_AMax;
					Index3Min = tConstructOct.NodePtr->Area.m_AMin;
					Index3Max.y = Index1Min.y;
					Index3Max.x = Index2Min.x;

					// used for the addition to the stack
					tNewConstructOct = tConstructOct;
					tNewConstructOct.XSplitsLeft--;
					tNewConstructOct.YSplitsLeft--;

					AddTwoFlag = true;
				}
				else if ((tConstructOct.XSplitsLeft == tConstructOct.ZSplitsLeft) &&
					(tConstructOct.XSplitsLeft > tConstructOct.YSplitsLeft))
				{
					// x and z is to be split
					Index0 = 0;
					Index1 = 1;
					Index2 = 2;
					Index3 = 3;
					// find the new dimensions
					Index0Max = tConstructOct.NodePtr->Area.m_AMax;
					Index0Min = tConstructOct.NodePtr->Area.m_AMin;
					Index0Min.x = (tConstructOct.NodePtr->Area.m_AMax.x + tConstructOct.NodePtr->Area.m_AMin.x)/2.0;
					Index0Min.z = (tConstructOct.NodePtr->Area.m_AMax.z + tConstructOct.NodePtr->Area.m_AMin.z)/2.0;

					Index1Max = tConstructOct.NodePtr->Area.m_AMax;
					Index1Min = tConstructOct.NodePtr->Area.m_AMin;
					Index1Max.x = Index0Min.x;
					Index1Min.z = Index0Min.z;

					Index2Max = tConstructOct.NodePtr->Area.m_AMax;
					Index2Min = tConstructOct.NodePtr->Area.m_AMin;
					Index2Max.z = Index0Min.z;
					Index2Max.x = Index0Min.x;

					Index3Max = tConstructOct.NodePtr->Area.m_AMax;
					Index3Min = tConstructOct.NodePtr->Area.m_AMin;
					Index3Max.z = Index0Min.z;
					Index3Min.x = Index0Min.x;

					// used for the addition to the stack
					tNewConstructOct = tConstructOct;
					tNewConstructOct.XSplitsLeft--;
					tNewConstructOct.ZSplitsLeft--;

					AddTwoFlag = true;
				}
				else if ((tConstructOct.ZSplitsLeft == tConstructOct.YSplitsLeft) &&
					(tConstructOct.ZSplitsLeft > tConstructOct.XSplitsLeft))
				{
					// z and y is to be split
					Index0 = 0;
					Index1 = 3;
					Index2 = 4;
					Index3 = 7;

					// find the new dimensions
					Index0Max = tConstructOct.NodePtr->Area.m_AMax;
					Index0Min = tConstructOct.NodePtr->Area.m_AMin;
					Index0Min.z = (tConstructOct.NodePtr->Area.m_AMax.z + tConstructOct.NodePtr->Area.m_AMin.z)/2.0;
					Index0Min.y = (tConstructOct.NodePtr->Area.m_AMax.y + tConstructOct.NodePtr->Area.m_AMin.y)/2.0;

					Index1Max = tConstructOct.NodePtr->Area.m_AMax;
					Index1Min = tConstructOct.NodePtr->Area.m_AMin;
					Index1Max.z = Index0Min.z;
					Index1Min.y = Index0Min.y;

					Index2Max = tConstructOct.NodePtr->Area.m_AMax;
					Index2Min = tConstructOct.NodePtr->Area.m_AMin;
					Index2Max.y = Index0Min.y;
					Index2Min.z = Index0Min.z;

					Index3Max = tConstructOct.NodePtr->Area.m_AMax;
					Index3Min = tConstructOct.NodePtr->Area.m_AMin;
					Index3Max.z = Index0Min.z;
					Index3Max.y = Index0Min.y;

					// used for the addition to the stack
					tNewConstructOct = tConstructOct;
					tNewConstructOct.YSplitsLeft--;
					tNewConstructOct.ZSplitsLeft--;

					AddTwoFlag = true;
				}
				if (AddTwoFlag)
				{
					// create the octnodes
					tConstructOct.NodePtr->Children[Index0] = new OctNode;
					tConstructOct.NodePtr->Children[Index1] = new OctNode;
					tConstructOct.NodePtr->Children[Index2] = new OctNode;
					tConstructOct.NodePtr->Children[Index3] = new OctNode;

					// link them back to the parent
					tConstructOct.NodePtr->Children[Index0]->Parent = tConstructOct.NodePtr;
					tConstructOct.NodePtr->Children[Index1]->Parent = tConstructOct.NodePtr;
					tConstructOct.NodePtr->Children[Index2]->Parent = tConstructOct.NodePtr;
					tConstructOct.NodePtr->Children[Index3]->Parent = tConstructOct.NodePtr;

					// now fix their dimensions
					tConstructOct.NodePtr->Children[Index0]->Area.m_AMax = Index0Max;
					tConstructOct.NodePtr->Children[Index0]->Area.m_AMin = Index0Min;
					tConstructOct.NodePtr->Children[Index1]->Area.m_AMax = Index1Max;
					tConstructOct.NodePtr->Children[Index1]->Area.m_AMin = Index1Min;
					tConstructOct.NodePtr->Children[Index2]->Area.m_AMax = Index2Max;
					tConstructOct.NodePtr->Children[Index2]->Area.m_AMin = Index2Min;
					tConstructOct.NodePtr->Children[Index3]->Area.m_AMax = Index3Max;
					tConstructOct.NodePtr->Children[Index3]->Area.m_AMin = Index3Min;


					ASSERT(tConstructOct.NodePtr->Children[Index0]->Area.m_AMin.y != tConstructOct.NodePtr->Children[Index0]->Area.m_AMax.y);
						ASSERT(tConstructOct.NodePtr->Children[Index1]->Area.m_AMin.y != tConstructOct.NodePtr->Children[Index1]->Area.m_AMax.y);

							ASSERT(tConstructOct.NodePtr->Children[Index2]->Area.m_AMin.y != tConstructOct.NodePtr->Children[Index2]->Area.m_AMax.y);

								ASSERT(tConstructOct.NodePtr->Children[Index3]->Area.m_AMin.y != tConstructOct.NodePtr->Children[Index3]->Area.m_AMax.y);


					// now add each of them to the stack
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[Index0];
					ConstructStack.push(tNewConstructOct);
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[Index1];
					ConstructStack.push(tNewConstructOct);
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[Index2];
					ConstructStack.push(tNewConstructOct);
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[Index3];
					ConstructStack.push(tNewConstructOct);
				}
				else
				{
					// last case is if all three dimensions have to be split
					// create the octnodes
					tConstructOct.NodePtr->Children[0] = new OctNode;
					tConstructOct.NodePtr->Children[1] = new OctNode;
					tConstructOct.NodePtr->Children[2] = new OctNode;
					tConstructOct.NodePtr->Children[3] = new OctNode;
					tConstructOct.NodePtr->Children[4] = new OctNode;
					tConstructOct.NodePtr->Children[5] = new OctNode;
					tConstructOct.NodePtr->Children[6] = new OctNode;
					tConstructOct.NodePtr->Children[7] = new OctNode;

					// link them back to the parent
					tConstructOct.NodePtr->Children[0]->Parent = tConstructOct.NodePtr;
					tConstructOct.NodePtr->Children[1]->Parent = tConstructOct.NodePtr;
					tConstructOct.NodePtr->Children[2]->Parent = tConstructOct.NodePtr;
					tConstructOct.NodePtr->Children[3]->Parent = tConstructOct.NodePtr;
					tConstructOct.NodePtr->Children[4]->Parent = tConstructOct.NodePtr;
					tConstructOct.NodePtr->Children[5]->Parent = tConstructOct.NodePtr;
					tConstructOct.NodePtr->Children[6]->Parent = tConstructOct.NodePtr;
					tConstructOct.NodePtr->Children[7]->Parent = tConstructOct.NodePtr;

					// now fix there dimensions
					double HalfX,HalfY,HalfZ;
					HalfX = (tConstructOct.NodePtr->Area.m_AMax.x + tConstructOct.NodePtr->Area.m_AMin.x)/2.0;
					HalfY = (tConstructOct.NodePtr->Area.m_AMax.y + tConstructOct.NodePtr->Area.m_AMin.y)/2.0;
					HalfZ = (tConstructOct.NodePtr->Area.m_AMax.z + tConstructOct.NodePtr->Area.m_AMin.z)/2.0;

					tConstructOct.NodePtr->Children[0]->Area.m_AMax = tConstructOct.NodePtr->Area.m_AMax;
					tConstructOct.NodePtr->Children[0]->Area.m_AMin = tConstructOct.NodePtr->Area.m_AMin;
					tConstructOct.NodePtr->Children[0]->Area.m_AMin.x = HalfX;
					tConstructOct.NodePtr->Children[0]->Area.m_AMin.y = HalfY;
					tConstructOct.NodePtr->Children[0]->Area.m_AMin.z = HalfZ;

					tConstructOct.NodePtr->Children[1]->Area.m_AMax = tConstructOct.NodePtr->Area.m_AMax;
					tConstructOct.NodePtr->Children[1]->Area.m_AMin = tConstructOct.NodePtr->Area.m_AMin;
					tConstructOct.NodePtr->Children[1]->Area.m_AMin.z = HalfZ;
					tConstructOct.NodePtr->Children[1]->Area.m_AMin.y = HalfY;
					tConstructOct.NodePtr->Children[1]->Area.m_AMax.x = HalfX;

					tConstructOct.NodePtr->Children[2]->Area.m_AMax = tConstructOct.NodePtr->Area.m_AMax;
					tConstructOct.NodePtr->Children[2]->Area.m_AMin = tConstructOct.NodePtr->Area.m_AMin;
					tConstructOct.NodePtr->Children[2]->Area.m_AMin.y = HalfY;
					tConstructOct.NodePtr->Children[2]->Area.m_AMax.z = HalfZ;
					tConstructOct.NodePtr->Children[2]->Area.m_AMax.x = HalfX;

					tConstructOct.NodePtr->Children[3]->Area.m_AMax = tConstructOct.NodePtr->Area.m_AMax;
					tConstructOct.NodePtr->Children[3]->Area.m_AMin = tConstructOct.NodePtr->Area.m_AMin;
					tConstructOct.NodePtr->Children[3]->Area.m_AMin.y = HalfY;
					tConstructOct.NodePtr->Children[3]->Area.m_AMax.z = HalfZ;
					tConstructOct.NodePtr->Children[3]->Area.m_AMin.x = HalfX;

					tConstructOct.NodePtr->Children[4]->Area.m_AMax = tConstructOct.NodePtr->Area.m_AMax;
					tConstructOct.NodePtr->Children[4]->Area.m_AMin = tConstructOct.NodePtr->Area.m_AMin;
					tConstructOct.NodePtr->Children[4]->Area.m_AMax.y = HalfY;
					tConstructOct.NodePtr->Children[4]->Area.m_AMin.z = HalfZ;
					tConstructOct.NodePtr->Children[4]->Area.m_AMin.x = HalfX;

					tConstructOct.NodePtr->Children[5]->Area.m_AMax = tConstructOct.NodePtr->Area.m_AMax;
					tConstructOct.NodePtr->Children[5]->Area.m_AMin = tConstructOct.NodePtr->Area.m_AMin;
					tConstructOct.NodePtr->Children[5]->Area.m_AMax.y = HalfY;
					tConstructOct.NodePtr->Children[5]->Area.m_AMin.z = HalfZ;
					tConstructOct.NodePtr->Children[5]->Area.m_AMax.x = HalfX;

					tConstructOct.NodePtr->Children[6]->Area.m_AMax = tConstructOct.NodePtr->Area.m_AMax;
					tConstructOct.NodePtr->Children[6]->Area.m_AMin = tConstructOct.NodePtr->Area.m_AMin;
					tConstructOct.NodePtr->Children[6]->Area.m_AMax.y = HalfY;
					tConstructOct.NodePtr->Children[6]->Area.m_AMax.z = HalfZ;
					tConstructOct.NodePtr->Children[6]->Area.m_AMax.x = HalfX;

					tConstructOct.NodePtr->Children[7]->Area.m_AMax = tConstructOct.NodePtr->Area.m_AMax;
					tConstructOct.NodePtr->Children[7]->Area.m_AMin = tConstructOct.NodePtr->Area.m_AMin;
					tConstructOct.NodePtr->Children[7]->Area.m_AMax.y = HalfY;
					tConstructOct.NodePtr->Children[7]->Area.m_AMax.z = HalfZ;
					tConstructOct.NodePtr->Children[7]->Area.m_AMin.x = HalfX;

					tNewConstructOct = tConstructOct;
					tNewConstructOct.XSplitsLeft--;
					tNewConstructOct.YSplitsLeft--;
					tNewConstructOct.ZSplitsLeft--;
					// now add them to the stack
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[0];
					ConstructStack.push(tNewConstructOct);
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[1];
					ConstructStack.push(tNewConstructOct);
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[2];
					ConstructStack.push(tNewConstructOct);
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[3];
					ConstructStack.push(tNewConstructOct);
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[4];
					ConstructStack.push(tNewConstructOct);
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[5];
					ConstructStack.push(tNewConstructOct);
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[6];
					ConstructStack.push(tNewConstructOct);
					tNewConstructOct.NodePtr = tConstructOct.NodePtr->Children[7];
					ConstructStack.push(tNewConstructOct);
				}
			}
		}

	}

			theProfiler.EnterEndTime("Init1");

					theProfiler.EnterStartTime("Init2");
	OctJoinNeighbours();
		theProfiler.EnterEndTime("Init2");



}

//---------------------------------------------------------------------
// DebugRenderOctGrid(LINEVERTEX* &pVertex, int &VertexCount)
// 
// Usage: Called in the rendering loops, used to render the oct tree grid
//        for debugging purposes
// 
// Input: pVertex, vertex buffer ptr
// Output: VertexCount, return vertex count
// DepthLevel: The depth level of the oct tree to render
//---------------------------------------------------------------------
void OctTree::DebugRenderOctGrid(LINEVERTEX *&pVertex, int &VertexCount)
{
	int TraversalFlag = m_Root->TraversalFlag + 1; // an arbitrary flag, so a node is only rendered once
	int CurrLevel = 1; // used to only render up to the level desired

	int DepthLevel = 10;

	DWORD Color1 = 0xff000000;
	DWORD Color2 = 0xff0000ff;
	DWORD Color3 = 0xff00ff00;

	OctNodePtr Curr,Next,Goto;

	Goto = Curr = Next = m_Root;

	VertexCount = 0;

	// return nothing to do
	if (m_Root == NULL)
		return;

	m_Root->TraversalFlag = TraversalFlag;


	DebugRenderFormCube(pVertex,m_Root->Area,VertexCount,Color1);

		//////////////////////////////////////////////
	// render the objects here
	ObjectListT::iterator curr = m_Root->ObjectList.begin();
	ObjectListT::iterator end = m_Root->ObjectList.end();
	while (curr != end)
	{
		// put the object in the render list
		theVTManager.AddTriangleList((*curr)->m_TextureType,*(*curr));
		curr++;
	} 


	// only top level to do, return
	if (DepthLevel == 1)
		return;

	// do a walk of the oct tree visiting every node once, and adding the vertices 
	// to the vertex buffer
	// add the first one to the buffer
	do {

		Curr = Goto;
		Goto = NULL;

		if (VertexCount >= 30000)
		{
			return;
		}
	
		if (CurrLevel < DepthLevel)
		{
			for (int ix = 0; ix < 8; ix++)
			{
				if (Curr->Children[ix] != NULL)
				{
					if (Curr->Children[ix]->TraversalFlag != TraversalFlag)
					{
						Goto = Curr->Children[ix];
						Goto->TraversalFlag = TraversalFlag; // don't visit this node again						
					
						if (Goto->DebugPickFlag == DebugPickFlag)							
							DebugRenderFormCube(pVertex,Goto->Area,VertexCount,Color2);
						else if (Goto->m_NumofObjects != 0)
							DebugRenderFormCube(pVertex,Goto->Area,VertexCount,Color3);


						//////////////////////////////////////////////
						// render the objects here
						ObjectListT::iterator curr = Goto->ObjectList.begin();
						ObjectListT::iterator end = Goto->ObjectList.end();
						while (curr != end)
						{
							// put the object in the render list
							theVTManager.AddTriangleList((*curr)->m_TextureType,*(*curr));
							curr++;
						} 

						CurrLevel++; // update depth level
						break;
					}								
				}
			}
		}
		else
			return;

	

		if (Goto == NULL)
		{
			if (Curr->Parent == NULL)
			{
				//exit
			}
			else
			{
				Goto = Curr->Parent;
				CurrLevel--;
			}
		}
	} while (Goto != NULL);
}

//---------------------------------------------------------------------
// RenderFormCube(LINEVERTEX *&pVertex, FCube theCube, int &VertexCount)
// 
// Usage: Creates a cube by calling renderformface 6 times (one for each face)
// 
//---------------------------------------------------------------------
void OctTree::DebugRenderFormCube(LINEVERTEX *&pVertex, const FCube &theCube, int &VertexCount, const DWORD &Color)
{
	Point3 Points[4];
	DWORD Color1 = Color;

	// front
	Points[0] = Point3(theCube.m_AMin.x,theCube.m_AMin.y,theCube.m_AMax.z);
	Points[1] = Point3(theCube.m_AMax.x,theCube.m_AMin.y,theCube.m_AMax.z);
	Points[2] = Point3(theCube.m_AMax.x,theCube.m_AMax.y,theCube.m_AMax.z);
	Points[3] = Point3(theCube.m_AMin.x,theCube.m_AMax.y,theCube.m_AMax.z);
	DebugRenderFormFace(pVertex,Points,VertexCount,Color);

	// back
	Points[0] = Point3(theCube.m_AMin.x,theCube.m_AMin.y,theCube.m_AMin.z);
	Points[1] = Point3(theCube.m_AMax.x,theCube.m_AMin.y,theCube.m_AMin.z);
	Points[2] = Point3(theCube.m_AMax.x,theCube.m_AMax.y,theCube.m_AMin.z);
	Points[3] = Point3(theCube.m_AMin.x,theCube.m_AMax.y,theCube.m_AMin.z);
	DebugRenderFormFace(pVertex,Points,VertexCount,Color);


  	pVertex[0].x = theCube.m_AMin.x;
	pVertex[0].y = theCube.m_AMin.y;
	pVertex[0].z = theCube.m_AMax.z;
	pVertex[0].color = Color1;

	pVertex[1].x = theCube.m_AMin.x;
	pVertex[1].y = theCube.m_AMin.y;
	pVertex[1].z = theCube.m_AMin.z;
	pVertex[1].color = Color1;

	pVertex[2].x = theCube.m_AMax.x;
	pVertex[2].y = theCube.m_AMin.y;
	pVertex[2].z = theCube.m_AMax.z;
	pVertex[2].color = Color1;
	
	pVertex[3].x = theCube.m_AMax.x;
	pVertex[3].y = theCube.m_AMin.y;
	pVertex[3].z = theCube.m_AMin.z;
	pVertex[3].color = Color1;

	pVertex[4].x = theCube.m_AMax.x;
	pVertex[4].y = theCube.m_AMax.y;
	pVertex[4].z = theCube.m_AMax.z;
	pVertex[4].color = Color1;

	pVertex[5].x = theCube.m_AMax.x;
	pVertex[5].y = theCube.m_AMax.y;
	pVertex[5].z = theCube.m_AMin.z;
	pVertex[5].color = Color1;	

	pVertex[6].x = theCube.m_AMin.x;
	pVertex[6].y = theCube.m_AMax.y;
	pVertex[6].z = theCube.m_AMax.z;
	pVertex[6].color = Color1;	

	pVertex[7].x = theCube.m_AMin.x;
	pVertex[7].y = theCube.m_AMax.y;
	pVertex[7].z = theCube.m_AMin.z;
	pVertex[7].color = Color1;

	VertexCount += 4;
    pVertex += 8;

}

//---------------------------------------------------------------------
// RenderFormFace(VERTEX *&pVertex, D3DVECTOR Points[], int &VertexCount)
// 
// Usage: Creates a face out of 4 points
// 
// Inputs:
// Point 0 Bottom left
// Point 1 Bottom right
// Point 2 Bottom top left
// Point 3 Bottom top right
// int WidthSegments: the number of width segments, must be a power of 2
// int LengthSegments: the number of length segments, must be a power of 2
// int HeightSegments: the number of height segments, must be a power of 2

// Notes: By convention the height is splittable less then the width of length
//---------------------------------------------------------------------
void OctTree::DebugRenderFormFace(LINEVERTEX *&pVertex, const Point3 Points[], int &VertexCount, const DWORD &Color)
{
	DWORD Color1 = Color;
	// face 1
	pVertex[0].x = Points[0].x;
	pVertex[0].y = Points[0].y;
	pVertex[0].z = Points[0].z;
	pVertex[0].color = Color1;

	pVertex[1].x = Points[1].x;
	pVertex[1].y = Points[1].y;
	pVertex[1].z = Points[1].z;
	pVertex[1].color = Color1;

	pVertex[2].x = Points[1].x;
	pVertex[2].y = Points[1].y;
	pVertex[2].z = Points[1].z;
	pVertex[2].color = Color1;
	
	pVertex[3].x = Points[2].x;
	pVertex[3].y = Points[2].y;
	pVertex[3].z = Points[2].z;
	pVertex[3].color = Color1;

	pVertex[4].x = Points[2].x;
	pVertex[4].y = Points[2].y;
	pVertex[4].z = Points[2].z;
	pVertex[4].color = Color1;

	pVertex[5].x = Points[3].x;
	pVertex[5].y = Points[3].y;
	pVertex[5].z = Points[3].z;
	pVertex[5].color = Color1;	

	pVertex[6].x = Points[3].x;
	pVertex[6].y = Points[3].y;
	pVertex[6].z = Points[3].z;
	pVertex[6].color = Color1;	

	pVertex[7].x = Points[0].x;
	pVertex[7].y = Points[0].y;
	pVertex[7].z = Points[0].z;
	pVertex[7].color = Color1;

	VertexCount += 4;
    pVertex += 8;

}

//---------------------------------------------------------------------
// OctNodePtr OctTree::GetOctNode(Point3 Point, int DepthLevel)
// 
// Usage:
//   This function gets the octnode that contains the point and is 
//    at a certain depth level
//---------------------------------------------------------------------
OctTree::OctNodePtr OctTree::GetOctNode(Point3 Point, int DepthLevel)
{
	return NULL;

}

//---------------------------------------------------------------------
// OctJoinNeighbours()
// 
// Usage: Called in init where all of the octnodes are created
//		  to join the neighbours
//
// Algorithm: Traverse the tree visiting each node once, while joining the node
//            to its neighbours
//
// Notes
//   1) I also stuck the AccountForE function for the area here
//   2) and the precomputation of planes
//---------------------------------------------------------------------
void OctTree::OctJoinNeighbours()
{
	int TraversalFlag = m_Root->TraversalFlag + 1; // an arbitrary flag, so a node is only rendered once
	int CurrLevel = 1; 

	OctNodePtr Curr,Next,Goto;

	Goto = Curr = Next = m_Root;

	m_Root->TraversalFlag = TraversalFlag;
	// Note 1)
	Goto->Area.AccountForE(); // this function should be called once per node,
						  // on construction might as well do it here.
	// Note 2)
	Point3 v1,v2,v3;
	for (int iz = 0; iz < 6; iz++)
	{

		Goto->Area.GetPlaneVertices(iz,v1,v2,v3);
		Goto->NeighboursPlanes[iz].GeneratePlane(v1,v2,v3);
	}


	// do a walk of the oct tree visiting every node once, and adding the vertices 
	// to the vertex buffer
	// add the first one to the buffer
	do {

		Curr = Goto;
		Goto = NULL;
	
	
		for (int ix = 0; ix < 8; ix++)
		{
			if (Curr->Children[ix] != NULL)
			{
				if (Curr->Children[ix]->TraversalFlag != TraversalFlag)
				{					
					Goto = Curr->Children[ix];
					Goto->TraversalFlag = TraversalFlag; // don't visit this node again	
					// Note 1)
					Goto->Area.AccountForE(); // this function should be called once per node,
											  // on construction might as well do it here.
					// Note 2)
					Point3 v1,v2,v3;
					for (int iz = 0; iz < 6; iz++)
					{

						Goto->Area.GetPlaneVertices(iz,v1,v2,v3);
						Goto->NeighboursPlanes[iz].GeneratePlane(v1,v2,v3);
					}

					OctFindNeighbour(Goto,CurrLevel);					
					CurrLevel++; // update depth level
					break;
				}
			}
		}
	
		if (Goto == NULL)
		{
			if (Curr->Parent == NULL)
			{
				//exit
			}
			else
			{
				Goto = Curr->Parent;
				CurrLevel--;
			}
		}
	} while (Goto != NULL);

}

//---------------------------------------------------------------------
// OctFindNeighbour(OctTree::OctNode *&CurrentNode, int &CurrLevel)
// 
// Usage: Called in the OctJoinNeighbour function after all of the nodes have been
//        created to connect them to the neighbours
//
// Algorithm: For each of the six possible neighbours, it generates a point in 3-D space
//            that is contained in the neighbour and then does a search to figure out which 
//            node this point is in, this node is the neighbour. 
//---------------------------------------------------------------------
void OctTree::OctFindNeighbour(OctTree::OctNode *&CurrentNode, int &CurrLevel)
{
	Point3 NPoint;
	OctNodePtr tOctNodePtr;

	int tCurrLevel;

	// must have at least one parent
	if (CurrentNode->Parent == NULL)
		return; 


	for (int ix = 0; ix < 6; ix++)
	{
		ASSERT(CurrentNode != NULL);

		FCube CurrBounds = CurrentNode->Area;

		float SmallNumber = 0.1f;
		if (ix == 0)
		{
			// +Z neighbour
			NPoint.x = CurrBounds.m_AMax.x - CurrBounds.Length()/2.0f;
			NPoint.y = CurrBounds.m_AMax.y - CurrBounds.Height()/2.0f;
			NPoint.z = CurrBounds.m_AMax.z + SmallNumber;
		}
		else if (ix == 1)
		{
			// +X neighbour
			NPoint.z = CurrBounds.m_AMax.z - CurrBounds.Width()/2.0f;
			NPoint.y = CurrBounds.m_AMax.y - CurrBounds.Height()/2.0f;
			NPoint.x = CurrBounds.m_AMax.x + SmallNumber;
		}
		else if (ix == 2)
		{
			// -Z neighbour
			NPoint.x = CurrBounds.m_AMax.x - CurrBounds.Length()/2.0f;
			NPoint.y = CurrBounds.m_AMax.y - CurrBounds.Height()/2.0f;
			NPoint.z = CurrBounds.m_AMin.z - SmallNumber;
		}
		else if (ix == 3)
		{
			// -X neighbour
			NPoint.z = CurrBounds.m_AMax.z - CurrBounds.Width()/2.0f;
			NPoint.y = CurrBounds.m_AMax.y - CurrBounds.Height()/2.0f;
			NPoint.x = CurrBounds.m_AMin.x - SmallNumber;
		}
		else if (ix == 4)
		{
			// +Y neighbour
			NPoint.z = CurrBounds.m_AMax.z - CurrBounds.Width()/2.0f;
			NPoint.x = CurrBounds.m_AMax.x - CurrBounds.Length()/2.0f;
			NPoint.y = CurrBounds.m_AMax.y + SmallNumber;
		}
		else if (ix == 5)
		{
			// -Y neighbour
			NPoint.z = CurrBounds.m_AMax.z - CurrBounds.Width()/2.0f;
			NPoint.x = CurrBounds.m_AMax.x - CurrBounds.Length()/2.0f;
			NPoint.y = CurrBounds.m_AMin.y - SmallNumber;
		}


		// the point might not be valid so in that case don't bother checking
		if (m_Root->Area.PointInCube(NPoint))
		{
		
			tOctNodePtr = CurrentNode->Parent;
			tCurrLevel = CurrLevel-1;
			// go up the tree to find a parent that contains this point
			while (tOctNodePtr != NULL)
			{
				if (tOctNodePtr->Area.PointInCube(NPoint))
				{				
					break;
				}
				tCurrLevel--;
				tOctNodePtr = tOctNodePtr->Parent;
			}

			// now go downwards to the children to find one in the same level that matches,
			// note at this point there must be a match
			if (tOctNodePtr != NULL)
			{
				while (tCurrLevel != CurrLevel)
				{
 				    OctNodePtr tempo; // debug
					int Tix;
					ASSERT(tOctNodePtr != NULL);

					for (int ix = 0; ix < 8; ix++)
					{
						if (tOctNodePtr->Children[ix] != NULL)
							if (tOctNodePtr->Children[ix]->Area.PointInCube(NPoint))
							{
								Tix = ix;
							//	newIndex = ix;
								break;
							}
					}

				//	int newIndex = UGetChildIndex(tOctNodePtr->Area,NPoint,tOctNodePtr);				

					tempo = tOctNodePtr;// debug

					tOctNodePtr = tOctNodePtr->Children[ix];
					tCurrLevel++;
				}
				CurrentNode->Neighbours[ix] = tOctNodePtr;
			}
		}
	}

}


//---------------------------------------------------------------------
// AddObject(BaseObject *theObject)
// 
// Usage: Used to add objects to the octtree
//
// Algorithm: Basically checks the AABB against the octtree and adds it when
//            it can't go any further down the heirarchy
//
// Returns false if it can't add the object
//---------------------------------------------------------------------
bool OctTree::AddObject(BaseObject *theObject)
{
	OctNodePtr Traverse = m_Root;

	Point3 AMax = theObject->GetBoundingAABB().GetAMax();
	Point3 AMin = theObject->GetBoundingAABB().GetAMin();

	// check if the object fits in our world
	if (!(Traverse->Area.PointInCube(AMax) && Traverse->Area.PointInCube(AMin)))
	{
		return false;
	}

	// k it does now find its place
	bool Done;
	
	do
	{
		Done = true;
		for (int ix = 0; ix < 8; ix++)
		{
			if (Traverse->Children[ix] != NULL)
			{
				if (Traverse->Children[ix]->Area.PointInCube(AMax) && Traverse->Children[ix]->Area.PointInCube(AMin))					
				{
					Traverse = Traverse->Children[ix];
					Done = false;
					break;
				}
			}
		}
	} while (!Done);

	//we found our node, now add the box to the octtree

	Traverse->ObjectList.push_back(theObject);
	// now up the object count and propogate the count upwards
	do {
		Traverse->m_NumofObjects++;
		Traverse = Traverse->Parent;
	} while (Traverse != NULL);

	// for now propogate the object into the children too.

	return true;
		


}

//---------------------------------------------------------------------
// DeleteObjectList(OctNodePtr OctNode)
// 
// Usage: In Destructer
// 
// Deletes all dynamically made objects
//---------------------------------------------------------------------
void OctTree::DeleteObjectList(OctTree::OctNode *OctNode)
{
	ObjectListT::iterator curr = OctNode->ObjectList.begin();
	ObjectListT::iterator end = OctNode->ObjectList.end();
	while (curr != end)
	{
		// delete the object
		delete (*curr);
		curr++;
	} 

}

//////////////////////////////////////////////////////////////////
// void DebugGetObject(Point3 Org, Point3 Dir)
//
// Usage:
//  Basic debugging now, this function picks an object but goes
//  through the octtree partition to minimize the objects picked
//
// Algorithm:
//   1) Find out if the ray origin is in the octtree.  If not find the 
//      intersection of the ray with the octtree
//   2) Go through each partition at each object
void OctTree::DebugGetObject(Point3 Org, Point3 Dir)
{
	// first thing to do is get a true origin.  check if the point is 
	// in the quadtree or not
	Point3 OctTreeOrg;
	Plane PrevPlane;
	int LastIX;
	Point3 T1,T2,T3;

	// diselect old one
	if (DebugPickPointer != NULL)
		DebugPickPointer->m_objectSelected = false;

	DebugPickFlag++;

	theProfiler.EnterStartTime("Pick1");

	float Error = -999999;
	OctTreeOrg.x = Error;

	if (m_Root->Area.PointInCube(Org))
	{
		// point is in cube, we know where to start
		OctTreeOrg = Org;	
		LastIX = -1;
	}
	else
	{
		// find the intersection of the ray and the octtree bounds.  This is
		// the new origin.
		
		// check the top plane
		float Distance = 99999999.9f;
		Point3 Intersection;
		Plane tempPlane;

		for (int ix = 0; ix < 6; ix++)
		{
			tempPlane = m_Root->NeighboursPlanes[ix];

			if (tempPlane.RayIntersectPlane(Intersection,Org,Dir))
			{
				
				float tDistance;
				if (m_Root->Area.PointInCubeWE(Intersection))
				{
					tDistance = (Org.x-Intersection.x)*(Org.x-Intersection.x)
						+ (Org.y-Intersection.y)*(Org.y-Intersection.y)
						+ (Org.z-Intersection.z)*(Org.z-Intersection.z);

					tDistance = sqrt(tDistance);

					if (tDistance < Distance)
					{
						Distance = tDistance;
						OctTreeOrg = Intersection;
						PrevPlane = tempPlane;
						LastIX = ix;
					}
				}
			}
		}
	}


	// check if the ray intersects the octtree
	if (OctTreeOrg.x == Error)
		return;

	// go down the heirachy all the way to get the cube where we are in.
	OctNodePtr Traverse = m_Root;

	// the "0" children should always be null
	while (Traverse->Children[0] != NULL)
	{
		for (int ix = 0; ix < 8; ix++)
		{
			if (Traverse->Children[ix] != NULL)
			{
				if (Traverse->Children[ix]->Area.PointInCubeWE(OctTreeOrg))
				{
					Traverse = Traverse->Children[ix];
					break;
				}
			}
		}
	}

	// we have to do this because the first plane comparison test will come
	// up false when it should be true if we use the plane from a non root area
	// rather then a root area

	// this will happen if we start inside of the octtree
	if (LastIX != -1)
		PrevPlane = Traverse->NeighboursPlanes[LastIX];

	// now we have the right cube, first search for any objects and compared
	// if it is the closest object in the octents.  If no object found
	// keep on going until we are no longer in the tree (neighbour is NULL) then quit
	
	Point3 Intersection;
	Plane tempPlane;

	OctNodePtr PreviusNode = Traverse;
	bool Collision = false;
	bool CanGoFurther = true;
	int count = 0;

	// since a ray can only intersect 3 types of planes figure them out, and order them 
	// according to magnitude.
	int Index[3];
	int IX,IY,IZ;
	Point3 DirT = Dir;

	if (DirT.x < 0)
		DirT.x = -DirT.x;
	if (DirT.y < 0)
		DirT.y = -DirT.y;
	if (DirT.z < 0)
		DirT.z = -DirT.z;

	if ((DirT.x > DirT.y) && (DirT.z > DirT.z))		
		if (DirT.z > DirT.y)		
		{
			IX = 0; IY = 2; IZ = 1;		
		}
		else
		{
			IX = 0; IY = 1; IZ = 2;		
		}	
	else if (DirT.y > DirT.z)	
		if (DirT.x > DirT.z)		
		{
			IX = 1; IY = 0; IZ = 2;			
		}
		else		
		{
			IX = 2; IY = 0; IZ = 1;		
		}
	else	
		if (DirT.x > DirT.y)	
		{
			IX = 1; IY = 2; IZ = 0;			
		}
		else		
		{
			IX = 2; IY = 1; IZ = 0;		
		}

	if (Dir.x > 0)
		Index[IX] = 1;
	else
		Index[IX] = 3;
	if (Dir.z > 0)
		Index[IY] = 0;
	else
		Index[IY] = 2;
	if (Dir.y > 0)
		Index[IZ] = 4;
	else
		Index[IZ] = 5;





	while (Traverse != NULL && !Collision && CanGoFurther)
	{

		CanGoFurther = false;
		// do collision detection here

		// render the objects here
		ObjectListT::iterator curr = Traverse->ObjectList.begin();
		ObjectListT::iterator end = Traverse->ObjectList.end();
		while (curr != end)
		{
			Point3 inter;
			if (((*curr)->GetBoundingSphere())->RayInterect(Org,Dir,inter))
			if ((*curr)->RayIntersectObject(Org,Dir))	
			{
				(*curr)->m_objectSelected = true;
				DebugPickPointer = (*curr);
			}
				//Beep(1000,10);

			// put the object in the render list
		//	theVTManager.AddTriangleList(0,*(*curr));
			curr++;
		} 






		// check for next octent
		for (int ix = 0; ix < 3; ix++)
		{
			int PlaneIndex = Index[ix]; // look at the most likely plane to intersect
			if (Traverse->NeighboursPlanes[PlaneIndex].RayIntersectPlane(Intersection,Org,Dir))
			{	
			//	ASSERT(Traverse->NeighboursPlanes[ix] == tempPlane);
				if (Traverse->Area.PointInCubeWE(Intersection))
				{
					//ASSERT(Traverse->Area.PointInCube(Intersection));
					// make sure we are not backtracking				
					if (!(PrevPlane == Traverse->NeighboursPlanes[PlaneIndex]))
					{
						// make sure we are in the right plane
						ASSERT(!CanGoFurther);
						OctTreeOrg = Intersection; // carry the point foward
						Traverse->DebugPickFlag = DebugPickFlag;
						PrevPlane = Traverse->NeighboursPlanes[PlaneIndex];
						Traverse = Traverse->Neighbours[PlaneIndex];					
						CanGoFurther = true;
						count++;
						break;
					}
				}
			}
		}
	}
	ASSERT(CanGoFurther);
//	ASSERT(count > 2);

	theProfiler.EnterEndTime("Pick1");
//	theProfiler.EnterStartTime("Pick4");
//	theProfiler.EnterEndTime("Pick4");
	double Time1 = theProfiler.GetExecutionTime("Pick1");
	double Time2 = theProfiler.GetExecutionTime("Pick2");
	double Time3 = theProfiler.GetExecutionTime("Pick3");
		double Time4 = theProfiler.GetExecutionTime("Pick4");
	double Total = Time1+ Time2 + Time3;

	char tempo[150];
//	sprintf(tempo,"Pick Time1 %9.7f (2) %9.7f (3) %9.7f,(4) %9.7f (a) %9.7f",Time1,Time2,Time3,Total,Time4);
sprintf(tempo,"Pick Time1 %9.7f ",Time1);

	AfxMessageBox(tempo);


}


//////////////////////////////////////////////////////////////////
// bool RayTraceCollision(Point3 Org, Point3 Dest)
//
// Usage:
//  Checks if a ray can originate from "Org" and goto "Dest" without colliding
//  into an object.  This function returns on the first object that collides with ray
//  It does not check for closer ones
//
// Algorithm:
//   1) Find out if the ray origin is in the octtree.  If not find the 
//      intersection of the ray with the octtree
//   2) Go through each partition at each object
//      and look for intersections
bool OctTree::RayTraceCollision(Point3 Org, Point3 Dest)
{
	// find the distance to travel
	double distance = Point3::Hypot(Org,Dest);
	Point3 Dir = Dest-Org;

	// first thing to do is get a true origin.  check if the point is 
	// in the quadtree or not
	Point3 OctTreeOrg;
	Plane PrevPlane;
	int LastIX;
	Point3 T1,T2,T3;

	// diselect old one
	if (DebugPickPointer != NULL)
		DebugPickPointer->m_objectSelected = false;

	DebugPickFlag++;

	float Error = -999999;
	OctTreeOrg.x = Error;

	if (m_Root->Area.PointInCube(Org))
	{
		// point is in cube, we know where to start
		OctTreeOrg = Org;	
		LastIX = -1;
	}
	else
	{
		// find the intersection of the ray and the octtree bounds.  This is
		// the new origin.
		
		// check the top plane
		float Distance = 99999999.9f;
		Point3 Intersection;
		Plane tempPlane;

		for (int ix = 0; ix < 6; ix++)
		{
			tempPlane = m_Root->NeighboursPlanes[ix];

			if (tempPlane.RayIntersectPlane(Intersection,Org,Dir))
			{
				
				float tDistance;
				if (m_Root->Area.PointInCubeWE(Intersection))
				{
					tDistance = (Org.x-Intersection.x)*(Org.x-Intersection.x)
						+ (Org.y-Intersection.y)*(Org.y-Intersection.y)
						+ (Org.z-Intersection.z)*(Org.z-Intersection.z);

					tDistance = sqrt(tDistance);

					if (tDistance < Distance)
					{
						Distance = tDistance;
						OctTreeOrg = Intersection;
						PrevPlane = tempPlane;
						LastIX = ix;
					}
				}
			}
		}
	}


	// check if the ray intersects the octtree
	if (OctTreeOrg.x == Error)
		return false;

	// go down the heirachy all the way to get the cube where we are in.
	OctNodePtr Traverse = m_Root;

	// the "0" children should always be null
	while (Traverse->Children[0] != NULL)
	{
		for (int ix = 0; ix < 8; ix++)
		{
			if (Traverse->Children[ix] != NULL)
			{
				if (Traverse->Children[ix]->Area.PointInCubeWE(OctTreeOrg))
				{
					Traverse = Traverse->Children[ix];
					break;
				}
			}
		}
	}

	// we have to do this because the first plane comparison test will come
	// up false when it should be true if we use the plane from a non root area
	// rather then a root area

	// this will happen if we start inside of the octtree
	if (LastIX != -1)
		PrevPlane = Traverse->NeighboursPlanes[LastIX];

	// now we have the right cube, first search for any objects and compared
	// if it is the closest object in the octents.  If no object found
	// keep on going until we are no longer in the tree (neighbour is NULL) then quit
	
	Point3 Intersection;
	Plane tempPlane;

	OctNodePtr PreviusNode = Traverse;
	bool Collision = false;
	bool CanGoFurther = true;
	int count = 0;

	// since a ray can only intersect 3 types of planes figure them out, and order them 
	// according to magnitude.
	int Index[3];
	int IX,IY,IZ;
	Point3 DirT = Dir;

	if (DirT.x < 0)
		DirT.x = -DirT.x;
	if (DirT.y < 0)
		DirT.y = -DirT.y;
	if (DirT.z < 0)
		DirT.z = -DirT.z;

	if ((DirT.x > DirT.y) && (DirT.z > DirT.z))		
		if (DirT.z > DirT.y)		
		{
			IX = 0; IY = 2; IZ = 1;		
		}
		else
		{
			IX = 0; IY = 1; IZ = 2;		
		}	
	else if (DirT.y > DirT.z)	
		if (DirT.x > DirT.z)		
		{
			IX = 1; IY = 0; IZ = 2;			
		}
		else		
		{
			IX = 2; IY = 0; IZ = 1;		
		}
	else	
		if (DirT.x > DirT.y)	
		{
			IX = 1; IY = 2; IZ = 0;			
		}
		else		
		{
			IX = 2; IY = 1; IZ = 0;		
		}

	if (Dir.x > 0)
		Index[IX] = 1;
	else
		Index[IX] = 3;
	if (Dir.z > 0)
		Index[IY] = 0;
	else
		Index[IY] = 2;
	if (Dir.y > 0)
		Index[IZ] = 4;
	else
		Index[IZ] = 5;





	while (Traverse != NULL && !Collision && CanGoFurther)
	{

		CanGoFurther = false;
		// do collision detection here, keep on checking for the closest object by checking
		// the distance of the intersection

	
		ObjectListT::iterator curr = Traverse->ObjectList.begin();
		ObjectListT::iterator end = Traverse->ObjectList.end();
		Point3 intersection;
 		while (curr != end)
		{
			Point3 inter;
			if ((*curr)->GetBoundingSphere()->RayInterect(Org,Dir,inter))
				if ((*curr)->RayIntersectObject(Org,Dir,intersection))	
				{
					Box *tBox;
					tBox = (Box*)(*curr);
					double objectDistance = Point3::Hypot(intersection,Org);
					if (objectDistance <= distance)
					{
						double objectDistance1 = Point3::Hypot(intersection,Dest);
						double objectDistance2 = Point3::Hypot(Org,Dest);
						if (objectDistance1 < objectDistance2)
							return true;
					}
				}
				//Beep(1000,10);

			// put the object in the render list
		//	theVTManager.AddTriangleList(0,*(*curr));
			curr++;
		} 






		// check for next octent
		for (int ix = 0; ix < 3; ix++)
		{
			int PlaneIndex = Index[ix]; // look at the most likely plane to intersect
			if (Traverse->NeighboursPlanes[PlaneIndex].RayIntersectPlane(Intersection,Org,Dir))
			{	
			//	ASSERT(Traverse->NeighboursPlanes[ix] == tempPlane);
				if (Traverse->Area.PointInCubeWE(Intersection))
				{
					//ASSERT(Traverse->Area.PointInCube(Intersection));
					// make sure we are not backtracking				
					if (!(PrevPlane == Traverse->NeighboursPlanes[PlaneIndex]))
					{
						// make sure we are in the right plane
						ASSERT(!CanGoFurther);
						OctTreeOrg = Intersection; // carry the point foward
						// now check if the intersection point is beyond the distance, if so
						// quit out
						double iDistance = Point3::Hypot(Intersection,Org);
						if (iDistance > distance)
							return false;
						Traverse->DebugPickFlag = DebugPickFlag;
						PrevPlane = Traverse->NeighboursPlanes[PlaneIndex];
						Traverse = Traverse->Neighbours[PlaneIndex];					
						CanGoFurther = true;
						count++;
						break;
					}
				}
			}
		}
	}
	return false;



}

// do standard rendering but create light maps instead
void OctTree::CreateLightMaps()
{
		int TraversalFlag = m_Root->TraversalFlag + 1; // an arbitrary flag, so a node is only rendered once
	int CurrLevel = 1; // used to only render up to the level desired

	int DepthLevel = 10;

	OctNodePtr Curr,Next,Goto;

	Goto = Curr = Next = m_Root;

	// return nothing to do
	if (m_Root == NULL)
		return;

	m_Root->TraversalFlag = TraversalFlag;


		//////////////////////////////////////////////
	// render the objects here
	ObjectListT::iterator curr = m_Root->ObjectList.begin();
	ObjectListT::iterator end = m_Root->ObjectList.end();
	while (curr != end)
	{
		// put the object in the render list
		(*curr)->GetLightMaps();
		curr++;
	} 


	// only top level to do, return
	if (DepthLevel == 1)
		return;

	// do a walk of the oct tree visiting every node once, and adding the vertices 
	// to the vertex buffer
	// add the first one to the buffer
	do {

		Curr = Goto;
		Goto = NULL;

	
		if (CurrLevel < DepthLevel)
		{
			for (int ix = 0; ix < 8; ix++)
			{
				if (Curr->Children[ix] != NULL)
				{
					if (Curr->Children[ix]->TraversalFlag != TraversalFlag)
					{
						Goto = Curr->Children[ix];
						Goto->TraversalFlag = TraversalFlag; // don't visit this node again						
					
						//////////////////////////////////////////////
						// render the objects here
						ObjectListT::iterator curr = Goto->ObjectList.begin();
						ObjectListT::iterator end = Goto->ObjectList.end();
						while (curr != end)
						{
							// put the object in the render list
							(*curr)->GetLightMaps();
							curr++;
						} 

						CurrLevel++; // update depth level
						break;
					}								
				}
			}
		}
		else
			return;

	

		if (Goto == NULL)
		{
			if (Curr->Parent == NULL)
			{
				//exit
			}
			else
			{
				Goto = Curr->Parent;
				CurrLevel--;
			}
		}
	} while (Goto != NULL);

}
