// R3DWindow.cpp: implementation of the R3DWindow class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "R3DWindow.h"
#include "VTManager.h"
#include "Box.h"
#include "ChildView.h"
#include "Matrix.h"

//directx includes
#include <d3dx8.h>
#include <mmsystem.h>
#include "stddef.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

R3DWindow theR3DWindow; // global reference

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

R3DWindow::R3DWindow()
{
	g_pD3D = NULL; // Used to create the D3DDevice
	g_pd3dDevice  = NULL; // Our rendering device
	g_pBackgroundVB  = NULL; // Buffer to hold vertices
	m_pTexture1 = NULL;
	g_pOctGrid = NULL;
	MainOctTree = NULL;
	g_DebugSphere = NULL;
	m_pFont = NULL;
	
	RCResetView();

}

R3DWindow::~R3DWindow()
{
	if( g_pBackgroundVB != NULL )
        g_pBackgroundVB->Release();

	if( g_pOctGrid != NULL )
        g_pOctGrid->Release();

    if ( m_pFont != NULL)
		delete m_pFont;

	

    if( g_pd3dDevice != NULL )
        g_pd3dDevice->Release();

    if( g_pD3D != NULL )
        g_pD3D->Release();

	if( m_pTexture1 != NULL )
        m_pTexture1->Release();

	if( g_DebugSphere != NULL )
        g_DebugSphere->Release();

	

	
	

}

void R3DWindow::Init(CWnd *Parent, CRect WindowPos)
{

	// create a frame window to hold the renderer
	char windowname[40]; 

     strcpy(windowname,
		 AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		    ::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL));

    // Set the window's initial style
    DWORD m_dwWindowStyle = WS_THICKFRAME
                      |WS_VISIBLE | WS_CHILD ;

	// set the window Position
	this->WindowPos = WindowPos;


	this->Parent = Parent;
    // Create the render window 
    FrameWindow.CreateEx(WS_EX_TOPMOST,windowname,"RenderWindow",m_dwWindowStyle,WindowPos,Parent,NULL,NULL);
    

	// Create the D3D object.
    if( NULL == ( g_pD3D = Direct3DCreate8( D3D_SDK_VERSION ) ) )
        return;

    // Get the current desktop display mode, so we can set up a back
    // buffer of the same format
    D3DDISPLAYMODE d3ddm;
    if( FAILED( g_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm ) ) )
        return;

    // Set up the structure used to create the D3DDevice
    D3DPRESENT_PARAMETERS d3dpp;
    ZeroMemory( &d3dpp, sizeof(d3dpp) );
    d3dpp.Windowed = TRUE;
    d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
    d3dpp.BackBufferFormat = d3ddm.Format;
	d3dpp.EnableAutoDepthStencil = true;
    d3dpp.AutoDepthStencilFormat = D3DFMT_D16;
 
    // Create the D3DDevice
    if( FAILED( g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, FrameWindow.m_hWnd,
                                      D3DCREATE_SOFTWARE_VERTEXPROCESSING,
                                      &d3dpp, &g_pd3dDevice ) ) )
    {
        return;
    }

    if( FAILED( g_pd3dDevice->CreateVertexBuffer( 100000*sizeof(LINEVERTEX),
												   D3DUSAGE_DYNAMIC ,
												   LINEVERTEX_TYPE,
												   D3DPOOL_DEFAULT,
												   &g_pOctGrid 
												   ) )) 
                                                   AfxMessageBox("Failed octgrid Vertex Buffer");

    

	D3DXCreateSphere(g_pd3dDevice,1.0,10,10,&g_DebugSphere,NULL);

srand( (unsigned)time( NULL ) );

	LoadWindowEffects();

	theVTManager.InitLightMaps(g_pd3dDevice); // init the lightmaps
	theVTManager.InitTextures(g_pd3dDevice); // init the textures

    m_pFont        = new CD3DFont( _T("Arial"), 12, D3DFONT_BOLD );
	m_pFont->InitDeviceObjects( g_pd3dDevice );
	m_pFont->RestoreDeviceObjects();

	// create some geometry
/*		Box *tBox;
//	for (int ix = 0; ix < 1; ix++)
//	{
		Point3 Center;
		float AngleX,AngleY,AngleZ;
	//	Center.x = 80.0*(float)rand()/RAND_MAX + 10;
	//	Center.y = 80.0*(float)rand()/RAND_MAX + 10;
	//	Center.z = 80.0*(float)rand()/RAND_MAX + 10;
		Center.x = 50;
		Center.y = 50;
		Center.z = 05;

	//	float AngleX = 360.0*(float)rand()/RAND_MAX;
	//	float AngleY = 360.0*(float)rand()/RAND_MAX;
	//	float AngleZ = 360.0*(float)rand()/RAND_MAX;

		int TextureType = 2*(float)rand()/RAND_MAX;
		if (TextureType == 2)
			TextureType = 1;

		//TextureType = 0;
		AngleX = 0;
		AngleY = 0;
		AngleZ = 0;

    	tBox = new Box;

		tBox->SetParameters(AngleX,AngleY,AngleZ,45,45,2,Center,0);
		//tBox->SetParameters(AngleX,AngleY,AngleZ,4,4,4,Point3(30,30,30));

		MainOctTree->AddObject(tBox);

		Center.x = 50;
		Center.y = 50;
		Center.z = 95;

		tBox = new Box;

		tBox->SetParameters(AngleX,AngleY,AngleZ,45,45,2,Center,0);
		//tBox->SetParameters(AngleX,AngleY,AngleZ,4,4,4,Point3(30,30,30));

		MainOctTree->AddObject(tBox);


		Center.x = 95;
		Center.y = 50;
		Center.z = 50;

		tBox = new Box;

		tBox->SetParameters(AngleX,AngleY,AngleZ,2,45,45,Center,0);
		//tBox->SetParameters(AngleX,AngleY,AngleZ,4,4,4,Point3(30,30,30));

		MainOctTree->AddObject(tBox);

		
		Center.x = 05;
		Center.y = 50;
		Center.z = 50;

		tBox = new Box;

		tBox->SetParameters(AngleX,AngleY,AngleZ,2,45,45,Center,0);
		//tBox->SetParameters(AngleX,AngleY,AngleZ,4,4,4,Point3(30,30,30));

		MainOctTree->AddObject(tBox);*/

	/*	Center.x = 20;
		Center.y = 50;
		Center.z = 50;

		tBox = new Box;

		tBox->SetParameters(AngleX,AngleY,AngleZ,2,20,20,Center,0);
		//tBox->SetParameters(AngleX,AngleY,AngleZ,4,4,4,Point3(30,30,30));

		MainOctTree->AddObject(tBox);*/

/*		for (int ix = 0; ix < 10; ix++)
		{
			Point3 Center;
			float AngleX,AngleY,AngleZ;
			Center.x = 80.0*(float)rand()/RAND_MAX + 10;
			Center.y = 80.0*(float)rand()/RAND_MAX + 10;
			Center.z = 80.0*(float)rand()/RAND_MAX + 10;
		//	Center.x = 50;
		//	Center.y = 50;
		//	Center.z = 05;

			AngleX = 360.0*(float)rand()/RAND_MAX;
			AngleY = 360.0*(float)rand()/RAND_MAX;
			AngleZ = 360.0*(float)rand()/RAND_MAX;

			int TextureType = 2*(float)rand()/RAND_MAX;
			if (TextureType == 2)
				TextureType = 1;

			//TextureType = 0;
		//	AngleX = 0;
		//	AngleY = 0;
		//	AngleZ = 0;

    		tBox = new Box;

			tBox->SetParameters(AngleX,AngleY,AngleZ,8,8,3,Center,TextureType);
			//tBox->SetParameters(AngleX,AngleY,AngleZ,4,4,4,Point3(30,30,30));

			MainOctTree->AddObject(tBox);
		}
		MainOctTree->CreateLightMaps();*/

//	}



}

void R3DWindow::Render()
{
	 g_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(255,255,255), 1.0f, 0 );

    // Begin the scene
    g_pd3dDevice->BeginScene();

	D3DXMATRIX matWorld,matWorld1;
    D3DXMatrixIdentity( &matWorld);

    g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );


	// change the camera based on user input
	AdjustCameraPosition();


	D3DXMATRIX matrixView;
	D3DXMatrixLookAtLH( &matrixView, 
						&Camera.Eye,	// Current camera position
                       	&Camera.At ,	// Look at position
						&Camera.Orientation) ;// Orientation 

	g_pd3dDevice->SetTransform( D3DTS_VIEW, &matrixView );


    // For the projection matrix, we set up a perspective transform (which
    // transforms geometry from 3D view space to 2D viewport space, with
    // a perspective divide making objects smaller in the distance). To build
    // a perpsective transform, we need the field of view (1/4 pi is common),
    // the aspect ratio, and the near and far clipping planes (which define at
    // what distances geometry should be no longer be rendered).
    D3DXMATRIX matProj;
    D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, 1.0f, 0.1f, 600.0f );
    g_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );

    g_pd3dDevice->SetStreamSource( 0, g_pBackgroundVB, sizeof(TEXTUREDVERTEXSTRUCT) );
	g_pd3dDevice->SetVertexShader( TEXTUREDVERTEX );

    g_pd3dDevice->SetTexture(0,m_pTexture1);	// No Texture

//	g_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);	// Wireframe for dubugging
    g_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);

	// Turn off culling, so we see the front and back of the triangle
    g_pd3dDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );

    // Turn off D3D lighting, since we are providing our own vertex colors
    g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
	g_pd3dDevice->SetRenderState( D3DRS_SPECULARENABLE, FALSE);

	g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
	g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_TEXTURE );
	g_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );

	g_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLOROP,   D3DTOP_DISABLE    );
	
	g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, TRUE);	// Enable Z buffering

	// Draw the Triangles
//	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2);

	LINEVERTEX* pVertices; // pointer for traversal of VB

	// now draw the octgrid (debugging)
	if (MainOctTree != NULL)
	{
		if( SUCCEEDED( g_pOctGrid->Lock(0, 0, (BYTE**)&pVertices, 0 ) ) )
		{
			int VertexCount = 0;
			MainOctTree->DebugRenderOctGrid(pVertices,VertexCount);

			g_pOctGrid->Unlock();

			g_pd3dDevice->SetTexture(0,NULL);

		//	g_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);
			g_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);
		//	g_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_POINT);

			g_pd3dDevice->SetStreamSource( 0, g_pOctGrid, sizeof(LINEVERTEX) );
			g_pd3dDevice->SetVertexShader( LINEVERTEX_TYPE ); 

			g_pd3dDevice->SetRenderState( D3DRS_AMBIENT, 0xffffffff);
			g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
			
			g_pd3dDevice->DrawPrimitive( D3DPT_LINELIST, 0, VertexCount);

		}

			SetLights();

		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_ADD );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
	//	g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE  );
		g_pd3dDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );
	/*	g_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLOROP,    D3DTOP_ADDSMOOTH     );
		g_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_CURRENT   );
		g_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_SPECULAR );
		g_pd3dDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );*/

		g_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLOROP,     D3DTOP_MODULATE4X          );
		g_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_CURRENT   );
		g_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_TEXTURE  );
		g_pd3dDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );


		theVTManager.RenderObjects(g_pd3dDevice);		
	
		
	}

	RenderObjects();

	RenderStats();

//	g_DebugSphere->DrawSubset(0);

    // End the scene
    g_pd3dDevice->EndScene();

    // Present the backbuffer contents to the display
    g_pd3dDevice->Present( NULL, NULL, NULL, NULL );


}

void R3DWindow::LoadWindowEffects()
{

    // Create the texture using D3DX
    D3DXCreateTextureFromFileEx( g_pd3dDevice, "textures\\3dwindow.bmp", 
                D3DX_DEFAULT, D3DX_DEFAULT, D3DX_DEFAULT, 0, D3DFMT_R5G6B5, 
                D3DPOOL_MANAGED, D3DX_FILTER_TRIANGLE|D3DX_FILTER_MIRROR, 
                D3DX_FILTER_TRIANGLE|D3DX_FILTER_MIRROR, 0, NULL, NULL, &m_pTexture1 );

	if( FAILED( g_pd3dDevice->CreateVertexBuffer( 6*sizeof(TEXTUREDVERTEXSTRUCT),
                                                  0, TEXTUREDVERTEX,
                                                  D3DPOOL_DEFAULT, &g_pBackgroundVB ) ) )
    {
		AfxMessageBox("CriticalFailure 1");
        return;
    }

    // Fill the vertex buffer.
    TEXTUREDVERTEXSTRUCT* pVertices;

    if( FAILED( g_pBackgroundVB->Lock( 0, sizeof(TEXTUREDVERTEXSTRUCT)*6, (BYTE**)&pVertices, 0 ) ) )
	{
		AfxMessageBox("CriticalFailure 2");
        return;
	}

	// form a nice box

	float Size = 50.0;
	float Offset = 50.0;

	pVertices[0].x = 50.0 + Offset;
	pVertices[0].y = 0.0f;
	pVertices[0].z = 50.0 + Offset;
	pVertices[0].color = 0xffffffff;
	pVertices[0].tu = 1.0f;
	pVertices[0].tv = 0.0f;

	pVertices[1].x = -50.0 + Offset;
	pVertices[1].y = 0.0f;
	pVertices[1].z = 50.0 + Offset;
	pVertices[1].color = 0xffffffff;
	pVertices[1].tu = 0.0f;
	pVertices[1].tv = 0.0f;

	pVertices[2].x = -50.0 + Offset;
	pVertices[2].y = 0.0f;
	pVertices[2].z = -50.0 + Offset;
	pVertices[2].color = 0xffffffff;
	pVertices[2].tu = 0.0f;
	pVertices[2].tv = 1.0f;

	pVertices[3].x = 50.0 + Offset;
	pVertices[3].y = 0.0f;
	pVertices[3].z = 50.0 + Offset;
	pVertices[3].color = 0xffffffff;
	pVertices[3].tu = 1.0f;
	pVertices[3].tv = 0.0f;

	pVertices[4].x =-50.0 + Offset;
	pVertices[4].y = 0.0f;
	pVertices[4].z = -50.0 + Offset;
	pVertices[4].color = 0xffffffff;
	pVertices[4].tu = 0.0f;
	pVertices[4].tv = 1.0f;

	pVertices[5].x = 50.0 + Offset;
	pVertices[5].y = 0.0f;
	pVertices[5].z = -50.0 + Offset;
	pVertices[5].color = 0xffffffff;
	pVertices[5].tu = 1.0f;
	pVertices[5].tv = 1.0f;

       
    
    g_pBackgroundVB->Unlock();
/*
	    // Initialize three vertices for rendering a triangle
    CUSTOMVERTEX g_Vertices[] =
    {
        { -1.0f,-1.0f, 0.0f, 0xffff0000, },
        {  1.0f,-1.0f, 0.0f, 0xff0000ff, },
        {  0.0f, 1.0f, 0.0f, 0xffffffff, },
    };

    // Create the vertex buffer.
    if( FAILED( g_pd3dDevice->CreateVertexBuffer( 3*sizeof(CUSTOMVERTEX),
                                                  0, D3DFVF_CUSTOMVERTEX,
                                                  D3DPOOL_DEFAULT, &g_pBackgroundVB ) ) )
    {
		AfxMessageBox("Critical Error 3");
        return ;
    }

    // Fill the vertex buffer.
    VOID* pVertices;
    if( FAILED( g_pBackgroundVB->Lock( 0, sizeof(g_Vertices), (BYTE**)&pVertices, 0 ) ) )
	{
		AfxMessageBox("Critical Error 4");
        return ;
	}
    memcpy( pVertices, g_Vertices, sizeof(g_Vertices) );
    g_pBackgroundVB->Unlock();*/

}


//==============================================================
// Message Handler area
//
// These functions change setting based on user input
//
//==============================================================
void R3DWindow::OnMouseMove(UINT nFlags, CPoint Point)
{

	float AngleRatio = 0.3f;

    if (MK_CONTROL & nFlags)
	{

		if (nFlags & MK_LBUTTON) // left mouse button down, perform rotation
		{
			float DeltaX = (float)(Camera.OldMousePoint.x - Point.x);
			float DeltaY = (float)(Camera.OldMousePoint.y - Point.y);
                        
			Camera.XAngle += DeltaY*AngleRatio;
			Camera.ZAngle += DeltaX*AngleRatio;        
		
			if (Camera.XAngle < 0)
				Camera.XAngle = 0;
			if (Camera.XAngle > 89)
				Camera.XAngle = 89;
		}
		else if (nFlags & MK_RBUTTON) // right mouse button down, perform pan
		{
			Camera.PanX = Camera.OldMousePoint.x - Point.x;
			Camera.PanY = Camera.OldMousePoint.y - Point.y;
		}
		else if (nFlags & MK_MBUTTON) // middle mouse button, perform zoom
		{
			Camera.ZoomIn = (float)(Camera.OldMousePoint.y - Point.y);
		}
	}

    Camera.OldMousePoint = Point;

}

void R3DWindow::OnLButtonDown(UINT nFlags, CPoint point)
{
	//Camera.OldMousePoint = point
	if (!(MK_CONTROL & nFlags))
	{
		Point3 Org,Dir;
		GetPickRay(point.x,point.y,Org,Dir);
		MainOctTree->DebugGetObject(Org,Dir);
	}


}

void R3DWindow::OnMButtonDown(UINT nFlags, CPoint point)
{
	//Camera.OldMousePoint = point;

}

void R3DWindow::OnRButtonDown(UINT nFlags, CPoint point)
{
	//Camera.OldMousePoint = point;

}

//==============================================================
// bool IsClient(CPoint Point)
//
// This function returns true if the point is in the current render window
//
//==============================================================
bool R3DWindow::IsClient(CPoint Point)
{
	if (WindowPos.left <= Point.x && WindowPos.right >= Point.x)
		if (WindowPos.top <= Point.y && WindowPos.bottom >= Point.y)
			return true;

	return false;
}

//==============================================================
// AdjustCameraPosition()
//
// This function is called during a rendering run to adjust the camera
// position based on where the new camera position user based on user 
// input.
//
//==============================================================
void R3DWindow::AdjustCameraPosition()
{
	float Movement = 0.1f; // constant to change movement speed


	float dx,dy,dz;		

	// check if there is any new mouse input to move the camera
	if (Camera.PanX != 0)
	{
		if (Camera.PanX < 0)
		{
			// pan right
			AdjustCameraPosition(dx,dy,dz,Camera.XAngle,Camera.ZAngle+90,Movement*Camera.PanX);

			float adx = dx;
			if (dx < 0)
				adx = -dx;

			float adz = dz;
			if (dz < 0)
				adz = -dz;

			float NSum = adx + adz;

			dx = dx/NSum*Movement*Camera.PanX;
			dz = dz/NSum*Movement*Camera.PanX;
		}
		else
		{
			// pan left
			AdjustCameraPosition(dx,dy,dz,Camera.XAngle,Camera.ZAngle-90,-Movement*Camera.PanX);		  

			float adx = dx;
			if (dx < 0)
				adx = -dx;

			float adz = dz;
			if (dz < 0)
				adz = -dz;

			float NSum = adx + adz;
			dx = dx/NSum*Movement*-Camera.PanX;
			dz = dz/NSum*Movement*-Camera.PanX;

		}	
	
		Camera.At.x += dx;
		Camera.At.z += dz;
		Camera.PanX = 0;
	}
	if (Camera.PanY != 0)
	{
		if (Camera.PanY < 0)
		{
			// pan up
			AdjustCameraPosition(dx,dy,dz,Camera.XAngle+90,Camera.ZAngle,-Movement*Camera.PanY);

		}
		else
		{
			// pan down
			AdjustCameraPosition(dx,dy,dz,Camera.XAngle-90,Camera.ZAngle,Movement*Camera.PanY);		  
		}
		Camera.At.x += dx;
		Camera.At.z += dz; 
		Camera.At.y += dy;
		Camera.PanY = 0;
	}
	if (Camera.ZoomIn != 0)
	{
		if (Camera.ZoomIn < 0)
		{
			// zoom out
			AdjustCameraPosition(dx,dy,dz,Camera.XAngle,Camera.ZAngle,Movement*15);
			Camera.At.x += dx;
			Camera.At.y += dy;
			Camera.At.z += dz; 
		}	   
		else 
		{
			// zoom in
			AdjustCameraPosition(dx,dy,dz,Camera.XAngle,Camera.ZAngle,Movement*15);
			Camera.At.x -= dx;
			Camera.At.y -= dy;
			Camera.At.z -= dz; 
		}
		Camera.ZoomIn = 0;
	}


    Camera.Eye = Camera.At;		

	AdjustCameraPosition(dx,dy,dz,Camera.XAngle,Camera.ZAngle,15);

	// adjust eye position
    Camera.Eye.x = Camera.At.x + dx;
    Camera.Eye.y = Camera.At.y + dy;
    Camera.Eye.z = Camera.At.z + dz;	

}


//==============================================================
// AdjustCameraPosition(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius)
//
// This function is a helper function which chooses the dx dy dz from a point based on 
// two angles and a radius
//==============================================================
void R3DWindow::AdjustCameraPosition(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius)
{
	// new way
    // first resolve the y and z coordinate and then backtrack to resolve the x coordinate
    dy = Radius*(float)sin(AngleX*PI/180);
    dz = Radius*(float)cos(AngleX*PI/180);    
    
    // o.k resolve dz and dx using the old dx as the radius
    Radius = dz;
    dx = Radius*(float)sin(AngleY*PI/180);
    dz = Radius*(float)cos(AngleY*PI/180);
 
}

//==============================================================
// RCResetView()
//
// Resets the view of the screen
//==============================================================
void R3DWindow::RCResetView()
{
	Camera.Eye = D3DXVECTOR3(50,150,50);
	Camera.At = D3DXVECTOR3(50,100,50);
	Camera.Orientation = D3DXVECTOR3(0,1,0); // y is up (most of the time)

	renderIntersection = 0;

    Camera.XAngle =  90;
    Camera.ZAngle = 90;

	Camera.PanX = 0;
	Camera.PanY = 0;
	Camera.ZoomIn = 0;

}

void R3DWindow::SetLights()
{
	g_pd3dDevice->SetRenderState( D3DRS_LOCALVIEWER, TRUE);


	D3DLIGHT8 DiffuseLight;

	// Initialize the structure.
	ZeroMemory(&DiffuseLight, sizeof(D3DLIGHT8));

	// Set up a white point light.
	DiffuseLight.Type = D3DLIGHT_POINT ;
	DiffuseLight.Diffuse.r  = 0.7f;
	DiffuseLight.Diffuse.g  = 0.7f;
	DiffuseLight.Diffuse.b  = 0.7f;
	DiffuseLight.Ambient.r  = 0.0f;
	DiffuseLight.Ambient.g  = 0.0f;
	DiffuseLight.Ambient.b  = 0.0f;
	DiffuseLight.Specular.r = 0.0f;
	DiffuseLight.Specular.g = 0.0f;
	DiffuseLight.Specular.b = 0.0f;

	//put it in the middle for now
	DiffuseLight.Position.x = 50.0f;
	DiffuseLight.Position.y = 50.0f;
	DiffuseLight.Position.z = 50.0f;

	// The smaller the numbers the less the attenuation
	DiffuseLight.Attenuation0 = 1.0f; 
	DiffuseLight.Attenuation1 = 0.0f; 
	DiffuseLight.Attenuation2 = 0.0f; 

	DiffuseLight.Range      = 80.0f;

	// make the material for the specular light
	D3DMATERIAL8 mtrl;
	ZeroMemory( &mtrl, sizeof(mtrl) );

	D3DLIGHT8 SpecularLight;
	ZeroMemory( &SpecularLight, sizeof(SpecularLight) );
	SpecularLight.Type = D3DLIGHT_DIRECTIONAL;

	D3DXVECTOR3 vecDir;
	vecDir = D3DXVECTOR3(-1.0f, 0.0f, 1.0f);
	D3DXVec3Normalize( (D3DXVECTOR3*)&SpecularLight.Direction, &vecDir );

	SpecularLight.Specular.r = 1.0f;
	SpecularLight.Specular.g = 1.0f;
	SpecularLight.Specular.b = 1.0f;
	SpecularLight.Specular.a =1.0f;

	SpecularLight.Range = 1000;
	SpecularLight.Falloff = 0;
	SpecularLight.Attenuation0 = 1;
	SpecularLight.Attenuation1 = 0;
	SpecularLight.Attenuation2 = 0;
//	g_pd3dDevice->SetRenderState( D3DRS_SPECULARENABLE, TRUE );
g_pd3dDevice->SetRenderState( D3DRS_SPECULARENABLE, FALSE );
	mtrl.Specular.r = 1.0f;
	mtrl.Specular.g = 1.0f;
	mtrl.Specular.b = 1.0f;
	mtrl.Specular.a = 1.0f;
	mtrl.Diffuse.r = 1.0f;
	mtrl.Diffuse.g = 1.0f;
	mtrl.Diffuse.b = 1.0f;
	mtrl.Diffuse.a = 1.0f;
	mtrl.Ambient.r = 1.0f;
	mtrl.Ambient.g = 1.0f;
	mtrl.Ambient.b = 1.0f;
	mtrl.Ambient.a = 1.0f;
	mtrl.Power = 20;
	g_pd3dDevice->SetMaterial( &mtrl );
	g_pd3dDevice->SetRenderState(D3DRS_SPECULARMATERIALSOURCE, D3DMCS_MATERIAL);

	// set some ambient light
	g_pd3dDevice->SetRenderState( D3DRS_AMBIENT, 0xff100000);


	//g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, TRUE );
	// Set the property information for the first light.
	g_pd3dDevice->SetLight(0, &DiffuseLight);
	g_pd3dDevice->LightEnable( 0, TRUE);
	g_pd3dDevice->SetLight(1, &SpecularLight);
	g_pd3dDevice->LightEnable( 1, TRUE);
}

// get the pick ray based on cursor position
// copyied from directX don't actually know exactly how it works though
void R3DWindow::GetPickRay(int x, int y, Point3 &vPickRayOrig, Point3 &vPickRayDir)
{
	D3DXMATRIX matProj;
    g_pd3dDevice->GetTransform( D3DTS_PROJECTION, &matProj );
	int Width = 600;
	int Hieght = 600;


    // Compute the vector of the pick ray in screen space
    D3DXVECTOR3 v;
    v.x =  ( ( ( 2.0f * x ) / Width  ) - 1 ) / matProj._11;
    v.y = -( ( ( 2.0f * y ) / Hieght ) - 1 ) / matProj._22;
    v.z =  1.0f;

    // Get the inverse view matrix
    D3DXMATRIX matView, m;
    g_pd3dDevice->GetTransform( D3DTS_VIEW, &matView );
    D3DXMatrixInverse( &m, NULL, &matView );

    // Transform the screen space pick ray into 3D space
    vPickRayDir.x  = v.x*m._11 + v.y*m._21 + v.z*m._31;
    vPickRayDir.y  = v.x*m._12 + v.y*m._22 + v.z*m._32;
    vPickRayDir.z  = v.x*m._13 + v.y*m._23 + v.z*m._33;
    vPickRayOrig.x = m._41;
    vPickRayOrig.y = m._42;
    vPickRayOrig.z = m._43;
}

void R3DWindow::RenderStats()
{



	if (renderIntersection == true)
	{
		Sphere tempo;
		tempo.m_Center = collisionPoint;
		tempo.m_Radius = 2.0;
		renderBoundingSphere(tempo,0xffffff00);
	}




	CChildView *tWnd = (CChildView *)(viewWindow);
	int simCount = tWnd->simThreadInfo.actualSimsperQuanta;
	char tempo[100];
	sprintf(tempo,"Sims per Second %d",simCount);
	RECT df;
	df.top = 10;
	df.left = 10;
	df.bottom = 100;
	df.right = 200;
	
	m_pFont->DrawText( 2,  0, D3DCOLOR_ARGB(255,255,0,0), tempo );

	// k render the profiler data here
	int count = 0;
	int offset = 50;
	int spacing = 15;
	while(theProfiler.enumProfiler(tempo))
	{
		m_pFont->DrawText( 0,offset + count*spacing,   D3DCOLOR_ARGB(255,255,0,0), tempo );
		count++;
	}
	m_pFont->DrawText( 0,  offset + count*spacing, D3DCOLOR_ARGB(255,255,0,0), tempo );

}

void R3DWindow::RenderObjects()
{
	Sphere *bSphere;
	Sphere renderSphere;
	DynamicObject *tObject;

	theDOManager.enumStart();

	bool renderBSphere = true;
	while (theDOManager.enumObjects(tObject))
	{
		tObject->DirectXRender(g_pd3dDevice);
		if (renderBSphere)
		{
			bSphere = tObject->GetBoundingSphere();
			renderSphere.m_Center = bSphere->m_Center + tObject->currLocation;
			renderSphere.m_Radius = bSphere->GetRadius();
			// now transform it then render it
			renderBoundingSphere(renderSphere,0xffff0000);
		}

	}

}
