// R3DWindow.h: interface for the R3DWindow class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_R3DWINDOW_H__5872A11E_374B_44B3_A882_297A75CEC262__INCLUDED_)
#define AFX_R3DWINDOW_H__5872A11E_374B_44B3_A882_297A75CEC262__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//directx includes
#include <d3dx8.h>
#include <mmsystem.h>
#include "VTManager.h"
#include "D3DFont.h"

#include "OctTree.h"
#include "DynamicObject.h"
#include "DynamicObjectManager.h"

class R3DWindow  
{
public:
	void RenderObjects();
	CWnd *viewWindow;
	void RenderStats();
	void GetPickRay(int x, int y, Point3 &vPickRayOrig , Point3 &vPickRayDir);
	void SetLights();
	void RCResetView();
	void AdjustCameraPosition(float &dx, float &dy, float &dz, float AngleX, float AngleY, float Radius);
	void AdjustCameraPosition();

	struct Camera1
	{
		CPoint OldMousePoint;
	//	bool LeftButtonDown;
	//	bool MiddleButtonDown;
	//	bool RightButtonDown;
		float XAngle;
		float ZAngle;
	public:
		float ZoomIn;
		long PanY;
		long PanX;

		D3DXVECTOR3 Eye;
		D3DXVECTOR3 At;
		D3DXVECTOR3 Orientation;
	} Camera;
		

	CRect WindowPos;
	bool IsClient(CPoint Point);
	void OnRButtonDown(UINT nFlags, CPoint point);
	void OnMButtonDown(UINT nFlags, CPoint point);
	void OnLButtonDown(UINT nFlags, CPoint point);
	void OnMouseMove(UINT nFlags, CPoint point);
	void LoadWindowEffects();
	void Render();
	void Init(CWnd *Parent, CRect WindowPos);
	R3DWindow();
	virtual ~R3DWindow();

	inline void renderBoundingSphere(Sphere &bSphere, DWORD color)
	{
		D3DXMATRIX matWorld,matSR,scaling,translation;
		D3DXMatrixIdentity( &matWorld);

		g_pd3dDevice->SetRenderState( D3DRS_AMBIENT, color);
		g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, TRUE );
	
		g_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);
		D3DXMatrixTranslation(&translation,bSphere.GetCenterX(),bSphere.GetCenterY(),bSphere.GetCenterZ());
		D3DXMatrixScaling(&scaling,bSphere.GetRadius(),bSphere.GetRadius(),bSphere.GetRadius());
		matSR = scaling*translation;
		g_pd3dDevice->SetTransform( D3DTS_WORLD, &matSR );
		g_DebugSphere->DrawSubset(0);
		g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );
		g_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);
		g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
	}
		

	OctTree *MainOctTree;

	CWnd FrameWindow; // the frame window
	CWnd *Parent;

	LPDIRECT3D8             g_pD3D; // Used to create the D3DDevice
	LPDIRECT3DDEVICE8       g_pd3dDevice; // Our rendering device
	LPDIRECT3DVERTEXBUFFER8 g_pBackgroundVB; // Buffer to hold vertices
	LPDIRECT3DVERTEXBUFFER8 g_pOctGrid; // to draw the octgrid used mostly for debugging
	LPDIRECT3DTEXTURE8 m_pTexture1;
	LPD3DXMESH g_DebugSphere;

	CD3DFont*     m_pFont;   // font used for drawing text

	Point3 collisionPoint;
	bool renderIntersection;

	DynamicObject *car1;



};

extern R3DWindow theR3DWindow; // global reference

#endif // !defined(AFX_R3DWINDOW_H__5872A11E_374B_44B3_A882_297A75CEC262__INCLUDED_)
