// VTManager.cpp: implementation of the VTManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "simulator.h"
#include "VTManager.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VTManager theVTManager;// global reference

VTManager::VTManager()
{
	lightMapIndex = 0;
	for (int ix = 0; ix < MAXTEXTURES; ix++)
	{
		m_pTextures[ix] = NULL;
	}
	currLightMapIndex = 0;

}

VTManager::~VTManager()
{
	for (int ix = 0; ix < MAXTEXTURES; ix++)
	{
		if (m_pTextures[ix] != NULL)
			 m_pTextures[ix]->Release();
	}

	if( g_BoxVB != NULL )
        g_BoxVB->Release();


}

//////////////////////////////////////////////////////////////////////
// AddTriangleList(int TextureNum, Point3 v1, Point3 v2, Point3 v3)
//
// Usage:
//   To add an object that has a texture to the rendering manager
//
//////////////////////////////////////////////////////////////////////
void VTManager::AddTriangleList(int TextureNum, BaseObject &theObject)
{
	TextureList[TextureNum].TriangleList.push_back(&theObject);
}

// temp so far
void VTManager::RenderList(TLNVERTEXSTRUCT *&pVertex, int &VertexCount)
{
		// render the objects here
	int LightMapCount = 0;
	int *pLightmap = lightMapArray;
	for (int ix = 0; ix < 2; ix++)
	{
		BaseObjectList::iterator curr = TextureList[ix].TriangleList.begin();
		BaseObjectList::iterator end = TextureList[ix].TriangleList.end();
		
		while (curr != end)
		{
			(*curr)->DirectXRender(pVertex,VertexCount,pLightmap,LightMapCount);
			curr++;
		} 
		TextureList[ix].TriangleList.clear();
		TextureSwap[ix] = VertexCount;
	}

}

void VTManager::InitLightMaps(LPDIRECT3DDEVICE8 g_pd3dDevice)
{

  this->g_pd3dDevice = g_pd3dDevice; // copy it over for texture creation later

  D3DLOCKED_RECT LockedRect;
  RECT Rect;

  Rect.top = 0;
  Rect.bottom = 63;
  Rect.left = 0;
  Rect.right = 63;

  int Height = 256;
  int Width = 256;

	for (int ix = 0; ix < 10; ix++)
	{
		LightMapList[ix].ppLightMap = NULL;
		if (FAILED(g_pd3dDevice->CreateTexture(Height,Width,1,0
			,D3DFMT_X8R8G8B8   , D3DPOOL_MANAGED,&(LightMapList[ix].ppLightMap))))
		{
			AfxMessageBox("Cannot create lightmap texture");
			return;
		}
		int level = LightMapList[ix].ppLightMap->GetLevelCount();

		if (!FAILED(LightMapList[ix].ppLightMap->LockRect(0,&LockedRect,NULL,D3DLOCK_NOSYSLOCK  )))
		{

			// now edit the lightmap
			int *pBitMap;
			pBitMap = (int *)(LockedRect.pBits);
			for (int iy = 0; iy < Height; iy++)
			{
				for (int iz = 0; iz < Width; iz++)
				{
				/*	if ((iz/2)*2 == iz)
						*pBitMap = (short)(0x0000);//iy*iz;//1000-iy*iz;
					else*/
						//*pBitMap = (int)(iz*iy*2);//iy*iz;//1000-iy*iz;
					*pBitMap = (int)(0xff00ff00 | iz | iz << 8 | iz << 16);//iz*iy*2);
					pBitMap++;
				
				}
				pBitMap = (int *)(LockedRect.pBits) + LockedRect.Pitch*(iy)/4;
			}
 
			LightMapList[ix].ppLightMap->UnlockRect(0);
		}


	}
}

// gets the texture in the same order as triangle information is stored


void VTManager::InitTextures(LPDIRECT3DDEVICE8 g_pd3dDevice)
{

	if( FAILED( g_pd3dDevice->CreateVertexBuffer( 100000*sizeof(TLNVERTEXSTRUCT),
												   D3DUSAGE_DYNAMIC ,
												   TLNVERTEX,
												   D3DPOOL_DEFAULT,
												   &g_BoxVB 
												   ) )) 
         
												   AfxMessageBox("Failed octgrid Vertex Buffer");


	  D3DXCreateTextureFromFileEx( g_pd3dDevice, "textures\\3dwindow.bmp", 
                D3DX_DEFAULT, D3DX_DEFAULT, D3DX_DEFAULT, 0, D3DFMT_R5G6B5, 
                D3DPOOL_MANAGED, D3DX_FILTER_TRIANGLE|D3DX_FILTER_MIRROR, 
                D3DX_FILTER_TRIANGLE|D3DX_FILTER_MIRROR, 0, NULL, NULL, &m_pTextures[0] );

	  D3DXCreateTextureFromFileEx( g_pd3dDevice, "textures\\globe.bmp", 
                D3DX_DEFAULT, D3DX_DEFAULT, D3DX_DEFAULT, 0, D3DFMT_R5G6B5, 
                D3DPOOL_MANAGED, D3DX_FILTER_TRIANGLE|D3DX_FILTER_MIRROR, 
                D3DX_FILTER_TRIANGLE|D3DX_FILTER_MIRROR, 0, NULL, NULL, &m_pTextures[1] );



}

void VTManager::RenderObjects(LPDIRECT3DDEVICE8 g_pd3dDevice)
{
		TLNVERTEXSTRUCT* pVertices1;
		// render objects now
		if( SUCCEEDED( g_BoxVB->Lock(0, 0, (BYTE**)&pVertices1, 0 ) ) )
		{
			int VertexCount = 0;
			// first fill the vertex buffer
			RenderList(pVertices1,VertexCount);

			g_BoxVB->Unlock();

			// now do texture swapping as neccessary					  
			g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);						
			g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, TRUE);	// Enable Z buffering
		//	g_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);
			g_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);
		//	g_pd3dDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_POINT);

			g_pd3dDevice->SetStreamSource( 0, g_BoxVB, sizeof(TLNVERTEXSTRUCT) );
			g_pd3dDevice->SetVertexShader( TLNVERTEX ); 

			// render each of the texture lists
			int PrevStart = 0;
			int prevLightMapIndex = 0;
			int *pLightmap = lightMapArray;
			int lindex = 0;
			for (int ix = 0; ix < VertexCount/2; ix++)
			{
				g_pd3dDevice->SetTextureStageState(0,D3DTSS_MAGFILTER ,D3DTEXF_LINEAR);
				g_pd3dDevice->SetTextureStageState(1,D3DTSS_MAGFILTER ,D3DTEXF_LINEAR);
				 
				g_pd3dDevice->SetTexture(1,m_pTextures[1]);
				int index = *pLightmap;
				g_pd3dDevice->SetTexture(0,theVTManager.LightMapList[*pLightmap].ppLightMap);
				lindex += 2;
				pLightmap += 2;
				g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, PrevStart*3, 2);	
				PrevStart += 2;
			}


		/*	for (int ix = 0; ix < 2; ix++)
			{
			//	g_pd3dDevice->SetTexture(1,m_pTextures[ix]);
				g_pd3dDevice->SetTexture(0,theVTManager.LightMapList[0].ppLightMap);

				if (PrevStart != TextureSwap[ix])
					g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, PrevStart*3, TextureSwap[ix] - PrevStart);
			//	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 24*3, 12);				

				PrevStart = TextureSwap[ix];

			}*/

		

			// now do texture swapping as we go though the vertex buffer
			int CurrTexture = 0;


			
			

		}

}

// gets a lightmap texture if available
bool VTManager::GetLightMapTexture(int height, int width, LPDIRECT3DTEXTURE8 &ppLightMap, int &textureID)
{
	 D3DLOCKED_RECT LockedRect;


	LightMapList[currLightMapIndex].ppLightMap = NULL;
	if (FAILED(g_pd3dDevice->CreateTexture(height,width,1,0
		,D3DFMT_X8R8G8B8   , D3DPOOL_MANAGED,&(LightMapList[currLightMapIndex].ppLightMap))))
	{
		AfxMessageBox("Cannot create lightmap texture");
		return false;
	}
	int level = LightMapList[currLightMapIndex].ppLightMap->GetLevelCount();

	ppLightMap = LightMapList[currLightMapIndex].ppLightMap;

	if (!FAILED(LightMapList[currLightMapIndex].ppLightMap->LockRect(0,&LockedRect,NULL,D3DLOCK_NOSYSLOCK  )))
	{

		// now init the lightmap to 0
		int *pBitMap;
		pBitMap = (int *)(LockedRect.pBits);
		textureID = currLightMapIndex;
		for (int iy = 0; iy < height; iy++)
		{
			for (int iz = 0; iz < width; iz++)
			{
			/*	if ((iz/2)*2 == iz)
					*pBitMap = (short)(0x0000);//iy*iz;//1000-iy*iz;
				else*/
					//*pBitMap = (int)(iz*iy*2);//iy*iz;//1000-iy*iz;
				*pBitMap = (int)(0xffff0000);
				pBitMap++;
			
			}
			pBitMap = (int *)(LockedRect.pBits) + LockedRect.Pitch*(iy)/4;
		}

		LightMapList[currLightMapIndex].ppLightMap->UnlockRect(0);
	}
	currLightMapIndex++;
	return true;

}
