// ChildView.h : interface of the CChildView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHILDVIEW_H__9E5D78BD_70D6_4DA9_AEFE_9D0778D2C99E__INCLUDED_)
#define AFX_CHILDVIEW_H__9E5D78BD_70D6_4DA9_AEFE_9D0778D2C99E__INCLUDED_

#include "ScrollView.h"	// Added by ClassView
#include "UMath.h"	// Added by ClassView
#include "MDirectX.h"	// Added by ClassView
#include "OctTree.h"	// Added by ClassView

// dialog boxes
#include "OctGridOptions.h"
#include "NewOctTree.h"
#include "uIDList.h"
#include "ViewManager.h"	// Added by ClassView
#include "TerrainManager.h"	// Added by ClassView
#include "TerrainOptions.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CChildView window

class CChildView : public CWnd
{
// Construction
public:
	CChildView();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChildView)
	public:
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	CMenu Popup; // popup menu for editing

	void ResetOptions();
	CWnd* FramePtr;
	virtual ~CChildView();

	struct OPTIONS
    {
        BOOL E_ZoomEnabled;
        int CurrCursor;
	};

	// edit area
	struct ObjectEditView
	{
		CRect EditArea;
		CRect StatsArea;
		CRect ViewSize;
		float DrawTime;
		float RenderingTime;
		LARGE_INTEGER StartDrawTime; 
		LARGE_INTEGER EndDrawTime; 
		LARGE_INTEGER Frequency;
		ScrollView *ScrollViewPtr;
		int StatsPercent;
	} EditView;

	// for debug purposes to see the total draw time
	inline SSDT(LARGE_INTEGER StartDrawTime)
	{
		// calculate the actual draw time
		EditView.DrawTime 
			=   (float)(EditView.EndDrawTime.QuadPart-EditView.StartDrawTime.QuadPart)/(float)EditView.Frequency.QuadPart;							
		this->EditView.StartDrawTime = StartDrawTime;	
	}

	inline SEDT(LARGE_INTEGER EndDrawTime)
	{
		if (EndDrawTime.QuadPart > this->EditView.EndDrawTime.QuadPart)
		{
			this->EditView.EndDrawTime = EndDrawTime;
		}
	}

	OPTIONS Options;

public:
	void SetStatsPercent(int Percent);
	void Redraw();
	CRect GetEditViewWindow();
	void PaintStatsArea(CDC &dc);

	ViewManager TheViewManager;

	// Generated message map functions
protected:
	//{{AFX_MSG(CChildView)
	afx_msg void OnPaint();
	afx_msg void OnCamerasettingsResetview();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnOptionsOctgridoptions();
	afx_msg void OnOcttreeNewocttree();
	afx_msg void OnEditGroup();
	afx_msg void OnEditUngroup();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnToggle4view();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnTerrainoptionsGeneratenewterrain();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

extern CChildView *theViewPtr; 
CChildView *GetViewPtr(void);


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHILDVIEW_H__9E5D78BD_70D6_4DA9_AEFE_9D0778D2C99E__INCLUDED_)
