// GroupStruct.cpp: implementation of the GroupStruct class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MapEditor.h"
#include "GroupStruct.h"
#include "uIDList.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

GroupStruct::GroupStruct()
{
	Child = NULL;
	Parent = NULL;
	Sibling = NULL;
	theObject = NULL;
	NumofObjects = 1;
	HierarchyLevel = 1;
	GroupType = GroupNonSeperable;

	GroupNumber = GroupIDList.GetNewID();

}

GroupStruct::~GroupStruct()
{
	OnDestroy(); // nuke any group hierachy
//	GroupIDList.AddBackID(GroupNumber); // don't bother
}


GroupStruct::GroupStruct(StdObjectPtr TheObject)
{
	Child = NULL;
	Parent = NULL;
	Sibling = NULL;
	theObject = TheObject;
	NumofObjects = 1;
	HierarchyLevel = 1;
	GroupNumber = GroupIDList.GetNewID();

	GroupType = GroupNonSeperable;
}

//---------------------------------------------------------------------
// OnSelect(const BOOL &toSelect)
// 
// Usage: Called to select the entire group, not just the object selected
//
// Input BOOL toSelect, if true causes the entire group to be selected,
//				        Otherwise deselect the group
//
// Returns the highest level group ptr for that structure
//---------------------------------------------------------------------
GroupStruct* GroupStruct::OnSelect(const BOOL &toSelect)
{
	GroupPtr tGroupPtr;
 	if (Parent != NULL)
	{
		// get the top level group pointer avialable
		tGroupPtr = Parent;
		while (Parent->Parent != NULL)
		{
			Parent = Parent->Parent;
		}
		// O.K now go downward the heirarchy and select everything
		OnSelect1(tGroupPtr,toSelect);
		return Parent;
	}
	else
	{
		// No heriarchy but might as well resuse this function call
		OnSelect1(this,toSelect);
		return this;
	}
	
}

//---------------------------------------------------------------------
// OnSelect(OnSelect1(GroupPtr tGroupPtr, const BOOL &toSelect))
// 
// Usage: Reccursive call for OnSelect(), does all the real work
//---------------------------------------------------------------------
void GroupStruct::OnSelect1(GroupPtr tGroupPtr, const BOOL &toSelect)
{
	if (tGroupPtr->Child != NULL)
	{
		OnSelect1(tGroupPtr->Child,toSelect);
	}
	if (tGroupPtr->Sibling != NULL)
	{
		OnSelect1(tGroupPtr->Sibling,toSelect);
	}

	if (tGroupPtr->GroupType == GroupNonSeperable)
	{
		if (toSelect)
			tGroupPtr->theObject->OnSelect();
		else
			tGroupPtr->theObject->OnDeselect();

	}
}

//---------------------------------------------------------------------
// OnDestroy()
// 
// Usage: Called in the destructer to nuke any group hierarchy pointers
//---------------------------------------------------------------------
void GroupStruct::OnDestroy()
{
	GroupPtr tGroupPtr;
	if (Parent != NULL)
	{
		// get the top level group pointer avialable
		tGroupPtr = Parent;
		while (tGroupPtr->Parent != NULL)
		{
			tGroupPtr = Parent->Parent;
		}
		// O.K now go downward the heirarchy and select everything
		OnDestroy1(tGroupPtr);
	}	

}

//---------------------------------------------------------------------
// OnDestroy1(GroupPtr tGroupPtr)
// 
// Usage: By OnDestroy() to traverse the group hierachy and delete the extra pointers
//---------------------------------------------------------------------
void GroupStruct::OnDestroy1(GroupPtr tGroupPtr)
{	
	if (tGroupPtr->Sibling != NULL)
	{
		OnDestroy1(tGroupPtr->Sibling);
	}
	if (tGroupPtr->Child != NULL)
	{
		if (tGroupPtr->Child->GroupType == GroupSeperable)
			OnDestroy1(tGroupPtr->Child);
	}


	if (tGroupPtr->GroupType == GroupSeperable)
	{        
		if (tGroupPtr->Child != NULL)
		{
			OnDestroy2(tGroupPtr->Child);
			tGroupPtr->Parent->Child = NULL;
			tGroupPtr->Sibling = NULL;
			tGroupPtr->Parent = NULL;
		}
		delete tGroupPtr;
	}
	else
	{
		tGroupPtr->Parent = NULL;
	}
	

}


//---------------------------------------------------------------------
// OnDestroy2(GroupPtr tGroupPtr)
// 
// Usage: By OnDestroy1() to traverse object baring group pointers to NULL there pointers
//---------------------------------------------------------------------
void GroupStruct::OnDestroy2(GroupPtr tGroupPtr)
{
	if (tGroupPtr->Sibling != NULL)
	{
		OnDestroy2(tGroupPtr->Sibling);
	}

	tGroupPtr->Sibling = NULL;
	tGroupPtr->Parent = NULL;
}
